/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemSeedsWheat;
import cn.nukkit.level.particle.BoneMealParticle;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;
import java.util.concurrent.ThreadLocalRandom;

public class BlockDoublePlant
extends BlockFlowable {
    public static final int SUNFLOWER = 0;
    public static final int LILAC = 1;
    public static final int TALL_GRASS = 2;
    public static final int LARGE_FERN = 3;
    public static final int ROSE_BUSH = 4;
    public static final int PEONY = 5;
    public static final int TOP_HALF_BITMASK = 8;
    private static final String[] NAMES = new String[]{"Sunflower", "Lilac", "Double Tallgrass", "Large Fern", "Rose Bush", "Peony"};

    public BlockDoublePlant() {
        this(0);
    }

    public BlockDoublePlant(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 175;
    }

    @Override
    public boolean canBeReplaced() {
        return this.getDamage() == 2 || this.getDamage() == 3;
    }

    @Override
    public String getName() {
        return NAMES[this.getDamage() > 5 ? 0 : this.getDamage()];
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1) {
            if ((this.getDamage() & 8) == 8) {
                if (this.down().getId() != 175) {
                    this.getLevel().setBlock((Vector3)this, Block.get(0), false, true);
                    return 1;
                }
            } else if (this.down().isTransparent() || this.up().getId() != 175) {
                this.getLevel().useBreakOn(this);
                return 1;
            }
        }
        return 0;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        Block down = this.down();
        Block up = this.up();
        if (up.getId() == 0 && (down.getId() == 2 || down.getId() == 3)) {
            this.getLevel().setBlock((Vector3)block, this, true, false);
            this.getLevel().setBlock((Vector3)up, Block.get(175, this.getDamage() ^ 8), true, true);
            return true;
        }
        return false;
    }

    @Override
    public boolean onBreak(Item item) {
        Block down = this.down();
        if ((this.getDamage() & 8) == 8) {
            this.getLevel().useBreakOn(down);
        } else {
            this.getLevel().setBlock((Vector3)this, Block.get(0), true, true);
        }
        return true;
    }

    @Override
    public Item[] getDrops(Item item) {
        if ((this.getDamage() & 8) != 8) {
            switch (this.getDamage() & 7) {
                case 2: 
                case 3: {
                    boolean dropSeeds;
                    boolean bl = dropSeeds = ThreadLocalRandom.current().nextInt(10) == 0;
                    if (item.isShears()) {
                        if (dropSeeds) {
                            return new Item[]{new ItemSeedsWheat((Integer)0, 1), this.toItem()};
                        }
                        return new Item[]{this.toItem()};
                    }
                    if (dropSeeds) {
                        return new Item[]{new ItemSeedsWheat()};
                    }
                    return new Item[0];
                }
            }
            return new Item[]{this.toItem()};
        }
        return new Item[0];
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.FOLIAGE_BLOCK_COLOR;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        if (item.isFertilizer()) {
            switch (this.getDamage() & 7) {
                case 0: 
                case 1: 
                case 4: 
                case 5: {
                    if (player != null && (player.gamemode & 1) == 0) {
                        --item.count;
                    }
                    this.level.addParticle(new BoneMealParticle(this));
                    this.level.dropItem(this, this.toItem());
                }
            }
            return true;
        }
        return false;
    }
}

