/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.blockentity.BlockEntityEnderChest;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.StringTag;
import cn.nukkit.nbt.tag.Tag;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.Faceable;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class BlockEnderChest
extends BlockTransparentMeta
implements Faceable {
    private Set<Player> viewers = new HashSet<Player>();

    public BlockEnderChest() {
        this(0);
    }

    public BlockEnderChest(int meta) {
        super(meta);
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public int getId() {
        return 130;
    }

    @Override
    public int getLightLevel() {
        return 7;
    }

    @Override
    public int getWaterloggingLevel() {
        return 1;
    }

    @Override
    public String getName() {
        return "Chest";
    }

    @Override
    public double getHardness() {
        return 22.5;
    }

    @Override
    public double getResistance() {
        return 3000.0;
    }

    @Override
    public int getToolType() {
        return 3;
    }

    @Override
    public double getMinX() {
        return this.x + 0.0625;
    }

    @Override
    public double getMinZ() {
        return this.z + 0.0625;
    }

    @Override
    public double getMaxX() {
        return this.x + 0.9375;
    }

    @Override
    public double getMaxY() {
        return this.y + 0.9475;
    }

    @Override
    public double getMaxZ() {
        return this.z + 0.9375;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        BlockEntityEnderChest ender;
        int[] faces = new int[]{2, 5, 3, 4};
        this.setDamage(faces[player != null ? player.getDirection().getHorizontalIndex() : 0]);
        this.getLevel().setBlock((Vector3)block, this, true, true);
        CompoundTag nbt = new CompoundTag("").putString("id", "EnderChest").putInt("x", (int)this.x).putInt("y", (int)this.y).putInt("z", (int)this.z);
        if (item.hasCustomName()) {
            nbt.putString("CustomName", item.getCustomName());
        }
        if (item.hasCustomBlockData()) {
            Map<String, Tag> customData = item.getCustomBlockData().getTags();
            for (Map.Entry<String, Tag> tag : customData.entrySet()) {
                nbt.put(tag.getKey(), tag.getValue());
            }
        }
        return (ender = (BlockEntityEnderChest)BlockEntity.createBlockEntity("EnderChest", this.getLevel().getChunk((int)this.x >> 4, (int)this.z >> 4), nbt, new Object[0])) != null;
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        if (player != null) {
            BlockEntityEnderChest chest;
            Block top = this.up();
            if (!top.isTransparent()) {
                return true;
            }
            BlockEntity t = this.getLevel().getBlockEntity(this);
            if (t instanceof BlockEntityEnderChest) {
                chest = (BlockEntityEnderChest)t;
            } else {
                CompoundTag nbt = new CompoundTag("").putString("id", "EnderChest").putInt("x", (int)this.x).putInt("y", (int)this.y).putInt("z", (int)this.z);
                chest = (BlockEntityEnderChest)BlockEntity.createBlockEntity("EnderChest", this.getLevel().getChunk((int)this.x >> 4, (int)this.z >> 4), nbt, new Object[0]);
                if (chest == null) {
                    return false;
                }
            }
            if (chest.namedTag.contains("Lock") && chest.namedTag.get("Lock") instanceof StringTag && !chest.namedTag.getString("Lock").equals(item.getCustomName())) {
                return true;
            }
            player.setViewingEnderChest(this);
            player.addWindow(player.getEnderChestInventory());
        }
        return true;
    }

    @Override
    public Item[] getDrops(Item item) {
        if (item.isPickaxe() && item.getTier() >= 1) {
            return new Item[]{Item.get(49, 0, 8)};
        }
        return new Item[0];
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.OBSIDIAN_BLOCK_COLOR;
    }

    public Set<Player> getViewers() {
        return this.viewers;
    }

    @Override
    public boolean canBePushed() {
        return false;
    }

    @Override
    public boolean canBePulled() {
        return false;
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }

    @Override
    public boolean canSilkTouch() {
        return true;
    }

    @Override
    public Item toItem() {
        return new ItemBlock(this, (Integer)0);
    }

    @Override
    public BlockFace getBlockFace() {
        return BlockFace.fromHorizontalIndex(this.getDamage() & 7);
    }
}

