/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockSolidMeta;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.blockentity.BlockEntityFurnace;
import cn.nukkit.inventory.ContainerInventory;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.level.Position;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.nbt.tag.StringTag;
import cn.nukkit.nbt.tag.Tag;
import cn.nukkit.utils.Faceable;
import java.util.Map;

public class BlockFurnaceBurning
extends BlockSolidMeta
implements Faceable {
    public BlockFurnaceBurning() {
        this(0);
    }

    public BlockFurnaceBurning(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 62;
    }

    @Override
    public String getName() {
        return "Burning Furnace";
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public double getHardness() {
        return 3.5;
    }

    @Override
    public double getResistance() {
        return 17.5;
    }

    @Override
    public int getToolType() {
        return 3;
    }

    @Override
    public int getLightLevel() {
        return 13;
    }

    protected String getEntityName() {
        return "Furnace";
    }

    protected BlockEntityFurnace createEntity(Position position, CompoundTag nbt) {
        return (BlockEntityFurnace)BlockEntity.createBlockEntity("Furnace", position, nbt, new Object[0]);
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        int[] faces = new int[]{2, 5, 3, 4};
        this.setDamage(faces[player != null ? player.getDirection().getHorizontalIndex() : 0]);
        this.getLevel().setBlock((Vector3)block, this, true, true);
        CompoundTag nbt = new CompoundTag().putList(new ListTag("Items")).putString("id", this.getEntityName()).putInt("x", (int)this.x).putInt("y", (int)this.y).putInt("z", (int)this.z);
        if (item.hasCustomName()) {
            nbt.putString("CustomName", item.getCustomName());
        }
        if (item.hasCustomBlockData()) {
            Map<String, Tag> customData = item.getCustomBlockData().getTags();
            for (Map.Entry<String, Tag> tag : customData.entrySet()) {
                nbt.put(tag.getKey(), tag.getValue());
            }
        }
        this.createEntity(this, nbt);
        return true;
    }

    @Override
    public boolean onBreak(Item item) {
        this.getLevel().setBlock((Vector3)this, Block.get(0), true, true);
        return true;
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        if (player != null) {
            BlockEntityFurnace furnace;
            BlockEntity t = this.getLevel().getBlockEntity(this);
            if (t instanceof BlockEntityFurnace) {
                furnace = (BlockEntityFurnace)t;
            } else {
                CompoundTag nbt = new CompoundTag().putList(new ListTag("Items")).putString("id", this.getEntityName()).putInt("x", (int)this.x).putInt("y", (int)this.y).putInt("z", (int)this.z);
                furnace = this.createEntity(this, nbt);
            }
            if (furnace.namedTag.contains("Lock") && furnace.namedTag.get("Lock") instanceof StringTag && !furnace.namedTag.getString("Lock").equals(item.getCustomName())) {
                return true;
            }
            player.addWindow(furnace.getInventory());
        }
        return true;
    }

    @Override
    public Item toItem() {
        return new ItemBlock(Block.get(61));
    }

    @Override
    public Item[] getDrops(Item item) {
        if (item.isPickaxe() && item.getTier() >= 1) {
            return new Item[]{this.toItem()};
        }
        return new Item[0];
    }

    @Override
    public boolean hasComparatorInputOverride() {
        return true;
    }

    @Override
    public int getComparatorInputOverride() {
        BlockEntity blockEntity = this.level.getBlockEntity(this);
        if (blockEntity instanceof BlockEntityFurnace) {
            return ContainerInventory.calculateRedstone(((BlockEntityFurnace)blockEntity).getInventory());
        }
        return super.getComparatorInputOverride();
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }

    @Override
    public BlockFace getBlockFace() {
        return BlockFace.fromHorizontalIndex(this.getDamage() & 7);
    }
}

