/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.blockentity.BlockEntityItemFrame;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemItemFrame;
import cn.nukkit.level.Position;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.SimpleAxisAlignedBB;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.Tag;
import java.util.Random;

public class BlockItemFrame
extends BlockTransparentMeta {
    private static final int[] FACING = new int[]{4, 5, 3, 2, 1, 0};
    private static final int FACING_BITMASK = 7;
    private static final int MAP_BIT = 8;

    public BlockItemFrame() {
        this(0);
    }

    public BlockItemFrame(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 199;
    }

    @Override
    public String getName() {
        return "Item Frame";
    }

    @Override
    @PowerNukkitDifference(info="Allow to stay in walls", since="1.3.0.0-PN")
    public int onUpdate(int type) {
        Block support;
        if (type == 1 && !(support = this.getSideAtLayer(0, this.getFacing())).isSolid() && support.getId() != 139) {
            this.level.useBreakOn(this);
            return type;
        }
        return 0;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public int getWaterloggingLevel() {
        return 1;
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        BlockEntity blockEntity = this.getLevel().getBlockEntity(this);
        BlockEntityItemFrame itemFrame = (BlockEntityItemFrame)blockEntity;
        if (itemFrame == null) {
            itemFrame = (BlockEntityItemFrame)BlockEntity.createBlockEntity("ItemFrame", (Position)this, BlockEntity.getDefaultCompound(this, "ItemFrame").putByte("ItemRotation", 0).putFloat("ItemDropChance", 1.0f), new Object[0]);
        }
        if (itemFrame == null) {
            return false;
        }
        if (itemFrame.getItem().getId() == 0) {
            Item itemOnFrame = item.clone();
            if (player != null && player.isSurvival()) {
                itemOnFrame.setCount(itemOnFrame.getCount() - 1);
                player.getInventory().setItemInHand(itemOnFrame);
            }
            itemOnFrame.setCount(1);
            itemFrame.setItem(itemOnFrame);
            this.getLevel().addLevelEvent(this, 1040);
        } else {
            itemFrame.setItemRotation((itemFrame.getItemRotation() + 1) % 8);
            this.getLevel().addLevelEvent(this, 1044);
        }
        return true;
    }

    @Override
    @PowerNukkitDifference(info="Allow to place on walls", since="1.3.0.0-PN")
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        if (face.getIndex() > 1 && (target.getId() == 139 || target.isSolid() && (!block.isSolid() || block.canBeReplaced()))) {
            BlockEntityItemFrame frame;
            this.setDamage(FACING[face.getIndex()]);
            this.getLevel().setBlock((Vector3)block, this, true, true);
            CompoundTag nbt = new CompoundTag().putString("id", "ItemFrame").putInt("x", (int)block.x).putInt("y", (int)block.y).putInt("z", (int)block.z).putByte("ItemRotation", 0).putFloat("ItemDropChance", 1.0f);
            if (item.hasCustomBlockData()) {
                for (Tag aTag : item.getCustomBlockData().getAllTags()) {
                    nbt.put(aTag.getName(), aTag);
                }
            }
            return (frame = (BlockEntityItemFrame)BlockEntity.createBlockEntity("ItemFrame", this.getLevel().getChunk((int)this.x >> 4, (int)this.z >> 4), nbt, new Object[0])) != null;
        }
        return false;
    }

    @Override
    public boolean onBreak(Item item) {
        this.getLevel().setBlock(this, this.layer, Block.get(0), true, true);
        this.getLevel().addLevelEvent(this, 1042);
        return true;
    }

    @Override
    public Item[] getDrops(Item item) {
        BlockEntity blockEntity = this.getLevel().getBlockEntity(this);
        BlockEntityItemFrame itemFrame = (BlockEntityItemFrame)blockEntity;
        int chance = new Random().nextInt(100) + 1;
        if (itemFrame != null && (float)chance <= itemFrame.getItemDropChance() * 100.0f) {
            return new Item[]{this.toItem(), itemFrame.getItem().clone()};
        }
        return new Item[]{this.toItem()};
    }

    @Override
    public Item toItem() {
        return new ItemItemFrame();
    }

    @Override
    public boolean canPassThrough() {
        return true;
    }

    @Override
    public boolean hasComparatorInputOverride() {
        return true;
    }

    @Override
    public int getComparatorInputOverride() {
        BlockEntity blockEntity = this.level.getBlockEntity(this);
        if (blockEntity instanceof BlockEntityItemFrame) {
            return ((BlockEntityItemFrame)blockEntity).getAnalogOutput();
        }
        return super.getComparatorInputOverride();
    }

    public BlockFace getFacing() {
        switch (this.getDamage() & 7) {
            case 0: {
                return BlockFace.WEST;
            }
            case 1: {
                return BlockFace.EAST;
            }
            case 2: {
                return BlockFace.NORTH;
            }
            case 3: {
                return BlockFace.SOUTH;
            }
        }
        return null;
    }

    @Override
    public double getHardness() {
        return 0.25;
    }

    @Override
    public boolean breaksWhenMoved() {
        return true;
    }

    @Override
    public boolean sticksToPiston() {
        return false;
    }

    @Override
    @PowerNukkitOnly(value="Will calculate the correct AABB")
    @Since(value="1.3.0.0-PN")
    protected AxisAlignedBB recalculateBoundingBox() {
        double[][] aabb = new double[][]{{0.125, 0.875}, {0.125, 0.875}, {0.125, 0.875}};
        BlockFace facing = this.getFacing();
        if (facing.getAxisDirection() == BlockFace.AxisDirection.POSITIVE) {
            int axis = facing.getAxis().ordinal();
            aabb[axis][0] = 0.0;
            aabb[axis][1] = 0.0625;
        }
        return new SimpleAxisAlignedBB(aabb[0][0] + this.x, aabb[1][0] + this.y, aabb[2][0] + this.z, aabb[0][1] + this.x, aabb[1][1] + this.y, aabb[2][1] + this.z);
    }
}

