/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockSolidMeta;
import cn.nukkit.item.Item;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.Faceable;

public class BlockJigsaw
extends BlockSolidMeta
implements Faceable {
    public BlockJigsaw() {
        this(0);
    }

    public BlockJigsaw(int meta) {
        super(meta % 6);
    }

    @Override
    public void setDamage(int meta) {
        super.setDamage(meta % 6);
    }

    @Override
    public String getName() {
        return "Jigsaw";
    }

    @Override
    public int getId() {
        return 466;
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }

    @Override
    public double getResistance() {
        return 1.8E7;
    }

    @Override
    public double getHardness() {
        return -1.0;
    }

    @Override
    public boolean isBreakable(Item item) {
        return false;
    }

    @Override
    public boolean canBePushed() {
        return false;
    }

    @Override
    public BlockFace getBlockFace() {
        return BlockFace.fromIndex(this.getDamage());
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        if (Math.abs(player.x - this.x) < 2.0 && Math.abs(player.z - this.z) < 2.0) {
            double y = player.y + (double)player.getEyeHeight();
            if (y - this.y > 2.0) {
                this.setDamage(BlockFace.UP.getIndex());
            } else if (this.y - y > 0.0) {
                this.setDamage(BlockFace.DOWN.getIndex());
            } else {
                this.setDamage(player.getHorizontalFacing().getOpposite().getIndex());
            }
        } else {
            this.setDamage(player.getHorizontalFacing().getOpposite().getIndex());
        }
        this.level.setBlock((Vector3)block, this, true, false);
        return super.place(item, block, target, face, fx, fy, fz, player);
    }
}

