/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockFence;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.block.BlockLeaves;
import cn.nukkit.block.BlockLiquid;
import cn.nukkit.block.BlockSlab;
import cn.nukkit.block.BlockStairs;
import cn.nukkit.block.BlockWall;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;

public class BlockLantern
extends BlockFlowable {
    public BlockLantern() {
        this(0);
    }

    public BlockLantern(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 463;
    }

    @Override
    public String getName() {
        return "Lantern";
    }

    private boolean isBlockAboveValid() {
        Block up = this.up();
        if (up instanceof BlockLeaves) {
            return false;
        }
        if (up instanceof BlockFence || up instanceof BlockWall) {
            return true;
        }
        if (up instanceof BlockSlab) {
            return (up.getDamage() & 8) == 0;
        }
        if (up instanceof BlockStairs) {
            return (up.getDamage() & 4) == 0;
        }
        return up.isSolid();
    }

    private boolean isBlockUnderValid() {
        Block down = this.down();
        if (down instanceof BlockLeaves) {
            return false;
        }
        if (down instanceof BlockFence || down instanceof BlockWall) {
            return true;
        }
        if (down instanceof BlockSlab) {
            return (down.getDamage() & 8) == 8;
        }
        if (down instanceof BlockStairs) {
            return (down.getDamage() & 4) == 4;
        }
        return down.isSolid();
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        boolean hanging;
        if (this.getLevelBlock() instanceof BlockLiquid || this.getLevelBlockAtLayer(1) instanceof BlockLiquid) {
            return false;
        }
        boolean bl = hanging = face != BlockFace.UP && this.isBlockAboveValid() && (!this.isBlockUnderValid() || face == BlockFace.DOWN);
        if (!this.isBlockUnderValid() && !hanging) {
            return false;
        }
        if (hanging) {
            this.setDamage(1);
        } else {
            this.setDamage(0);
        }
        this.getLevel().setBlock((Vector3)this, this, true, true);
        return true;
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1) {
            if (this.getDamage() == 0) {
                if (!this.isBlockUnderValid()) {
                    this.level.useBreakOn(this);
                }
            } else if (!this.isBlockAboveValid()) {
                this.level.useBreakOn(this);
            }
            return type;
        }
        return 0;
    }

    @Override
    public int getLightLevel() {
        return 15;
    }

    @Override
    public double getResistance() {
        return 17.5;
    }

    @Override
    public double getHardness() {
        return 5.0;
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }

    @Override
    public int getToolType() {
        return 3;
    }

    @Override
    public double getMinX() {
        return this.x + 0.3125;
    }

    @Override
    public double getMinY() {
        return this.y + (this.getDamage() == 0 ? 0.0 : 0.0625);
    }

    @Override
    public double getMinZ() {
        return this.z + 0.3125;
    }

    @Override
    public double getMaxX() {
        return this.x + 0.6875;
    }

    @Override
    public double getMaxY() {
        return this.y + (this.getDamage() == 0 ? 0.4375 : 0.5);
    }

    @Override
    public double getMaxZ() {
        return this.z + 0.6875;
    }

    @Override
    public Item toItem() {
        return new ItemBlock(new BlockLantern());
    }

    @Override
    public boolean canPassThrough() {
        return false;
    }

    @Override
    protected AxisAlignedBB recalculateBoundingBox() {
        return this;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.IRON_BLOCK_COLOR;
    }
}

