/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.event.level.StructureGrowEvent;
import cn.nukkit.item.Item;
import cn.nukkit.level.ListChunkManager;
import cn.nukkit.level.generator.object.BasicGenerator;
import cn.nukkit.level.generator.object.tree.NewJungleTree;
import cn.nukkit.level.generator.object.tree.ObjectDarkOakTree;
import cn.nukkit.level.generator.object.tree.ObjectJungleBigTree;
import cn.nukkit.level.generator.object.tree.ObjectSavannaTree;
import cn.nukkit.level.generator.object.tree.ObjectTree;
import cn.nukkit.level.generator.object.tree.TreeGenerator;
import cn.nukkit.level.particle.BoneMealParticle;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.NukkitRandom;
import cn.nukkit.math.Vector2;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;

public class BlockSapling
extends BlockFlowable {
    public static final int OAK = 0;
    public static final int SPRUCE = 1;
    public static final int BIRCH = 2;
    public static final int BIRCH_TALL = 10;
    public static final int JUNGLE = 3;
    public static final int ACACIA = 4;
    public static final int DARK_OAK = 5;

    public BlockSapling() {
        this(0);
    }

    public BlockSapling(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 6;
    }

    @Override
    public String getName() {
        String[] names = new String[]{"Oak Sapling", "Spruce Sapling", "Birch Sapling", "Jungle Sapling", "Acacia Sapling", "Dark Oak Sapling", "", ""};
        return names[this.getDamage() & 7];
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        Block down = this.down();
        if (down.getId() == 2 || down.getId() == 3 || down.getId() == 60 || down.getId() == 243) {
            this.getLevel().setBlock((Vector3)block, this, true, true);
            return true;
        }
        return false;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        if (item.isFertilizer()) {
            if (player != null && (player.gamemode & 1) == 0) {
                --item.count;
            }
            this.level.addParticle(new BoneMealParticle(this));
            if ((double)ThreadLocalRandom.current().nextFloat() >= 0.45) {
                return true;
            }
            this.grow();
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int onUpdate(int type) {
        if (type == 1) {
            if (!this.down().isTransparent()) return 1;
            this.getLevel().useBreakOn(this);
            return 1;
        }
        if (type != 2) return 1;
        if (ThreadLocalRandom.current().nextInt(1, 8) != 1 || this.getLevel().getFullLight(this.add(0.0, 1.0, 0.0)) < 9) return 2;
        if ((this.getDamage() & 8) == 8) {
            this.grow();
            return 1;
        } else {
            this.setDamage(this.getDamage() | 8);
            this.getLevel().setBlock((Vector3)this, this, true);
            return 2;
        }
    }

    private void grow() {
        TreeGenerator generator = null;
        boolean bigTree = false;
        Vector3 vector3 = new Vector3();
        switch (this.getDamage() & 7) {
            case 3: {
                Vector2 vector2 = this.findSaplings(3);
                if (vector2 != null) {
                    vector3 = this.add(vector2.getFloorX(), 0.0, vector2.getFloorY());
                    generator = new ObjectJungleBigTree(10, 20, Block.get(17, 3), Block.get(18, 3));
                    bigTree = true;
                }
                if (bigTree) break;
                generator = new NewJungleTree(4, 7);
                break;
            }
            case 4: {
                generator = new ObjectSavannaTree();
                break;
            }
            case 5: {
                Vector2 vector2 = this.findSaplings(5);
                if (vector2 != null) {
                    vector3 = this.add(vector2.getFloorX(), 0.0, vector2.getFloorY());
                    generator = new ObjectDarkOakTree();
                    bigTree = true;
                }
                if (bigTree) break;
                return;
            }
            default: {
                ListChunkManager chunkManager = new ListChunkManager(this.level);
                ObjectTree.growTree(chunkManager, this.getFloorX(), this.getFloorY(), this.getFloorZ(), new NukkitRandom(), this.getDamage() & 7);
                StructureGrowEvent ev = new StructureGrowEvent(this, chunkManager.getBlocks());
                this.level.getServer().getPluginManager().callEvent(ev);
                if (ev.isCancelled()) {
                    return;
                }
                for (Block block : ev.getBlockList()) {
                    this.level.setBlockAt(block.getFloorX(), block.getFloorY(), block.getFloorZ(), block.getId(), block.getDamage());
                }
                return;
            }
        }
        if (bigTree) {
            this.level.setBlock(vector3, BlockSapling.get(0), true, false);
            this.level.setBlock(vector3.add(1.0, 0.0, 0.0), BlockSapling.get(0), true, false);
            this.level.setBlock(vector3.add(0.0, 0.0, 1.0), BlockSapling.get(0), true, false);
            this.level.setBlock(vector3.add(1.0, 0.0, 1.0), BlockSapling.get(0), true, false);
        } else {
            this.level.setBlock((Vector3)this, BlockSapling.get(0), true, false);
        }
        ListChunkManager chunkManager = new ListChunkManager(this.level);
        boolean success = ((BasicGenerator)generator).generate(chunkManager, new NukkitRandom(), vector3);
        StructureGrowEvent ev = new StructureGrowEvent(this, chunkManager.getBlocks());
        this.level.getServer().getPluginManager().callEvent(ev);
        if (ev.isCancelled() || !success) {
            if (bigTree) {
                this.level.setBlock(vector3, this, true, false);
                this.level.setBlock(vector3.add(1.0, 0.0, 0.0), this, true, false);
                this.level.setBlock(vector3.add(0.0, 0.0, 1.0), this, true, false);
                this.level.setBlock(vector3.add(1.0, 0.0, 1.0), this, true, false);
            } else {
                this.level.setBlock((Vector3)this, this, true, false);
            }
            return;
        }
        for (Block block : ev.getBlockList()) {
            this.level.setBlockAt(block.getFloorX(), block.getFloorY(), block.getFloorZ(), block.getId(), block.getDamage());
        }
    }

    private Vector2 findSaplings(int type) {
        ArrayList<List<Vector2>> validVectorsList = new ArrayList<List<Vector2>>();
        validVectorsList.add(Arrays.asList(new Vector2(0.0, 0.0), new Vector2(1.0, 0.0), new Vector2(0.0, 1.0), new Vector2(1.0, 1.0)));
        validVectorsList.add(Arrays.asList(new Vector2(0.0, 0.0), new Vector2(-1.0, 0.0), new Vector2(0.0, -1.0), new Vector2(-1.0, -1.0)));
        validVectorsList.add(Arrays.asList(new Vector2(0.0, 0.0), new Vector2(1.0, 0.0), new Vector2(0.0, -1.0), new Vector2(1.0, -1.0)));
        validVectorsList.add(Arrays.asList(new Vector2(0.0, 0.0), new Vector2(-1.0, 0.0), new Vector2(0.0, 1.0), new Vector2(-1.0, 1.0)));
        for (List list : validVectorsList) {
            boolean correct = true;
            for (Vector2 vector2 : list) {
                if (this.isSameType(this.add(vector2.x, 0.0, vector2.y), type)) continue;
                correct = false;
            }
            if (!correct) continue;
            int lowestX = 0;
            int lowestZ = 0;
            for (Vector2 vector2 : list) {
                if (vector2.getFloorX() < lowestX) {
                    lowestX = vector2.getFloorX();
                }
                if (vector2.getFloorY() >= lowestZ) continue;
                lowestZ = vector2.getFloorY();
            }
            return new Vector2(lowestX, lowestZ);
        }
        return null;
    }

    public boolean isSameType(Vector3 pos, int type) {
        Block block = this.level.getBlock(pos);
        return block.getId() == this.getId() && (block.getDamage() & 7) == (type & 7);
    }

    @Override
    public Item toItem() {
        return Item.get(6, this.getDamage() & 7);
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.FOLIAGE_BLOCK_COLOR;
    }
}

