/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.blockentity.BlockEntitySign;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemSign;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.Tag;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.Faceable;

public class BlockSignPost
extends BlockTransparentMeta
implements Faceable {
    public BlockSignPost() {
        this(0);
    }

    public BlockSignPost(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 63;
    }

    @Override
    public double getHardness() {
        return 1.0;
    }

    @Override
    public double getResistance() {
        return 5.0;
    }

    @Override
    public boolean isSolid() {
        return false;
    }

    @Override
    public String getName() {
        return "Sign Post";
    }

    @Override
    public AxisAlignedBB getBoundingBox() {
        return null;
    }

    @Override
    public int getWaterloggingLevel() {
        return 1;
    }

    protected int getPostId() {
        return this.getId();
    }

    public int getWallId() {
        return 68;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        if (face != BlockFace.DOWN) {
            BlockEntitySign sign;
            CompoundTag nbt = new CompoundTag().putString("id", "Sign").putInt("x", (int)block.x).putInt("y", (int)block.y).putInt("z", (int)block.z).putString("Text1", "").putString("Text2", "").putString("Text3", "").putString("Text4", "");
            if (face == BlockFace.UP) {
                this.setDamage((int)Math.floor((player.yaw + 180.0) * 16.0 / 360.0 + 0.5) & 0xF);
                this.getLevel().setBlock((Vector3)block, Block.get(this.getPostId(), this.getDamage()), true);
            } else {
                this.setDamage(face.getIndex());
                this.getLevel().setBlock((Vector3)block, Block.get(this.getWallId(), this.getDamage()), true);
            }
            if (player != null) {
                nbt.putString("Creator", player.getUniqueId().toString());
            }
            if (item.hasCustomBlockData()) {
                for (Tag aTag : item.getCustomBlockData().getAllTags()) {
                    nbt.put(aTag.getName(), aTag);
                }
            }
            return (sign = (BlockEntitySign)BlockEntity.createBlockEntity("Sign", this.getLevel().getChunk((int)block.x >> 4, (int)block.z >> 4), nbt, new Object[0])) != null;
        }
        return false;
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1 && this.down().getId() == 0) {
            this.getLevel().useBreakOn(this);
            return 1;
        }
        return 0;
    }

    @Override
    public Item toItem() {
        return new ItemSign();
    }

    @Override
    public int getToolType() {
        return 4;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.AIR_BLOCK_COLOR;
    }

    @Override
    public BlockFace getBlockFace() {
        return BlockFace.fromIndex(this.getDamage() & 7);
    }

    @Override
    public boolean breaksWhenMoved() {
        return true;
    }
}

