/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.item.Item;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.SimpleAxisAlignedBB;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.Faceable;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;

public abstract class BlockStairs
extends BlockTransparentMeta
implements Faceable {
    private static final IntList FACES = new IntArrayList(new int[]{2, 1, 3, 0});

    protected BlockStairs(int meta) {
        super(meta);
    }

    @Override
    public double getMinY() {
        return this.y + ((this.getDamage() & 4) > 0 ? 0.5 : 0.0);
    }

    @Override
    public double getMaxY() {
        return this.y + ((this.getDamage() & 4) > 0 ? 1.0 : 0.5);
    }

    @Override
    public boolean isSolid(BlockFace side) {
        return side == BlockFace.UP && (this.getDamage() & 4) == 4 || side == BlockFace.DOWN && (this.getDamage() & 4) != 4;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        this.setDamage(FACES.getInt(player != null ? player.getDirection().getHorizontalIndex() : 0));
        if (fy > 0.5 && face != BlockFace.UP || face == BlockFace.DOWN) {
            this.setDamage(this.getDamage() | 4);
        }
        this.getLevel().setBlock((Vector3)block, this, true, true);
        return true;
    }

    @Override
    public Item[] getDrops(Item item) {
        if (item.isPickaxe() && item.getTier() >= 1) {
            return new Item[]{this.toItem()};
        }
        return new Item[0];
    }

    @Override
    public Item toItem() {
        Item item = super.toItem();
        item.setDamage(0);
        return item;
    }

    @Override
    public boolean collidesWithBB(AxisAlignedBB bb) {
        int damage = this.getDamage();
        int side = damage & 3;
        double f = 0.0;
        double f1 = 0.5;
        double f2 = 0.5;
        double f3 = 1.0;
        if ((damage & 4) > 0) {
            f = 0.5;
            f1 = 1.0;
            f2 = 0.0;
            f3 = 0.5;
        }
        if (bb.intersectsWith(new SimpleAxisAlignedBB(this.x, this.y + f, this.z, this.x + 1.0, this.y + f1, this.z + 1.0))) {
            return true;
        }
        return side == 0 ? bb.intersectsWith(new SimpleAxisAlignedBB(this.x + 0.5, this.y + f2, this.z, this.x + 1.0, this.y + f3, this.z + 1.0)) : (side == 1 ? bb.intersectsWith(new SimpleAxisAlignedBB(this.x, this.y + f2, this.z, this.x + 0.5, this.y + f3, this.z + 1.0)) : (side == 2 ? bb.intersectsWith(new SimpleAxisAlignedBB(this.x, this.y + f2, this.z + 0.5, this.x + 1.0, this.y + f3, this.z + 1.0)) : side == 3 && bb.intersectsWith(new SimpleAxisAlignedBB(this.x, this.y + f2, this.z, this.x + 1.0, this.y + f3, this.z + 0.5))));
    }

    @Override
    public int getWaterloggingLevel() {
        return 1;
    }

    @Override
    @PowerNukkitDifference(info="Was returning the wrong face", since="1.3.0.0-PN")
    public BlockFace getBlockFace() {
        int stairFace = this.getDamage() & 3;
        int horizontalIndex = FACES.indexOf(stairFace);
        return BlockFace.fromHorizontalIndex(horizontalIndex).getOpposite();
    }
}

