/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Server;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockCrops;
import cn.nukkit.event.block.BlockGrowEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemSeedsPumpkin;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.NukkitRandom;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.Faceable;

@PowerNukkitOnly(value="Implements Faceable only on PowerNukkit since 1.3.0.0-PN")
public class BlockStemPumpkin
extends BlockCrops
implements Faceable {
    public BlockStemPumpkin() {
        this(0);
    }

    public BlockStemPumpkin(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 104;
    }

    @Override
    public String getName() {
        return "Pumpkin Stem";
    }

    @Override
    @PowerNukkitOnly(value="Implements Faceable only on PowerNukkit since 1.3.0.0-PN")
    @Since(value="1.3.0.0-PN")
    public BlockFace getBlockFace() {
        return BlockFace.fromIndex(this.getDamage() >> 3 & 7);
    }

    @Override
    @PowerNukkitOnly
    @Since(value="1.3.0.0-PN")
    public void setBlockFace(BlockFace face) {
        this.setDamage(this.getDamage() & 0xFFFFFFC7 | face.getIndex() << 3);
    }

    @Override
    @PowerNukkitDifference(info="Will bind to the pumpkin by the server-side", since="1.3.0.0-PN")
    public int onUpdate(int type) {
        if (type == 1) {
            if (this.down().getId() != 60) {
                this.getLevel().useBreakOn(this);
                return 1;
            }
        } else if (type == 2) {
            NukkitRandom random = new NukkitRandom();
            if (random.nextRange(1, 2) == 1 && this.getLevel().getFullLight(this) >= 9) {
                if (this.getDamage() < 7) {
                    Block block = this.clone();
                    block.setDamage(block.getDamage() + 1);
                    BlockGrowEvent ev = new BlockGrowEvent(this, block);
                    Server.getInstance().getPluginManager().callEvent(ev);
                    if (!ev.isCancelled()) {
                        this.getLevel().setBlock((Vector3)this, ev.getNewState(), true);
                    }
                    return 2;
                }
                for (BlockFace face : BlockFace.Plane.HORIZONTAL) {
                    Block b = this.getSide(face);
                    if (b.getId() != 86) continue;
                    return 2;
                }
                BlockFace sideFace = BlockFace.Plane.HORIZONTAL.random(random);
                Block side = this.getSide(sideFace);
                Block d = side.down();
                if (side.getId() == 0 && (d.getId() == 60 || d.getId() == 2 || d.getId() == 3)) {
                    BlockGrowEvent ev = new BlockGrowEvent(side, Block.get(86));
                    Server.getInstance().getPluginManager().callEvent(ev);
                    if (!ev.isCancelled()) {
                        this.getLevel().setBlock((Vector3)side, ev.getNewState(), true);
                        this.setBlockFace(sideFace);
                        this.getLevel().setBlock((Vector3)this, this, true);
                    }
                }
            }
            return 2;
        }
        return 0;
    }

    @Override
    public Item toItem() {
        return new ItemSeedsPumpkin();
    }

    @Override
    public Item[] getDrops(Item item) {
        NukkitRandom random = new NukkitRandom();
        return new Item[]{new ItemSeedsPumpkin((Integer)0, random.nextRange(0, 3))};
    }
}

