/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.event.block.BlockRedstoneEvent;
import cn.nukkit.event.block.DoorToggleEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.SimpleAxisAlignedBB;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.Faceable;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;

public class BlockTrapdoor
extends BlockTransparentMeta
implements Faceable {
    private static final IntList FACES = new IntArrayList(new int[]{2, 1, 3, 0});
    public static final int TRAPDOOR_OPEN_BIT = 8;
    public static final int TRAPDOOR_TOP_BIT = 4;
    private static final AxisAlignedBB[] boundingBoxDamage = new AxisAlignedBB[16];

    public BlockTrapdoor() {
        this(0);
    }

    public BlockTrapdoor(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 96;
    }

    @Override
    public String getName() {
        return "Oak Trapdoor";
    }

    @Override
    public double getHardness() {
        return 3.0;
    }

    @Override
    public double getResistance() {
        return 15.0;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public int getToolType() {
        return 4;
    }

    @Override
    public int getWaterloggingLevel() {
        return 1;
    }

    @PowerNukkitDifference(info="The bounding box was fixed", since="1.3.0.0-PN")
    private AxisAlignedBB getRelativeBoundingBox() {
        return boundingBoxDamage[this.getDamage()];
    }

    @Override
    public double getMinX() {
        return this.x + this.getRelativeBoundingBox().getMinX();
    }

    @Override
    public double getMaxX() {
        return this.x + this.getRelativeBoundingBox().getMaxX();
    }

    @Override
    public double getMinY() {
        return this.y + this.getRelativeBoundingBox().getMinY();
    }

    @Override
    public double getMaxY() {
        return this.y + this.getRelativeBoundingBox().getMaxY();
    }

    @Override
    public double getMinZ() {
        return this.z + this.getRelativeBoundingBox().getMinZ();
    }

    @Override
    public double getMaxZ() {
        return this.z + this.getRelativeBoundingBox().getMaxZ();
    }

    @Override
    public int onUpdate(int type) {
        if (type == 6 && this.level.getServer().isRedstoneEnabled() && (!this.isOpen() && this.level.isBlockPowered(this.getLocation()) || this.isOpen() && !this.level.isBlockPowered(this.getLocation()))) {
            this.level.getServer().getPluginManager().callEvent(new BlockRedstoneEvent(this, this.isOpen() ? 15 : 0, this.isOpen() ? 0 : 15));
            this.setDamage(this.getDamage() ^ 8);
            this.level.setBlock((Vector3)this, this, true);
            this.level.addLevelEvent(this.add(0.5, 0.5, 0.5), 1003);
            return type;
        }
        return 0;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        boolean top;
        BlockFace facing;
        int meta = 0;
        if (face.getAxis().isHorizontal() || player == null) {
            facing = face;
            top = fy > 0.5;
        } else {
            facing = player.getDirection().getOpposite();
            top = face != BlockFace.UP;
        }
        int faceBit = FACES.getInt(facing.getHorizontalIndex());
        meta |= faceBit;
        if (top) {
            meta |= 4;
        }
        this.setDamage(meta);
        this.getLevel().setBlock((Vector3)block, this, true, true);
        return true;
    }

    @Override
    public Item toItem() {
        return new ItemBlock(this, (Integer)0);
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        if (this.toggle(player)) {
            this.level.addLevelEvent(this.add(0.5, 0.5, 0.5), 1003);
            return true;
        }
        return false;
    }

    public boolean toggle(Player player) {
        DoorToggleEvent ev = new DoorToggleEvent(this, player);
        this.getLevel().getServer().getPluginManager().callEvent(ev);
        if (ev.isCancelled()) {
            return false;
        }
        this.setDamage(this.getDamage() ^ 8);
        this.getLevel().setBlock((Vector3)this, this, true);
        return true;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.WOOD_BLOCK_COLOR;
    }

    public boolean isOpen() {
        return (this.getDamage() & 8) != 0;
    }

    public boolean isTop() {
        return (this.getDamage() & 4) != 0;
    }

    @Override
    @PowerNukkitDifference(info="Was returning the wrong face", since="1.3.0.0-PN")
    public BlockFace getBlockFace() {
        return BlockTrapdoor.getFaceForDamage(this.getDamage());
    }

    private static BlockFace getFaceForDamage(int damage) {
        int stairFace = damage & 3;
        int horizontalIndex = FACES.indexOf(stairFace);
        return BlockFace.fromHorizontalIndex(horizontalIndex);
    }

    static {
        for (int damage = 0; damage < 16; ++damage) {
            double f = 0.1875;
            SimpleAxisAlignedBB bb = (damage & 4) > 0 ? new SimpleAxisAlignedBB(0.0, 1.0 - f, 0.0, 1.0, 1.0, 1.0) : new SimpleAxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0 + f, 1.0);
            if ((damage & 8) > 0) {
                BlockFace face = BlockTrapdoor.getFaceForDamage(damage);
                if (face == BlockFace.NORTH) {
                    bb.setBounds(0.0, 0.0, 1.0 - f, 1.0, 1.0, 1.0);
                } else if (face == BlockFace.SOUTH) {
                    bb.setBounds(0.0, 0.0, 0.0, 1.0, 1.0, 0.0 + f);
                }
                if (face == BlockFace.WEST) {
                    bb.setBounds(1.0 - f, 0.0, 0.0, 1.0, 1.0, 1.0);
                }
                if (face == BlockFace.EAST) {
                    bb.setBounds(0.0, 0.0, 0.0, 0.0 + f, 1.0, 1.0);
                }
            }
            BlockTrapdoor.boundingBoxDamage[damage] = bb;
        }
    }
}

