/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.entity.item;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.EntityExplosive;
import cn.nukkit.entity.data.IntEntityData;
import cn.nukkit.entity.item.EntityMinecartAbstract;
import cn.nukkit.event.entity.EntityExplosionPrimeEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemMinecartTNT;
import cn.nukkit.level.Explosion;
import cn.nukkit.level.GameRule;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.utils.MinecartType;
import java.util.concurrent.ThreadLocalRandom;

public class EntityMinecartTNT
extends EntityMinecartAbstract
implements EntityExplosive {
    public static final int NETWORK_ID = 97;
    private int fuse;

    public EntityMinecartTNT(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
        super.setDisplayBlock(Block.get(46), false);
    }

    @Override
    public boolean isRideable() {
        return false;
    }

    @Override
    public void initEntity() {
        super.initEntity();
        this.fuse = this.namedTag.contains("TNTFuse") ? this.namedTag.getByte("TNTFuse") : 80;
        this.setDataFlag(0, 27, false);
    }

    @Override
    public boolean onUpdate(int currentTick) {
        this.timing.startTiming();
        if (this.fuse < 80) {
            int tickDiff = currentTick - this.lastUpdate;
            this.lastUpdate = currentTick;
            if (this.fuse % 5 == 0) {
                this.setDataProperty(new IntEntityData(55, this.fuse));
            }
            this.fuse -= tickDiff;
            if (this.isAlive() && this.fuse <= 0) {
                if (this.level.getGameRules().getBoolean(GameRule.TNT_EXPLODES)) {
                    this.explode(ThreadLocalRandom.current().nextInt(5));
                }
                this.close();
                return false;
            }
        }
        this.timing.stopTiming();
        return super.onUpdate(currentTick);
    }

    @Override
    public void activate(int x, int y, int z, boolean flag) {
        this.level.addLevelSoundEvent(this, 50);
        this.fuse = 79;
    }

    @Override
    public void explode() {
        this.explode(0.0);
    }

    public void explode(double square) {
        double root = Math.sqrt(square);
        if (root > 5.0) {
            root = 5.0;
        }
        EntityExplosionPrimeEvent event = new EntityExplosionPrimeEvent(this, 4.0 + ThreadLocalRandom.current().nextDouble() * 1.5 * root);
        this.server.getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            return;
        }
        Explosion explosion = new Explosion(this, event.getForce(), this);
        if (event.isBlockBreaking()) {
            explosion.explodeA();
        }
        explosion.explodeB();
        this.close();
    }

    @Override
    public void dropItem() {
        this.level.dropItem(this, new ItemMinecartTNT());
    }

    @Override
    public String getName() {
        return this.getType().getName();
    }

    @Override
    public MinecartType getType() {
        return MinecartType.valueOf(3);
    }

    @Override
    public int getNetworkId() {
        return 97;
    }

    @Override
    public void saveNBT() {
        super.saveNBT();
        this.namedTag.putInt("TNTFuse", this.fuse);
    }

    @Override
    public boolean onInteract(Player player, Item item, Vector3 clickedPos) {
        boolean interact = super.onInteract(player, item, clickedPos);
        if (item.getId() == 259 || item.getId() == 385) {
            this.level.addLevelSoundEvent(this, 50);
            this.fuse = 79;
            return true;
        }
        return interact;
    }

    @Override
    public boolean mountEntity(Entity entity, byte mode) {
        return false;
    }
}

