/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.entity.projectile;

import cn.nukkit.block.Block;
import cn.nukkit.block.BlockBell;
import cn.nukkit.block.BlockCampfire;
import cn.nukkit.block.BlockFire;
import cn.nukkit.block.BlockTNT;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.projectile.EntityProjectile;
import cn.nukkit.level.Sound;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.CompoundTag;
import java.util.concurrent.ThreadLocalRandom;

public class EntityArrow
extends EntityProjectile {
    public static final int NETWORK_ID = 80;
    public static final int DATA_SOURCE_ID = 17;
    public static final int PICKUP_NONE = 0;
    public static final int PICKUP_ANY = 1;
    public static final int PICKUP_CREATIVE = 2;
    protected int pickupMode;

    @Override
    public int getNetworkId() {
        return 80;
    }

    @Override
    public float getWidth() {
        return 0.5f;
    }

    @Override
    public float getLength() {
        return 0.5f;
    }

    @Override
    public float getHeight() {
        return 0.5f;
    }

    @Override
    public float getGravity() {
        return 0.05f;
    }

    @Override
    public float getDrag() {
        return 0.01f;
    }

    public EntityArrow(FullChunk chunk, CompoundTag nbt) {
        this(chunk, nbt, null);
    }

    public EntityArrow(FullChunk chunk, CompoundTag nbt, Entity shootingEntity) {
        this(chunk, nbt, shootingEntity, false);
    }

    public EntityArrow(FullChunk chunk, CompoundTag nbt, Entity shootingEntity, boolean critical) {
        super(chunk, nbt, shootingEntity);
        this.setCritical(critical);
    }

    @Override
    protected void initEntity() {
        super.initEntity();
        this.damage = this.namedTag.contains("damage") ? this.namedTag.getDouble("damage") : 2.0;
        this.pickupMode = this.namedTag.contains("pickup") ? this.namedTag.getByte("pickup") : 1;
    }

    public void setCritical() {
        this.setCritical(true);
    }

    public void setCritical(boolean value) {
        this.setDataFlag(0, 13, value);
    }

    public boolean isCritical() {
        return this.getDataFlag(0, 13);
    }

    @Override
    public int getResultDamage() {
        int base = super.getResultDamage();
        if (this.isCritical()) {
            base += ThreadLocalRandom.current().nextInt(base / 2 + 2);
        }
        return base;
    }

    @Override
    protected double getBaseDamage() {
        return 2.0;
    }

    @Override
    public boolean onUpdate(int currentTick) {
        if (this.closed) {
            return false;
        }
        this.timing.startTiming();
        boolean hasUpdate = super.onUpdate(currentTick);
        if (this.onGround || this.hadCollision) {
            this.setCritical(false);
        }
        if (this.age > 1200) {
            this.close();
            hasUpdate = true;
        }
        this.timing.stopTiming();
        return hasUpdate;
    }

    @Override
    protected void addHitEffect() {
        this.level.addSound(this, Sound.RANDOM_BOWHIT);
    }

    @Override
    protected boolean onCollideWithBlock(Block collisionBlock) {
        if (super.onCollideWithBlock(collisionBlock)) {
            if (collisionBlock instanceof BlockBell && this.isOnFire() && this.level.getBlock(this).getId() == 0) {
                this.level.setBlock((Vector3)this, new BlockFire(), true, true);
            }
            return true;
        }
        if (this.isOnFire()) {
            if (collisionBlock instanceof BlockCampfire) {
                BlockCampfire campfire = (BlockCampfire)collisionBlock;
                if (campfire.isExtinguished()) {
                    campfire.setExtinguished(false);
                    this.level.setBlock((Vector3)collisionBlock, collisionBlock, true, true);
                }
                return true;
            }
            if (collisionBlock instanceof BlockTNT) {
                ((BlockTNT)collisionBlock).prime(80, this);
                return true;
            }
        }
        return false;
    }

    @Override
    public void saveNBT() {
        super.saveNBT();
        this.namedTag.putByte("pickup", this.pickupMode);
    }

    public int getPickupMode() {
        return this.pickupMode;
    }

    public void setPickupMode(int pickupMode) {
        this.pickupMode = pickupMode;
    }
}

