/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.inventory;

import cn.nukkit.Player;
import cn.nukkit.inventory.FakeBlockUIComponent;
import cn.nukkit.inventory.InventoryType;
import cn.nukkit.inventory.PlayerUIInventory;
import cn.nukkit.item.Item;
import cn.nukkit.level.Position;
import cn.nukkit.nbt.tag.CompoundTag;

public class GrindstoneInventory
extends FakeBlockUIComponent {
    public static final int OFFSET = 16;
    private static final int SLOT_FIRST_ITEM = 0;
    private static final int SLOT_SECOND_ITEM = 1;
    private static final int SLOT_RESULT = 34;

    public GrindstoneInventory(PlayerUIInventory playerUI, Position position) {
        super(playerUI, InventoryType.GRINDSTONE, 16, position);
    }

    @Override
    public void close(Player who) {
        this.onClose(who);
    }

    @Override
    public void onClose(Player who) {
        super.onClose(who);
        who.craftingType = 0;
        Item[] drops = new Item[]{this.getFirstItem(), this.getSecondItem()};
        for (Item drop : drops = who.getInventory().addItem(drops)) {
            if (who.dropItem(drop)) continue;
            this.getHolder().getLevel().dropItem(this.getHolder().add(0.5, 0.5, 0.5), drop);
        }
        this.clear(0);
        this.clear(1);
        who.resetCraftingGridType();
    }

    @Override
    public void onOpen(Player who) {
        super.onOpen(who);
        who.craftingType = 5;
    }

    public Item getFirstItem() {
        return this.getItem(0);
    }

    public Item getSecondItem() {
        return this.getItem(1);
    }

    public Item getResult() {
        return this.getItem(2);
    }

    public boolean setFirstItem(Item item, boolean send) {
        return this.setItem(0, item, send);
    }

    public boolean setFirstItem(Item item) {
        return this.setFirstItem(item, true);
    }

    public boolean setSecondItem(Item item, boolean send) {
        return this.setItem(1, item, send);
    }

    public boolean setSecondItem(Item item) {
        return this.setSecondItem(item, true);
    }

    public boolean setResult(Item item, boolean send) {
        return this.setItem(2, item, send);
    }

    public boolean setResult(Item item) {
        return this.setResult(item, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSlotChange(int index, Item before, boolean send) {
        try {
            if (index > 1) {
                return;
            }
            Item firstItem = this.getFirstItem();
            Item secondItem = this.getSecondItem();
            if (!firstItem.isNull() && !secondItem.isNull() && firstItem.getId() != secondItem.getId()) {
                this.setResult(Item.get(0));
                return;
            }
            if (firstItem.isNull()) {
                Item air = firstItem;
                firstItem = secondItem;
                secondItem = air;
            }
            if (firstItem.isNull()) {
                this.setResult(Item.get(0));
                return;
            }
            Item result = firstItem.clone();
            CompoundTag tag = result.getNamedTag();
            if (tag == null) {
                tag = new CompoundTag();
            }
            tag.remove("ench");
            tag.putInt("RepairCost", 0);
            result.setCompoundTag(tag);
            if (!secondItem.isNull()) {
                int first = firstItem.getMaxDurability() - firstItem.getDamage();
                int second = secondItem.getMaxDurability() - secondItem.getDamage();
                int reduction = first + second + firstItem.getMaxDurability() * 5 / 100;
                int resultingDamage = Math.max(firstItem.getMaxDurability() - reduction + 1, 0);
                result.setDamage(resultingDamage);
            }
            this.setResult(result);
        }
        finally {
            super.onSlotChange(index, before, send);
        }
    }

    @Override
    public Item getItem(int index) {
        if (index < 0 || index > 3) {
            return Item.get(0);
        }
        if (index == 2) {
            index = 34;
        }
        return super.getItem(index);
    }

    @Override
    public boolean setItem(int index, Item item, boolean send) {
        if (index < 0 || index > 3) {
            return false;
        }
        if (index == 2) {
            index = 34;
        }
        return super.setItem(index, item, send);
    }
}

