/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.inventory;

import cn.nukkit.Player;
import cn.nukkit.inventory.AnvilInventory;
import cn.nukkit.inventory.BaseInventory;
import cn.nukkit.inventory.BigCraftingGrid;
import cn.nukkit.inventory.CraftingGrid;
import cn.nukkit.inventory.GrindstoneInventory;
import cn.nukkit.inventory.Inventory;
import cn.nukkit.inventory.InventoryType;
import cn.nukkit.inventory.PlayerCursorInventory;
import cn.nukkit.item.Item;
import cn.nukkit.network.protocol.InventorySlotPacket;
import java.util.HashMap;

public class PlayerUIInventory
extends BaseInventory {
    private final Player player;
    private final PlayerCursorInventory cursorInventory;
    private final CraftingGrid craftingGrid;
    private final BigCraftingGrid bigCraftingGrid;

    public PlayerUIInventory(Player player) {
        super(player, InventoryType.UI, new HashMap<Integer, Item>(), 51);
        this.player = player;
        this.cursorInventory = new PlayerCursorInventory(this);
        this.craftingGrid = new CraftingGrid(this);
        this.bigCraftingGrid = new BigCraftingGrid(this);
    }

    public PlayerCursorInventory getCursorInventory() {
        return this.cursorInventory;
    }

    public CraftingGrid getCraftingGrid() {
        return this.craftingGrid;
    }

    public BigCraftingGrid getBigCraftingGrid() {
        return this.bigCraftingGrid;
    }

    @Override
    public void setSize(int size) {
        throw new UnsupportedOperationException("UI size is immutable");
    }

    @Override
    public void sendSlot(int index, Player ... target) {
        InventorySlotPacket pk = new InventorySlotPacket();
        pk.slot = index;
        pk.item = this.getItem(index);
        for (Player p : target) {
            if (p == this.getHolder()) {
                pk.inventoryId = 124;
            } else {
                int id = p.getWindowId(this);
                if (id == -1) {
                    this.close(p);
                    continue;
                }
                pk.inventoryId = id;
            }
            p.dataPacket(pk);
        }
    }

    @Override
    public void sendContents(Player ... target) {
    }

    @Override
    public void onSlotChange(int index, Item before, boolean send) {
        switch (this.player.craftingType) {
            case 5: {
                Inventory inventory;
                if (index >= 16 && (inventory = this.player.getWindowById(2)) instanceof GrindstoneInventory && (index == 50 || index - 16 < inventory.getSize())) {
                    inventory.onSlotChange(index == 50 ? 2 : index - 16, before, send);
                }
            }
            case 2: {
                Inventory inventory;
                if (index >= 1 && (inventory = this.player.getWindowById(2)) instanceof AnvilInventory && (index == 50 || index - 1 < inventory.getSize())) {
                    inventory.onSlotChange(index == 50 ? 2 : index - 1, before, send);
                }
                return;
            }
        }
        super.onSlotChange(index, before, send);
    }

    public void onSlotChangeBase(int index, Item before, boolean send) {
        super.onSlotChange(index, before, send);
    }

    @Override
    public int getSize() {
        return 51;
    }

    @Override
    public Player getHolder() {
        return this.player;
    }
}

