/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.item;

import cn.nukkit.api.DeprecationDetails;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.item.Item;
import cn.nukkit.utils.BannerPattern;

@Since(value="1.2.1.0-PN")
@PowerNukkitOnly
public class ItemBannerPattern
extends Item {
    @Deprecated
    @DeprecationDetails(since="1.3.2.0-PN", reason="Banner pattern items now have they own ids", replaceWith="ItemBannerPatternCreeper")
    @PowerNukkitOnly
    public static final int PATTERN_CREEPER_CHARGE = 0;
    @Deprecated
    @DeprecationDetails(since="1.3.2.0-PN", reason="Banner pattern items now have they own ids", replaceWith="ItemBannerPatternSkull")
    @PowerNukkitOnly
    public static final int PATTERN_SKULL_CHARGE = 1;
    @Deprecated
    @DeprecationDetails(since="1.3.2.0-PN", reason="Banner pattern items now have they own ids", replaceWith="ItemBannerPatternFlower")
    @PowerNukkitOnly
    public static final int PATTERN_FLOWER_CHARGE = 2;
    @Deprecated
    @DeprecationDetails(since="1.3.2.0-PN", reason="Banner pattern items now have they own ids", replaceWith="ItemBannerPatternMojang")
    @PowerNukkitOnly
    public static final int PATTERN_THING = 3;
    @Deprecated
    @DeprecationDetails(since="1.3.2.0-PN", reason="Banner pattern items now have they own ids", replaceWith="ItemBannerPatternFieldMasoned")
    @PowerNukkitOnly
    public static final int PATTERN_FIELD_MASONED = 4;
    @Deprecated
    @DeprecationDetails(since="1.3.2.0-PN", reason="Banner pattern items now have they own ids", replaceWith="ItemBannerPatternBordureIndented")
    @PowerNukkitOnly
    public static final int PATTERN_BORDURE_INDENTED = 5;

    @Deprecated
    @DeprecationDetails(since="1.3.2.0-PN", reason="Banner pattern items now have they own ids, and their implementation extends ItemBannerPattern, so you may get 0 as meta result even though the pattern is not a creeper charge.", replaceWith="new ItemBannerPatternCreeperCharge()")
    @PowerNukkitOnly
    public ItemBannerPattern() {
        this((Integer)0, 1);
    }

    @Deprecated
    @DeprecationDetails(since="1.3.2.0-PN", reason="Banner pattern items now have they own ids, and their implementation extends ItemBannerPattern, so you may get 0 as meta result even though the pattern is not a creeper charge.", replaceWith="ItemBannerPatternCreeperCharge, ItemBannerPatternSkullCharge, etc")
    @PowerNukkitOnly
    public ItemBannerPattern(Integer meta) {
        this(meta, 1);
    }

    @Deprecated
    @DeprecationDetails(since="1.3.2.0-PN", reason="Banner pattern items now have they own ids, and their implementation extends ItemBannerPattern, so you may get 0 as meta result even though the pattern is not a creeper charge.", replaceWith="ItemBannerPatternCreeperCharge, ItemBannerPatternSkullCharge, etc")
    @PowerNukkitOnly
    public ItemBannerPattern(Integer meta, int count) {
        super(434, meta, count, "Bone");
        this.updateName();
    }

    @PowerNukkitOnly
    @Since(value="1.3.2.0-PN")
    protected ItemBannerPattern(int id, Integer meta, int count, String name) {
        super(id, meta, count, name);
    }

    @Override
    @Deprecated
    @DeprecationDetails(since="1.3.2.0-PN", reason="Banner pattern items now have they own ids, and their implementation extends ItemBannerPattern, so you may get 0 as meta result even though the pattern is not a creeper charge.", replaceWith="")
    public int getDamage() {
        return super.getDamage();
    }

    @Override
    public int getMaxStackSize() {
        return 1;
    }

    @Override
    public void setDamage(Integer meta) {
        super.setDamage(meta);
        this.updateName();
    }

    @PowerNukkitOnly
    @Since(value="1.3.2.0-PN")
    public BannerPattern.Type getPatternType() {
        if (this.getId() != 434) {
            return BannerPattern.Type.PATTERN_CREEPER;
        }
        switch (this.getDamage()) {
            default: {
                return BannerPattern.Type.PATTERN_CREEPER;
            }
            case 1: {
                return BannerPattern.Type.PATTERN_SKULL;
            }
            case 2: {
                return BannerPattern.Type.PATTERN_FLOWER;
            }
            case 3: {
                return BannerPattern.Type.PATTERN_MOJANG;
            }
            case 4: {
                return BannerPattern.Type.PATTERN_BRICK;
            }
            case 5: 
        }
        return BannerPattern.Type.PATTERN_CURLY_BORDER;
    }

    @Override
    @Since(value="1.3.2.0-PN")
    @PowerNukkitOnly
    public Item selfUpgrade() {
        int newId;
        if (this.getId() != 434) {
            return this;
        }
        switch (this.getDamage()) {
            case 0: {
                newId = 845;
                break;
            }
            case 1: {
                newId = 807;
                break;
            }
            case 2: {
                newId = 804;
                break;
            }
            case 3: {
                newId = 870;
                break;
            }
            case 4: {
                newId = 826;
                break;
            }
            case 5: {
                newId = 843;
                break;
            }
            default: {
                return this;
            }
        }
        return Item.get(newId, 0, this.getCount(), this.getCompoundTag());
    }

    protected void updateName() {
        if (this.getId() != 434) {
            return;
        }
        switch (this.meta % 6) {
            case 0: {
                this.name = "Creeper Charge Banner Pattern";
                return;
            }
            case 1: {
                this.name = "Skull Charge Banner Pattern";
                return;
            }
            case 2: {
                this.name = "Flower Charge Banner Pattern";
                return;
            }
            case 3: {
                this.name = "Thing Banner Pattern";
                return;
            }
            case 4: {
                this.name = "Field Banner Pattern";
                return;
            }
            case 5: {
                this.name = "Bordure Idented Banner Pattern";
                return;
            }
        }
        this.name = "Banner Pattern";
    }
}

