/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.item;

import cn.nukkit.Player;
import cn.nukkit.api.DeprecationDetails;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockWater;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.item.EntityBoat;
import cn.nukkit.item.Item;
import cn.nukkit.level.Level;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.math.BlockFace;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.DoubleTag;
import cn.nukkit.nbt.tag.FloatTag;
import cn.nukkit.nbt.tag.ListTag;
import java.util.OptionalInt;

public class ItemBoat
extends Item {
    @Deprecated
    @DeprecationDetails(since="1.3.2.0-PN", reason="Boat items now have they own ids, and their implementation extends ItemBoat, so you may get 0 as meta result even though you have a boat of material different to oak wood.", replaceWith="new ItemBoatOak()")
    public ItemBoat() {
        this((Integer)0, 1);
    }

    @Deprecated
    @DeprecationDetails(since="1.3.2.0-PN", reason="Boat items now have they own ids, and their implementation extends ItemBoat, so you may get 0 as meta result even though you have a boat of material different to oak wood.", replaceWith="An item class specific for the item you want. Eg: ItemBoatOak, ItemBoatSpruce, etc")
    public ItemBoat(Integer meta) {
        this(meta, 1);
    }

    @Deprecated
    @DeprecationDetails(since="1.3.2.0-PN", reason="Boat items now have they own ids, and their implementation extends ItemBoat, so you may get 0 as meta result even though you have a boat of material different to oak wood.", replaceWith="An item class specific for the item you want. Eg: ItemBoatOak, ItemBoatSpruce, etc")
    public ItemBoat(Integer meta, int count) {
        super(333, meta, count, "Boat");
    }

    @PowerNukkitOnly
    @Since(value="1.3.2.0-PN")
    protected ItemBoat(int id, Integer meta, int count, String name) {
        super(id, meta, count, name);
    }

    @Override
    @Deprecated
    @DeprecationDetails(since="1.3.2.0-PN", reason="Boat items now have they own ids, and their implementation extends ItemBoat, so you may get 0 as meta result even though you have a boat of material different to oak wood.", replaceWith="getLegacyBoatDamage()")
    public int getDamage() {
        return super.getDamage();
    }

    @PowerNukkitOnly
    @Since(value="1.3.2.0-PN")
    public OptionalInt getLegacyBoatDamage() {
        if (this.getId() == 333) {
            return OptionalInt.of(super.getDamage());
        }
        return OptionalInt.empty();
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean onActivate(Level level, Player player, Block block, Block target, BlockFace face, double fx, double fy, double fz) {
        if (face != BlockFace.UP) {
            return false;
        }
        EntityBoat boat = (EntityBoat)Entity.createEntity("Boat", (FullChunk)level.getChunk(block.getFloorX() >> 4, block.getFloorZ() >> 4), new CompoundTag("").putList(new ListTag<DoubleTag>("Pos").add(new DoubleTag("", block.getX() + 0.5)).add(new DoubleTag("", block.getY() - (target instanceof BlockWater ? 0.0625 : 0.0))).add(new DoubleTag("", block.getZ() + 0.5))).putList(new ListTag<DoubleTag>("Motion").add(new DoubleTag("", 0.0)).add(new DoubleTag("", 0.0)).add(new DoubleTag("", 0.0))).putList(new ListTag<FloatTag>("Rotation").add(new FloatTag("", (float)((player.yaw + 90.0) % 360.0))).add(new FloatTag("", 0.0f))).putByte("woodID", this.getLegacyBoatDamage().orElse(0)), new Object[0]);
        if (boat == null) {
            return false;
        }
        if (player.isSurvival()) {
            Item item = player.getInventory().getItemInHand();
            item.setCount(item.getCount() - 1);
            player.getInventory().setItemInHand(item);
        }
        boat.spawnToAll();
        return true;
    }

    @Override
    @Since(value="1.3.2.0-PN")
    @PowerNukkitOnly
    public Item selfUpgrade() {
        int newId;
        if (this.getId() != 333) {
            return this;
        }
        switch (super.getDamage()) {
            case 0: {
                newId = 837;
                break;
            }
            case 1: {
                newId = 866;
                break;
            }
            case 2: {
                newId = 889;
                break;
            }
            case 3: {
                newId = 821;
                break;
            }
            case 4: {
                newId = 836;
                break;
            }
            case 5: {
                newId = 840;
                break;
            }
            default: {
                return this;
            }
        }
        return Item.get(newId, 0, this.getCount(), this.getCompoundTag());
    }

    @Override
    public int getMaxStackSize() {
        return 1;
    }
}

