/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.item;

import cn.nukkit.Server;
import cn.nukkit.api.Since;
import cn.nukkit.utils.BinaryStream;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

@Since(value="1.3.2.0-PN")
public final class RuntimeItems {
    private static final Gson GSON;
    private static final Type ENTRY_TYPE;
    @Since(value="1.3.2.0-PN")
    public static final byte[] ITEM_DATA_PALETTE;
    private static final Int2IntMap LEGACY_NETWORK_MAP;
    private static final Int2IntMap NETWORK_LEGACY_MAP;

    private RuntimeItems() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        List entries;
        GSON = new Gson();
        ENTRY_TYPE = new TypeToken<ArrayList<Entry>>(){}.getType();
        LEGACY_NETWORK_MAP = new Int2IntOpenHashMap();
        NETWORK_LEGACY_MAP = new Int2IntOpenHashMap();
        try {
            InputStream stream = Server.class.getClassLoader().getResourceAsStream("runtime_item_ids.json");
            Object object = null;
            try (InputStreamReader reader2 = new InputStreamReader(stream);){
                entries = (List)GSON.fromJson((Reader)reader2, ENTRY_TYPE);
            }
            catch (Throwable reader2) {
                object = reader2;
                throw reader2;
            }
            finally {
                if (stream != null) {
                    if (object != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable reader2) {
                            ((Throwable)object).addSuppressed(reader2);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
        }
        catch (IOException | NullPointerException e) {
            throw new AssertionError("Unable to load runtime_item_ids.json", e);
        }
        BinaryStream paletteBuffer = new BinaryStream();
        paletteBuffer.putUnsignedVarInt(entries.size());
        LEGACY_NETWORK_MAP.defaultReturnValue(-1);
        NETWORK_LEGACY_MAP.defaultReturnValue(-1);
        for (Entry entry : entries) {
            paletteBuffer.putString(entry.name);
            paletteBuffer.putLShort(entry.id);
            paletteBuffer.putBoolean(false);
        }
        ITEM_DATA_PALETTE = paletteBuffer.getBuffer();
    }

    static class Entry {
        String name;
        int id;

        public String toString() {
            return "RuntimeItems.Entry(name=" + this.name + ", id=" + this.id + ")";
        }
    }
}

