/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.item.enchantment;

import cn.nukkit.entity.Entity;
import cn.nukkit.entity.EntityHumanType;
import cn.nukkit.event.entity.EntityDamageByEntityEvent;
import cn.nukkit.event.entity.EntityDamageEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemArmor;
import cn.nukkit.item.ItemElytra;
import cn.nukkit.item.enchantment.Enchantment;
import cn.nukkit.item.enchantment.EnchantmentType;
import java.util.concurrent.ThreadLocalRandom;

public class EnchantmentThorns
extends Enchantment {
    protected EnchantmentThorns() {
        super(5, "thorns", 1, EnchantmentType.ARMOR);
    }

    @Override
    public int getMinEnchantAbility(int level) {
        return 10 + (level - 1) * 20;
    }

    @Override
    public int getMaxEnchantAbility(int level) {
        return this.getMinEnchantAbility(level) + 50;
    }

    @Override
    public int getMaxLevel() {
        return 3;
    }

    @Override
    public void doPostAttack(Entity attacker, Entity entity) {
        if (!(entity instanceof EntityHumanType)) {
            return;
        }
        EntityHumanType human = (EntityHumanType)entity;
        int thornsLevel = 0;
        for (Item armor : human.getInventory().getArmorContents()) {
            Enchantment thorns = armor.getEnchantment(5);
            if (thorns == null) continue;
            thornsLevel = Math.max(thorns.getLevel(), thornsLevel);
        }
        ThreadLocalRandom random = ThreadLocalRandom.current();
        if (EnchantmentThorns.shouldHit(random, thornsLevel)) {
            attacker.attack(new EntityDamageByEntityEvent(entity, attacker, EntityDamageEvent.DamageCause.ENTITY_ATTACK, EnchantmentThorns.getDamage(random, this.level), 0.0f));
        }
    }

    @Override
    public boolean isItemAcceptable(Item item) {
        if (item instanceof ItemArmor) {
            return !(item instanceof ItemElytra);
        }
        return super.isItemAcceptable(item);
    }

    private static boolean shouldHit(ThreadLocalRandom random, int level) {
        return level > 0 && (double)random.nextFloat() < 0.15 * (double)level;
    }

    private static int getDamage(ThreadLocalRandom random, int level) {
        return level > 10 ? level - 10 : random.nextInt(1, 5);
    }
}

