/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level;

import cn.nukkit.Server;
import cn.nukkit.level.Level;
import cn.nukkit.level.Position;
import cn.nukkit.level.generator.Generator;
import cn.nukkit.math.NukkitMath;

public enum EnumLevel {
    OVERWORLD,
    NETHER;

    Level level;

    public Level getLevel() {
        return this.level;
    }

    public static void initLevels() {
        EnumLevel.OVERWORLD.level = Server.getInstance().getDefaultLevel();
        if (Server.getInstance().isNetherAllowed() && !Server.getInstance().loadLevel("nether")) {
            Server.getInstance().getLogger().info("No level called \"nether\" found, creating default nether level.");
            long seed = System.currentTimeMillis();
            Class<? extends Generator> generator = Generator.getGenerator("nether");
            Server.getInstance().generateLevel("nether", seed, generator);
            if (!Server.getInstance().isLevelLoaded("nether")) {
                Server.getInstance().loadLevel("nether");
            }
        }
        EnumLevel.NETHER.level = Server.getInstance().getLevelByName("nether");
        if (EnumLevel.NETHER.level == null) {
            Server.getInstance().getLogger().alert("No level called \"nether\" found or nether is disabled in server properties! Nether functionality will be disabled.");
        }
    }

    public static Level getOtherNetherPair(Level current) {
        if (current == EnumLevel.OVERWORLD.level) {
            return EnumLevel.NETHER.level;
        }
        if (current == EnumLevel.NETHER.level) {
            return EnumLevel.OVERWORLD.level;
        }
        throw new IllegalArgumentException("Neither overworld nor nether given!");
    }

    public static Position moveToNether(Position current) {
        if (EnumLevel.NETHER.level == null) {
            return null;
        }
        if (current.level == EnumLevel.OVERWORLD.level) {
            return new Position(EnumLevel.mRound(current.getFloorX() >> 3, 128), NukkitMath.clamp(EnumLevel.mRound(current.getFloorY(), 32), 70, 118), EnumLevel.mRound(current.getFloorZ() >> 3, 128), EnumLevel.NETHER.level);
        }
        if (current.level == EnumLevel.NETHER.level) {
            return new Position(EnumLevel.mRound(current.getFloorX() << 3, 1024), NukkitMath.clamp(EnumLevel.mRound(current.getFloorY(), 32), 70, 246), EnumLevel.mRound(current.getFloorZ() << 3, 1024), EnumLevel.OVERWORLD.level);
        }
        throw new IllegalArgumentException("Neither overworld nor nether given!");
    }

    private static final int mRound(int value, int factor) {
        return Math.round((float)value / (float)factor) * factor;
    }
}

