/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.api.DeprecationDetails;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockLiquid;
import cn.nukkit.block.BlockPistonBase;
import cn.nukkit.block.BlockRedstoneDiode;
import cn.nukkit.block.BlockScaffolding;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.item.EntityItem;
import cn.nukkit.entity.item.EntityXPOrb;
import cn.nukkit.entity.projectile.EntityArrow;
import cn.nukkit.entity.weather.EntityLightning;
import cn.nukkit.event.block.BlockBreakEvent;
import cn.nukkit.event.block.BlockPlaceEvent;
import cn.nukkit.event.block.BlockUpdateEvent;
import cn.nukkit.event.level.ChunkLoadEvent;
import cn.nukkit.event.level.ChunkPopulateEvent;
import cn.nukkit.event.level.ChunkUnloadEvent;
import cn.nukkit.event.level.LevelSaveEvent;
import cn.nukkit.event.level.LevelUnloadEvent;
import cn.nukkit.event.level.SpawnChangeEvent;
import cn.nukkit.event.level.ThunderChangeEvent;
import cn.nukkit.event.level.WeatherChangeEvent;
import cn.nukkit.event.player.PlayerInteractEvent;
import cn.nukkit.event.weather.LightningStrikeEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.item.ItemBucket;
import cn.nukkit.item.enchantment.Enchantment;
import cn.nukkit.level.ChunkLoader;
import cn.nukkit.level.ChunkManager;
import cn.nukkit.level.GameRule;
import cn.nukkit.level.GameRules;
import cn.nukkit.level.GlobalBlockPalette;
import cn.nukkit.level.LevelProviderConverter;
import cn.nukkit.level.ParticleEffect;
import cn.nukkit.level.Position;
import cn.nukkit.level.Sound;
import cn.nukkit.level.biome.Biome;
import cn.nukkit.level.format.Chunk;
import cn.nukkit.level.format.ChunkSection;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.level.format.LevelProvider;
import cn.nukkit.level.format.anvil.Anvil;
import cn.nukkit.level.format.generic.BaseFullChunk;
import cn.nukkit.level.format.generic.BaseLevelProvider;
import cn.nukkit.level.format.generic.EmptyChunkSection;
import cn.nukkit.level.format.leveldb.LevelDB;
import cn.nukkit.level.format.mcregion.McRegion;
import cn.nukkit.level.generator.Generator;
import cn.nukkit.level.generator.PopChunkManager;
import cn.nukkit.level.generator.task.GenerationTask;
import cn.nukkit.level.generator.task.LightPopulationTask;
import cn.nukkit.level.generator.task.PopulationTask;
import cn.nukkit.level.particle.DestroyBlockParticle;
import cn.nukkit.level.particle.Particle;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.BlockVector3;
import cn.nukkit.math.MathHelper;
import cn.nukkit.math.NukkitMath;
import cn.nukkit.math.NukkitRandom;
import cn.nukkit.math.SimpleAxisAlignedBB;
import cn.nukkit.math.Vector2;
import cn.nukkit.math.Vector3;
import cn.nukkit.math.Vector3f;
import cn.nukkit.metadata.BlockMetadataStore;
import cn.nukkit.metadata.MetadataValue;
import cn.nukkit.metadata.Metadatable;
import cn.nukkit.nbt.NBTIO;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.DoubleTag;
import cn.nukkit.nbt.tag.FloatTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.nbt.tag.StringTag;
import cn.nukkit.nbt.tag.Tag;
import cn.nukkit.network.protocol.AddEntityPacket;
import cn.nukkit.network.protocol.BatchPacket;
import cn.nukkit.network.protocol.DataPacket;
import cn.nukkit.network.protocol.GameRulesChangedPacket;
import cn.nukkit.network.protocol.LevelEventPacket;
import cn.nukkit.network.protocol.LevelSoundEventPacket;
import cn.nukkit.network.protocol.MoveEntityAbsolutePacket;
import cn.nukkit.network.protocol.MovePlayerPacket;
import cn.nukkit.network.protocol.PlaySoundPacket;
import cn.nukkit.network.protocol.SetSpawnPositionPacket;
import cn.nukkit.network.protocol.SetTimePacket;
import cn.nukkit.network.protocol.SpawnParticleEffectPacket;
import cn.nukkit.network.protocol.UpdateBlockPacket;
import cn.nukkit.plugin.Plugin;
import cn.nukkit.scheduler.AsyncTask;
import cn.nukkit.scheduler.BlockUpdateScheduler;
import cn.nukkit.timings.LevelTimings;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.BlockUpdateEntry;
import cn.nukkit.utils.Hash;
import cn.nukkit.utils.IterableThreadLocal;
import cn.nukkit.utils.LevelException;
import cn.nukkit.utils.MainLogger;
import cn.nukkit.utils.TextFormat;
import cn.nukkit.utils.Utils;
import co.aikar.timings.Timings;
import co.aikar.timings.TimingsHistory;
import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongMaps;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;

public class Level
implements ChunkManager,
Metadatable {
    private static int levelIdCounter = 1;
    private static int chunkLoaderCounter = 1;
    public static int COMPRESSION_LEVEL = 8;
    public static final int BLOCK_UPDATE_NORMAL = 1;
    public static final int BLOCK_UPDATE_RANDOM = 2;
    public static final int BLOCK_UPDATE_SCHEDULED = 3;
    public static final int BLOCK_UPDATE_WEAK = 4;
    public static final int BLOCK_UPDATE_TOUCH = 5;
    public static final int BLOCK_UPDATE_REDSTONE = 6;
    public static final int BLOCK_UPDATE_TICK = 7;
    public static final int TIME_DAY = 0;
    public static final int TIME_NOON = 6000;
    public static final int TIME_SUNSET = 12000;
    public static final int TIME_NIGHT = 14000;
    public static final int TIME_MIDNIGHT = 18000;
    public static final int TIME_SUNRISE = 23000;
    public static final int TIME_FULL = 24000;
    public static final int DIMENSION_OVERWORLD = 0;
    public static final int DIMENSION_NETHER = 1;
    public static final int DIMENSION_THE_END = 2;
    public static final int MAX_BLOCK_CACHE = 512;
    private static final boolean[] randomTickBlocks = new boolean[600];
    private final Long2ObjectOpenHashMap<BlockEntity> blockEntities = new Long2ObjectOpenHashMap();
    private final Long2ObjectOpenHashMap<Player> players = new Long2ObjectOpenHashMap();
    private final Long2ObjectOpenHashMap<Entity> entities = new Long2ObjectOpenHashMap();
    public final Long2ObjectOpenHashMap<Entity> updateEntities = new Long2ObjectOpenHashMap();
    private final ConcurrentLinkedQueue<BlockEntity> updateBlockEntities = new ConcurrentLinkedQueue();
    private boolean cacheChunks = false;
    private final Server server;
    private final int levelId;
    private LevelProvider provider;
    private final Int2ObjectOpenHashMap<ChunkLoader> loaders = new Int2ObjectOpenHashMap();
    private final Int2IntMap loaderCounter = new Int2IntOpenHashMap();
    private final Long2ObjectOpenHashMap<Map<Integer, ChunkLoader>> chunkLoaders = new Long2ObjectOpenHashMap();
    private final Long2ObjectOpenHashMap<Map<Integer, Player>> playerLoaders = new Long2ObjectOpenHashMap();
    private final Long2ObjectOpenHashMap<Deque<DataPacket>> chunkPackets = new Long2ObjectOpenHashMap();
    private final Long2LongMap unloadQueue = Long2LongMaps.synchronize((Long2LongMap)new Long2LongOpenHashMap());
    private float time;
    public boolean stopTime;
    public float skyLightSubtracted;
    private String folderName;
    private Vector3 mutableBlock;
    private final Long2ObjectOpenHashMap<SoftReference<Map<Character, Object>>> changedBlocks = new Long2ObjectOpenHashMap();
    private final Object changeBlocksPresent = new Object();
    private final Map<Character, Object> changeBlocksFullMap = new HashMap<Character, Object>(){

        @Override
        public int size() {
            return 65535;
        }
    };
    private final BlockUpdateScheduler updateQueue;
    private final Queue<Block> normalUpdateQueue = new ConcurrentLinkedDeque<Block>();
    private final ConcurrentMap<Long, Int2ObjectMap<Player>> chunkSendQueue = new ConcurrentHashMap<Long, Int2ObjectMap<Player>>();
    private final LongSet chunkSendTasks = new LongOpenHashSet();
    private final Long2ObjectOpenHashMap<Boolean> chunkPopulationQueue = new Long2ObjectOpenHashMap();
    private final Long2ObjectOpenHashMap<Boolean> chunkPopulationLock = new Long2ObjectOpenHashMap();
    private final Long2ObjectOpenHashMap<Boolean> chunkGenerationQueue = new Long2ObjectOpenHashMap();
    private int chunkGenerationQueueSize = 8;
    private int chunkPopulationQueueSize = 2;
    private boolean autoSave;
    private BlockMetadataStore blockMetadata;
    private boolean useSections;
    private Position temporalPosition;
    private Vector3 temporalVector;
    public int sleepTicks = 0;
    private int chunkTickRadius;
    private final Long2IntMap chunkTickList = new Long2IntOpenHashMap();
    private int chunksPerTicks;
    private boolean clearChunksOnTick;
    private int updateLCG = ThreadLocalRandom.current().nextInt();
    private static final int LCG_CONSTANT = 1013904223;
    public LevelTimings timings;
    private int tickRate;
    public int tickRateTime = 0;
    public int tickRateCounter = 0;
    private Class<? extends Generator> generatorClass;
    private IterableThreadLocal<Generator> generators = new IterableThreadLocal<Generator>(){

        @Override
        public Generator init() {
            try {
                Generator generator = (Generator)Level.this.generatorClass.getConstructor(Map.class).newInstance(Level.this.provider.getGeneratorOptions());
                NukkitRandom rand = new NukkitRandom(Level.this.getSeed());
                if (Server.getInstance().isPrimaryThread()) {
                    generator.init(Level.this, rand);
                }
                generator.init(new PopChunkManager(Level.this.getSeed()), rand);
                return generator;
            }
            catch (Throwable e) {
                e.printStackTrace();
                return null;
            }
        }
    };
    private boolean raining = false;
    private int rainTime = 0;
    private boolean thundering = false;
    private int thunderTime = 0;
    private long levelCurrentTick = 0L;
    private int dimension;
    public GameRules gameRules;
    private Map<Long, Map<Character, Object>> lightQueue = new ConcurrentHashMap<Long, Map<Character, Object>>(8, 0.9f, 1);
    private static Entity[] EMPTY_ENTITY_ARR;
    private static Entity[] ENTITY_BUFFER;
    private int lastUnloadIndex;

    public Level(Server server, String name, String path, Class<? extends LevelProvider> provider) {
        this.levelId = levelIdCounter++;
        this.blockMetadata = new BlockMetadataStore(this);
        this.server = server;
        this.autoSave = server.getAutoSave();
        boolean convert = provider == McRegion.class || provider == LevelDB.class;
        try {
            if (convert) {
                String newPath = new File(path).getParent() + "/" + name + ".old/";
                new File(path).renameTo(new File(newPath));
                this.provider = provider.getConstructor(Level.class, String.class).newInstance(this, newPath);
            } else {
                this.provider = provider.getConstructor(Level.class, String.class).newInstance(this, path);
            }
        }
        catch (Exception e) {
            throw new LevelException("Caused by " + Utils.getExceptionMessage(e));
        }
        this.timings = new LevelTimings(this);
        if (convert) {
            this.server.getLogger().info(this.server.getLanguage().translateString("nukkit.level.updating", (Object)((Object)TextFormat.GREEN) + this.provider.getName() + (Object)((Object)TextFormat.WHITE)));
            LevelProvider old = this.provider;
            try {
                this.provider = new LevelProviderConverter(this, path).from(old).to(Anvil.class).perform();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            old.close();
        }
        this.provider.updateLevelName(name);
        this.server.getLogger().info(this.server.getLanguage().translateString("nukkit.level.preparing", (Object)((Object)TextFormat.GREEN) + this.provider.getName() + (Object)((Object)TextFormat.WHITE)));
        this.generatorClass = Generator.getGenerator(this.provider.getGenerator());
        try {
            this.useSections = (Boolean)provider.getMethod("usesChunkSection", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.folderName = name;
        this.time = this.provider.getTime();
        this.raining = this.provider.isRaining();
        this.rainTime = this.provider.getRainTime();
        if (this.rainTime <= 0) {
            this.setRainTime(ThreadLocalRandom.current().nextInt(168000) + 12000);
        }
        this.thundering = this.provider.isThundering();
        this.thunderTime = this.provider.getThunderTime();
        if (this.thunderTime <= 0) {
            this.setThunderTime(ThreadLocalRandom.current().nextInt(168000) + 12000);
        }
        this.levelCurrentTick = this.provider.getCurrentTick();
        this.updateQueue = new BlockUpdateScheduler(this, this.levelCurrentTick);
        this.chunkTickRadius = Math.min(this.server.getViewDistance(), Math.max(1, this.server.getConfig("chunk-ticking.tick-radius", 4)));
        this.chunksPerTicks = this.server.getConfig("chunk-ticking.per-tick", 40);
        this.chunkGenerationQueueSize = this.server.getConfig("chunk-generation.queue-size", 8);
        this.chunkPopulationQueueSize = this.server.getConfig("chunk-generation.population-queue-size", 2);
        this.chunkTickList.clear();
        this.clearChunksOnTick = this.server.getConfig("chunk-ticking.clear-tick-list", true);
        this.cacheChunks = this.server.getConfig("chunk-sending.cache-chunks", false);
        this.temporalPosition = new Position(0.0, 0.0, 0.0, this);
        this.temporalVector = new Vector3(0.0, 0.0, 0.0);
        this.tickRate = 1;
        this.skyLightSubtracted = this.calculateSkylightSubtracted(1.0f);
    }

    public static long chunkHash(int x, int z) {
        return (long)x << 32 | (long)z & 0xFFFFFFFFL;
    }

    public static long blockHash(int x, int y, int z) {
        if (y < 0 || y >= 256) {
            throw new IllegalArgumentException("Y coordinate y is out of range!");
        }
        return ((long)x & 0xFFFFFFFL) << 36 | ((long)y & 0xFFL) << 28 | (long)z & 0xFFFFFFFL;
    }

    public static char localBlockHash(double x, double y, double z) {
        byte hi = (byte)(((int)x & 0xF) + (((int)z & 0xF) << 4));
        byte lo = (byte)y;
        return (char)((hi & 0xFF) << 8 | lo & 0xFF);
    }

    public static Vector3 getBlockXYZ(long chunkHash, char blockHash) {
        byte hi = (byte)(blockHash >>> 8);
        byte lo = (byte)blockHash;
        int y = lo & 0xFF;
        int x = (hi & 0xF) + (Level.getHashX(chunkHash) << 4);
        int z = (hi >> 4 & 0xF) + (Level.getHashZ(chunkHash) << 4);
        return new Vector3(x, y, z);
    }

    public static int chunkBlockHash(int x, int y, int z) {
        return x << 12 | z << 8 | y;
    }

    public static int getHashX(long hash) {
        return (int)(hash >> 32);
    }

    public static int getHashZ(long hash) {
        return (int)hash;
    }

    public static Vector3 getBlockXYZ(BlockVector3 hash) {
        return new Vector3(hash.x, hash.y, hash.z);
    }

    public static Chunk.Entry getChunkXZ(long hash) {
        return new Chunk.Entry(Level.getHashX(hash), Level.getHashZ(hash));
    }

    public static int generateChunkLoaderId(ChunkLoader loader) {
        if (loader.getLoaderId() == 0) {
            return chunkLoaderCounter++;
        }
        throw new IllegalStateException("ChunkLoader has a loader id already assigned: " + loader.getLoaderId());
    }

    public int getTickRate() {
        return this.tickRate;
    }

    public int getTickRateTime() {
        return this.tickRateTime;
    }

    public void setTickRate(int tickRate) {
        this.tickRate = tickRate;
    }

    public void initLevel() {
        Generator generator = (Generator)this.generators.get();
        this.dimension = generator.getDimension();
        this.gameRules = this.provider.getGamerules();
        this.server.getLogger().info("Preparing start region for level \"" + this.getFolderName() + "\"");
        Position spawn = this.getSpawnLocation();
        this.populateChunk(spawn.getChunkX(), spawn.getChunkZ(), true);
    }

    public Generator getGenerator() {
        return (Generator)this.generators.get();
    }

    public BlockMetadataStore getBlockMetadata() {
        return this.blockMetadata;
    }

    public Server getServer() {
        return this.server;
    }

    public final LevelProvider getProvider() {
        return this.provider;
    }

    public final int getId() {
        return this.levelId;
    }

    public void close() {
        if (this.getAutoSave()) {
            this.save(true);
        }
        this.provider.close();
        this.provider = null;
        this.blockMetadata = null;
        this.temporalPosition = null;
        this.server.getLevels().remove(this.levelId);
        this.generators.clean();
    }

    public void addSound(Vector3 pos, Sound sound) {
        this.addSound(pos, sound, 1.0f, 1.0f, (Player[])null);
    }

    public void addSound(Vector3 pos, Sound sound, float volume, float pitch) {
        this.addSound(pos, sound, volume, pitch, (Player[])null);
    }

    public void addSound(Vector3 pos, Sound sound, float volume, float pitch, Collection<Player> players) {
        this.addSound(pos, sound, volume, pitch, players.toArray(new Player[0]));
    }

    public void addSound(Vector3 pos, Sound sound, float volume, float pitch, Player ... players) {
        Preconditions.checkArgument((volume >= 0.0f && volume <= 1.0f ? 1 : 0) != 0, (Object)"Sound volume must be between 0 and 1");
        Preconditions.checkArgument((pitch >= 0.0f ? 1 : 0) != 0, (Object)"Sound pitch must be higher than 0");
        PlaySoundPacket packet = new PlaySoundPacket();
        packet.name = sound.getSound();
        packet.volume = volume;
        packet.pitch = pitch;
        packet.x = pos.getFloorX();
        packet.y = pos.getFloorY();
        packet.z = pos.getFloorZ();
        if (players == null || players.length == 0) {
            this.addChunkPacket(pos.getFloorX() >> 4, pos.getFloorZ() >> 4, packet);
        } else {
            Server.broadcastPacket(players, (DataPacket)packet);
        }
    }

    public void addLevelEvent(int type, int data) {
        this.addLevelEvent(type, data, null);
    }

    public void addLevelEvent(int type, int data, Vector3 pos) {
        if (pos == null) {
            this.addLevelEvent(type, data, 0.0f, 0.0f, 0.0f);
        } else {
            this.addLevelEvent(type, data, (float)pos.x, (float)pos.y, (float)pos.z);
        }
    }

    public void addLevelEvent(int type, int data, float x, float y, float z) {
        LevelEventPacket packet = new LevelEventPacket();
        packet.evid = type;
        packet.x = x;
        packet.y = y;
        packet.z = z;
        packet.data = data;
        this.addChunkPacket(NukkitMath.floorFloat(x) >> 4, NukkitMath.floorFloat(z) >> 4, packet);
    }

    public void addLevelEvent(Vector3 pos, int event) {
        this.addLevelEvent(pos, event, 0);
    }

    @Since(value="1.3.2.0-PN")
    public void addLevelEvent(Vector3 pos, int event, int data) {
        LevelEventPacket pk = new LevelEventPacket();
        pk.evid = event;
        pk.x = (float)pos.x;
        pk.y = (float)pos.y;
        pk.z = (float)pos.z;
        pk.data = data;
        this.addChunkPacket(pos.getFloorX() >> 4, pos.getFloorZ() >> 4, pk);
    }

    public void addLevelSoundEvent(Vector3 pos, int type, int data, int entityType) {
        this.addLevelSoundEvent(pos, type, data, entityType, false, false);
    }

    public void addLevelSoundEvent(Vector3 pos, int type, int data, int entityType, boolean isBaby, boolean isGlobal) {
        String identifier = (String)AddEntityPacket.LEGACY_IDS.getOrDefault((Object)entityType, (Object)":");
        this.addLevelSoundEvent(pos, type, data, identifier, isBaby, isGlobal);
    }

    public void addLevelSoundEvent(Vector3 pos, int type) {
        this.addLevelSoundEvent(pos, type, -1);
    }

    public void addLevelSoundEvent(Vector3 pos, int type, int data) {
        this.addLevelSoundEvent(pos, type, data, ":", false, false);
    }

    public void addLevelSoundEvent(Vector3 pos, int type, int data, String identifier, boolean isBaby, boolean isGlobal) {
        LevelSoundEventPacket pk = new LevelSoundEventPacket();
        pk.sound = type;
        pk.extraData = data;
        pk.entityIdentifier = identifier;
        pk.x = (float)pos.x;
        pk.y = (float)pos.y;
        pk.z = (float)pos.z;
        pk.isGlobal = isGlobal;
        pk.isBabyMob = isBaby;
        this.addChunkPacket(pos.getFloorX() >> 4, pos.getFloorZ() >> 4, pk);
    }

    public void addParticle(Particle particle) {
        this.addParticle(particle, (Player[])null);
    }

    public void addParticle(Particle particle, Player player) {
        this.addParticle(particle, new Player[]{player});
    }

    public void addParticle(Particle particle, Player[] players) {
        DataPacket[] packets = particle.encode();
        if (players == null) {
            if (packets != null) {
                for (DataPacket packet : packets) {
                    this.addChunkPacket((int)particle.x >> 4, (int)particle.z >> 4, packet);
                }
            }
        } else if (packets != null) {
            if (packets.length == 1) {
                Server.broadcastPacket(players, packets[0]);
            } else {
                this.server.batchPackets(players, packets, false);
            }
        }
    }

    public void addParticle(Particle particle, Collection<Player> players) {
        this.addParticle(particle, players.toArray(new Player[0]));
    }

    public void addParticleEffect(Vector3 pos, ParticleEffect particleEffect) {
        this.addParticleEffect(pos, particleEffect, -1L, this.dimension, (Player[])null);
    }

    public void addParticleEffect(Vector3 pos, ParticleEffect particleEffect, long uniqueEntityId) {
        this.addParticleEffect(pos, particleEffect, uniqueEntityId, this.dimension, (Player[])null);
    }

    public void addParticleEffect(Vector3 pos, ParticleEffect particleEffect, long uniqueEntityId, int dimensionId) {
        this.addParticleEffect(pos, particleEffect, uniqueEntityId, dimensionId, (Player[])null);
    }

    public void addParticleEffect(Vector3 pos, ParticleEffect particleEffect, long uniqueEntityId, int dimensionId, Collection<Player> players) {
        this.addParticleEffect(pos, particleEffect, uniqueEntityId, dimensionId, players.toArray(new Player[0]));
    }

    public void addParticleEffect(Vector3 pos, ParticleEffect particleEffect, long uniqueEntityId, int dimensionId, Player ... players) {
        this.addParticleEffect(pos.asVector3f(), particleEffect.getIdentifier(), uniqueEntityId, dimensionId, players);
    }

    public void addParticleEffect(Vector3f pos, String identifier, long uniqueEntityId, int dimensionId, Player ... players) {
        SpawnParticleEffectPacket pk = new SpawnParticleEffectPacket();
        pk.identifier = identifier;
        pk.uniqueEntityId = uniqueEntityId;
        pk.dimensionId = dimensionId;
        pk.position = pos;
        if (players == null || players.length == 0) {
            this.addChunkPacket(pos.getFloorX() >> 4, pos.getFloorZ() >> 4, pk);
        } else {
            Server.broadcastPacket(players, (DataPacket)pk);
        }
    }

    public boolean getAutoSave() {
        return this.autoSave;
    }

    public void setAutoSave(boolean autoSave) {
        this.autoSave = autoSave;
    }

    public boolean unload() {
        return this.unload(false);
    }

    public boolean unload(boolean force) {
        LevelUnloadEvent ev = new LevelUnloadEvent(this);
        if (this == this.server.getDefaultLevel() && !force) {
            ev.setCancelled();
        }
        this.server.getPluginManager().callEvent(ev);
        if (!force && ev.isCancelled()) {
            return false;
        }
        this.server.getLogger().info(this.server.getLanguage().translateString("nukkit.level.unloading", (Object)((Object)TextFormat.GREEN) + this.getName() + (Object)((Object)TextFormat.WHITE)));
        Level defaultLevel = this.server.getDefaultLevel();
        for (Player player : new ArrayList<Player>(this.getPlayers().values())) {
            if (this == defaultLevel || defaultLevel == null) {
                player.close(player.getLeaveMessage(), "Forced default level unload");
                continue;
            }
            player.teleport(this.server.getDefaultLevel().getSafeSpawn());
        }
        if (this == defaultLevel) {
            this.server.setDefaultLevel(null);
        }
        this.close();
        return true;
    }

    public Map<Integer, Player> getChunkPlayers(int chunkX, int chunkZ) {
        long index = Level.chunkHash(chunkX, chunkZ);
        if (this.playerLoaders.containsKey(index)) {
            return new HashMap<Integer, Player>((Map)this.playerLoaders.get(index));
        }
        return new HashMap<Integer, Player>();
    }

    public ChunkLoader[] getChunkLoaders(int chunkX, int chunkZ) {
        long index = Level.chunkHash(chunkX, chunkZ);
        if (this.chunkLoaders.containsKey(index)) {
            return ((Map)this.chunkLoaders.get(index)).values().toArray(new ChunkLoader[0]);
        }
        return new ChunkLoader[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChunkPacket(int chunkX, int chunkZ, DataPacket packet) {
        long index = Level.chunkHash(chunkX, chunkZ);
        Long2ObjectOpenHashMap<Deque<DataPacket>> long2ObjectOpenHashMap = this.chunkPackets;
        synchronized (long2ObjectOpenHashMap) {
            Deque packets = (Deque)this.chunkPackets.computeIfAbsent(index, i -> new ArrayDeque());
            packets.add(packet);
        }
    }

    public void registerChunkLoader(ChunkLoader loader, int chunkX, int chunkZ) {
        this.registerChunkLoader(loader, chunkX, chunkZ, true);
    }

    public void registerChunkLoader(ChunkLoader loader, int chunkX, int chunkZ, boolean autoLoad) {
        int hash = loader.getLoaderId();
        long index = Level.chunkHash(chunkX, chunkZ);
        if (!this.chunkLoaders.containsKey(index)) {
            this.chunkLoaders.put(index, new HashMap());
            this.playerLoaders.put(index, new HashMap());
        } else if (((Map)this.chunkLoaders.get(index)).containsKey(hash)) {
            return;
        }
        ((Map)this.chunkLoaders.get(index)).put(hash, loader);
        if (loader instanceof Player) {
            ((Map)this.playerLoaders.get(index)).put(hash, (Player)loader);
        }
        if (!this.loaders.containsKey(hash)) {
            this.loaderCounter.put(hash, 1);
            this.loaders.put(hash, (Object)loader);
        } else {
            this.loaderCounter.put(hash, this.loaderCounter.get(hash) + 1);
        }
        this.cancelUnloadChunkRequest(hash);
        if (autoLoad) {
            this.loadChunk(chunkX, chunkZ);
        }
    }

    public void unregisterChunkLoader(ChunkLoader loader, int chunkX, int chunkZ) {
        ChunkLoader oldLoader;
        int hash = loader.getLoaderId();
        long index = Level.chunkHash(chunkX, chunkZ);
        Map chunkLoadersIndex = (Map)this.chunkLoaders.get(index);
        if (chunkLoadersIndex != null && (oldLoader = (ChunkLoader)chunkLoadersIndex.remove(hash)) != null) {
            if (chunkLoadersIndex.isEmpty()) {
                this.chunkLoaders.remove(index);
                this.playerLoaders.remove(index);
                this.unloadChunkRequest(chunkX, chunkZ, true);
            } else {
                Map playerLoadersIndex = (Map)this.playerLoaders.get(index);
                playerLoadersIndex.remove(hash);
            }
            int count = this.loaderCounter.get(hash);
            if (--count == 0) {
                this.loaderCounter.remove(hash);
                this.loaders.remove(hash);
            } else {
                this.loaderCounter.put(hash, count);
            }
        }
    }

    public void checkTime() {
        if (!this.stopTime && this.gameRules.getBoolean(GameRule.DO_DAYLIGHT_CYCLE)) {
            this.time += (float)this.tickRate;
        }
    }

    public void sendTime(Player ... players) {
        SetTimePacket pk = new SetTimePacket();
        pk.time = (int)this.time;
        Server.broadcastPacket(players, (DataPacket)pk);
    }

    public void sendTime() {
        this.sendTime((Player[])this.players.values().toArray((Object[])new Player[0]));
    }

    public GameRules getGameRules() {
        return this.gameRules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTick(int currentTick) {
        Object block;
        Long2ObjectMap.Entry entry;
        this.timings.doTick.startTiming();
        this.updateBlockLight(this.lightQueue);
        this.checkTime();
        if (currentTick % 1200 == 0) {
            this.sendTime();
        }
        if (this.dimension != 1 && this.dimension != 2 && this.gameRules.getBoolean(GameRule.DO_WEATHER_CYCLE)) {
            --this.rainTime;
            if (this.rainTime <= 0 && !this.setRaining(!this.raining)) {
                if (this.raining) {
                    this.setRainTime(ThreadLocalRandom.current().nextInt(12000) + 12000);
                } else {
                    this.setRainTime(ThreadLocalRandom.current().nextInt(168000) + 12000);
                }
            }
            --this.thunderTime;
            if (this.thunderTime <= 0 && !this.setThundering(!this.thundering)) {
                if (this.thundering) {
                    this.setThunderTime(ThreadLocalRandom.current().nextInt(12000) + 3600);
                } else {
                    this.setThunderTime(ThreadLocalRandom.current().nextInt(168000) + 12000);
                }
            }
            if (this.isThundering()) {
                Map<Long, ? extends FullChunk> chunks = this.getChunks();
                if (chunks instanceof Long2ObjectOpenHashMap) {
                    Long2ObjectOpenHashMap fastChunks = (Long2ObjectOpenHashMap)chunks;
                    ObjectIterator longIterator = fastChunks.long2ObjectEntrySet().fastIterator();
                    while (longIterator.hasNext()) {
                        entry = (Long2ObjectMap.Entry)longIterator.next();
                        this.performThunder(entry.getLongKey(), (FullChunk)entry.getValue());
                    }
                } else {
                    for (Map.Entry entry2 : this.getChunks().entrySet()) {
                        this.performThunder((Long)entry2.getKey(), (FullChunk)entry2.getValue());
                    }
                }
            }
        }
        this.skyLightSubtracted = this.calculateSkylightSubtracted(1.0f);
        ++this.levelCurrentTick;
        this.unloadChunks();
        this.timings.doTickPending.startTiming();
        boolean polled = false;
        this.updateQueue.tick(this.getCurrentTick());
        this.timings.doTickPending.stopTiming();
        while (!this.normalUpdateQueue.isEmpty()) {
            block = this.normalUpdateQueue.poll();
            block = this.getBlock((Vector3)block, block.layer);
            BlockUpdateEvent blockUpdateEvent = new BlockUpdateEvent((Block)block);
            this.server.getPluginManager().callEvent(blockUpdateEvent);
            if (blockUpdateEvent.isCancelled()) continue;
            block.onUpdate(1);
        }
        TimingsHistory.entityTicks += (long)this.updateEntities.size();
        this.timings.entityTick.startTiming();
        if (!this.updateEntities.isEmpty()) {
            block = new ArrayList(this.updateEntities.keySet()).iterator();
            while (block.hasNext()) {
                long l = (Long)block.next();
                Entity entity = (Entity)this.updateEntities.get(l);
                if (entity == null) {
                    this.updateEntities.remove(l);
                    continue;
                }
                if (!entity.closed && entity.onUpdate(currentTick)) continue;
                this.updateEntities.remove(l);
            }
        }
        this.timings.entityTick.stopTiming();
        TimingsHistory.tileEntityTicks += (long)this.updateBlockEntities.size();
        this.timings.blockEntityTick.startTiming();
        this.updateBlockEntities.removeIf(blockEntity -> !blockEntity.isValid() || !blockEntity.onUpdate());
        this.timings.blockEntityTick.stopTiming();
        this.timings.tickChunks.startTiming();
        this.tickChunks();
        this.timings.tickChunks.stopTiming();
        block = this.changedBlocks;
        synchronized (block) {
            if (!this.changedBlocks.isEmpty()) {
                if (!this.players.isEmpty()) {
                    ObjectIterator objectIterator = this.changedBlocks.long2ObjectEntrySet().fastIterator();
                    while (objectIterator.hasNext()) {
                        entry = (Long2ObjectMap.Entry)objectIterator.next();
                        long index = entry.getLongKey();
                        Map blocks = (Map)((SoftReference)entry.getValue()).get();
                        int chunkX = Level.getHashX(index);
                        int chunkZ = Level.getHashZ(index);
                        if (blocks == null || blocks.size() > 512) {
                            BaseFullChunk chunk = this.getChunk(chunkX, chunkZ);
                            for (Player p : this.getChunkPlayers(chunkX, chunkZ).values()) {
                                p.onChunkChanged(chunk);
                            }
                            continue;
                        }
                        Collection<Player> toSend = this.getChunkPlayers(chunkX, chunkZ).values();
                        Player[] playerArray = toSend.toArray(new Player[0]);
                        Vector3[] blocksArray = new Vector3[blocks.size()];
                        int i = 0;
                        Iterator iterator = blocks.keySet().iterator();
                        while (iterator.hasNext()) {
                            char blockHash = ((Character)iterator.next()).charValue();
                            Vector3 hash = Level.getBlockXYZ(index, blockHash);
                            blocksArray[i++] = hash;
                        }
                        this.sendBlocks(playerArray, blocksArray, 3);
                    }
                }
                this.changedBlocks.clear();
            }
        }
        this.processChunkRequest();
        if (this.sleepTicks > 0 && --this.sleepTicks <= 0) {
            this.checkSleep();
        }
        block = this.chunkPackets;
        synchronized (block) {
            LongIterator longIterator = this.chunkPackets.keySet().iterator();
            while (longIterator.hasNext()) {
                int chunkZ;
                long index = (Long)longIterator.next();
                int chunkX = Level.getHashX(index);
                Player[] chunkPlayers = this.getChunkPlayers(chunkX, chunkZ = Level.getHashZ(index)).values().toArray(new Player[0]);
                if (chunkPlayers.length <= 0) continue;
                for (DataPacket pk : (Deque)this.chunkPackets.get(index)) {
                    Server.broadcastPacket(chunkPlayers, pk);
                }
            }
            this.chunkPackets.clear();
        }
        if (this.gameRules.isStale()) {
            GameRulesChangedPacket packet = new GameRulesChangedPacket();
            packet.gameRules = this.gameRules;
            Server.broadcastPacket((Player[])this.players.values().toArray((Object[])new Player[0]), (DataPacket)packet);
            this.gameRules.refresh();
        }
        this.timings.doTick.stopTiming();
    }

    private void performThunder(long index, FullChunk chunk) {
        if (this.areNeighboringChunksLoaded(index)) {
            return;
        }
        if (ThreadLocalRandom.current().nextInt(10000) == 0) {
            int chunkZ;
            int LCG = this.getUpdateLCG() >> 2;
            int chunkX = chunk.getX() * 16;
            Vector3 vector = this.adjustPosToNearbyEntity(new Vector3(chunkX + (LCG & 0xF), 0.0, (chunkZ = chunk.getZ() * 16) + (LCG >> 8 & 0xF)));
            Biome biome = Biome.getBiome(this.getBiomeId(vector.getFloorX(), vector.getFloorZ()));
            if (!biome.canRain()) {
                return;
            }
            int bId = this.getBlockIdAt(vector.getFloorX(), vector.getFloorY(), vector.getFloorZ());
            if (bId != 31 && bId != 8) {
                vector.y += 1.0;
            }
            CompoundTag nbt = new CompoundTag().putList(new ListTag<DoubleTag>("Pos").add(new DoubleTag("", vector.x)).add(new DoubleTag("", vector.y)).add(new DoubleTag("", vector.z))).putList(new ListTag<DoubleTag>("Motion").add(new DoubleTag("", 0.0)).add(new DoubleTag("", 0.0)).add(new DoubleTag("", 0.0))).putList(new ListTag<FloatTag>("Rotation").add(new FloatTag("", 0.0f)).add(new FloatTag("", 0.0f)));
            EntityLightning bolt = new EntityLightning(chunk, nbt);
            LightningStrikeEvent ev = new LightningStrikeEvent(this, bolt);
            this.getServer().getPluginManager().callEvent(ev);
            if (!ev.isCancelled()) {
                bolt.spawnToAll();
            } else {
                bolt.setEffect(false);
            }
            this.addLevelSoundEvent(vector, 47, -1, 93);
            this.addLevelSoundEvent(vector, 48, -1, 93);
        }
    }

    public Vector3 adjustPosToNearbyEntity(Vector3 pos) {
        pos.y = this.getHighestBlockAt(pos.getFloorX(), pos.getFloorZ());
        AxisAlignedBB axisalignedbb = new SimpleAxisAlignedBB(pos.x, pos.y, pos.z, pos.getX(), 255.0, pos.getZ()).expand(3.0, 3.0, 3.0);
        ArrayList<Entity> list = new ArrayList<Entity>();
        for (Entity entity : this.getCollidingEntities(axisalignedbb)) {
            if (!entity.isAlive() || !this.canBlockSeeSky(entity)) continue;
            list.add(entity);
        }
        if (!list.isEmpty()) {
            return ((Entity)list.get(ThreadLocalRandom.current().nextInt(list.size()))).getPosition();
        }
        if (pos.getY() == -1.0) {
            pos = pos.up(2);
        }
        return pos;
    }

    public void checkSleep() {
        int time;
        if (this.players.isEmpty()) {
            return;
        }
        boolean resetTime = true;
        for (Player p : this.getPlayers().values()) {
            if (p.isSleeping()) continue;
            resetTime = false;
            break;
        }
        if (resetTime && (time = this.getTime() % 24000) >= 14000 && time < 23000) {
            this.setTime(this.getTime() + 24000 - time);
            for (Player p : this.getPlayers().values()) {
                p.stopSleep();
            }
        }
    }

    public void sendBlockExtraData(int x, int y, int z, int id, int data) {
        this.sendBlockExtraData(x, y, z, id, data, this.getChunkPlayers(x >> 4, z >> 4).values());
    }

    public void sendBlockExtraData(int x, int y, int z, int id, int data, Collection<Player> players) {
        this.sendBlockExtraData(x, y, z, id, data, players.toArray(new Player[0]));
    }

    public void sendBlockExtraData(int x, int y, int z, int id, int data, Player[] players) {
        LevelEventPacket pk = new LevelEventPacket();
        pk.evid = 4000;
        pk.x = (float)x + 0.5f;
        pk.y = (float)y + 0.5f;
        pk.z = (float)z + 0.5f;
        pk.data = data << 8 | id;
        Server.broadcastPacket(players, (DataPacket)pk);
    }

    public void sendBlocks(Player[] target, Vector3[] blocks) {
        this.sendBlocks(target, blocks, 0, 0);
        this.sendBlocks(target, blocks, 0, 1);
    }

    public void sendBlocks(Player[] target, Vector3[] blocks, int flags) {
        this.sendBlocks(target, blocks, flags, 0);
        this.sendBlocks(target, blocks, flags, 1);
    }

    public void sendBlocks(Player[] target, Vector3[] blocks, int flags, boolean optimizeRebuilds) {
        this.sendBlocks(target, blocks, flags, 0, optimizeRebuilds);
        this.sendBlocks(target, blocks, flags, 1, optimizeRebuilds);
    }

    public void sendBlocks(Player[] target, Vector3[] blocks, int flags, int dataLayer) {
        this.sendBlocks(target, blocks, flags, dataLayer, false);
    }

    public void sendBlocks(Player[] target, Vector3[] blocks, int flags, int dataLayer, boolean optimizeRebuilds) {
        int size = 0;
        for (Vector3 block : blocks) {
            if (block == null) continue;
            ++size;
        }
        int packetIndex = 0;
        DataPacket[] packets = new UpdateBlockPacket[size];
        LongOpenHashSet chunks = null;
        if (optimizeRebuilds) {
            chunks = new LongOpenHashSet();
        }
        for (Vector3 b : blocks) {
            long index;
            boolean first;
            if (b == null) continue;
            boolean bl = first = !optimizeRebuilds;
            if (optimizeRebuilds && !chunks.contains(index = Level.chunkHash((int)b.x >> 4, (int)b.z >> 4))) {
                chunks.add(index);
                first = true;
            }
            UpdateBlockPacket updateBlockPacket = new UpdateBlockPacket();
            updateBlockPacket.x = (int)b.x;
            updateBlockPacket.y = (int)b.y;
            updateBlockPacket.z = (int)b.z;
            updateBlockPacket.flags = first ? flags : 0;
            updateBlockPacket.dataLayer = dataLayer;
            int runtimeId = b instanceof Block ? ((Block)b).getRuntimeId() : this.getBlockRuntimeId((int)b.x, (int)b.y, (int)b.z, dataLayer);
            try {
                updateBlockPacket.blockRuntimeId = runtimeId;
            }
            catch (NoSuchElementException e) {
                throw new IllegalStateException("Unable to create BlockUpdatePacket at (" + b.x + ", " + b.y + ", " + b.z + ") in " + this.getName(), e);
            }
            packets[packetIndex++] = updateBlockPacket;
        }
        this.server.batchPackets(target, packets);
    }

    private void tickChunks() {
        if (this.chunksPerTicks <= 0 || this.loaders.isEmpty()) {
            this.chunkTickList.clear();
            return;
        }
        int chunksPerLoader = Math.min(200, Math.max(1, (int)((double)(this.chunksPerTicks - this.loaders.size()) / (double)this.loaders.size() + 0.5)));
        int randRange = 3 + chunksPerLoader / 30;
        randRange = Math.min(randRange, this.chunkTickRadius);
        ThreadLocalRandom random = ThreadLocalRandom.current();
        if (!this.loaders.isEmpty()) {
            for (ChunkLoader loader : this.loaders.values()) {
                int chunkX = (int)loader.getX() >> 4;
                int chunkZ = (int)loader.getZ() >> 4;
                long index = Level.chunkHash(chunkX, chunkZ);
                int existingLoaders = Math.max(0, this.chunkTickList.getOrDefault(index, 0));
                this.chunkTickList.put(index, existingLoaders + 1);
                for (int chunk = 0; chunk < chunksPerLoader; ++chunk) {
                    int dz;
                    int dx = random.nextInt(2 * randRange) - randRange;
                    long hash = Level.chunkHash(dx + chunkX, (dz = random.nextInt(2 * randRange) - randRange) + chunkZ);
                    if (this.chunkTickList.containsKey(hash) || !this.provider.isChunkLoaded(hash)) continue;
                    this.chunkTickList.put(hash, -1);
                }
            }
        }
        boolean blockTest = false;
        if (!this.chunkTickList.isEmpty()) {
            ObjectIterator iter = this.chunkTickList.long2IntEntrySet().iterator();
            while (iter.hasNext()) {
                int chunkZ;
                Long2IntMap.Entry entry = (Long2IntMap.Entry)iter.next();
                long index = entry.getLongKey();
                if (!this.areNeighboringChunksLoaded(index)) {
                    iter.remove();
                    continue;
                }
                int loaders = entry.getIntValue();
                int chunkX = Level.getHashX(index);
                BaseFullChunk chunk = this.getChunk(chunkX, chunkZ = Level.getHashZ(index), false);
                if (chunk == null) {
                    iter.remove();
                    continue;
                }
                if (loaders <= 0) {
                    iter.remove();
                }
                for (Entity entity : chunk.getEntities().values()) {
                    entity.scheduleUpdate();
                }
                int tickSpeed = this.gameRules.getInteger(GameRule.RANDOM_TICK_SPEED);
                if (tickSpeed <= 0) continue;
                if (this.useSections) {
                    for (ChunkSection section : ((Chunk)((Object)chunk)).getSections()) {
                        if (section instanceof EmptyChunkSection) continue;
                        int Y = section.getY();
                        for (int i = 0; i < tickSpeed; ++i) {
                            int z;
                            int y;
                            int lcg = this.getUpdateLCG();
                            int x = lcg & 0xF;
                            int[] state = section.getBlockState(x, y = lcg >>> 8 & 0xF, z = lcg >>> 16 & 0xF);
                            if (!randomTickBlocks[state[0]]) continue;
                            Block block = Block.get(state[0], state[1], this, chunkX * 16 + x, (Y << 4) + y, chunkZ * 16 + z);
                            block.onUpdate(2);
                        }
                    }
                    continue;
                }
                for (int Y = 0; Y < 8 && (Y < 3 || blockTest); ++Y) {
                    blockTest = false;
                    for (int i = 0; i < tickSpeed; ++i) {
                        int lcg = this.getUpdateLCG();
                        int x = lcg & 0xF;
                        int y = lcg >>> 8 & 0xF;
                        int z = lcg >>> 16 & 0xF;
                        int[] state = chunk.getBlockState(x, y + (Y << 4), z);
                        int blockId = state[0];
                        blockTest |= state[0] != 0 && state[1] != 0;
                        if (!randomTickBlocks[blockId]) continue;
                        Block block = Block.get(state[0], state[1], this, x, y + (Y << 4), z);
                        block.onUpdate(2);
                    }
                }
            }
        }
        if (this.clearChunksOnTick) {
            this.chunkTickList.clear();
        }
    }

    public boolean save() {
        return this.save(false);
    }

    public boolean save(boolean force) {
        if (!this.getAutoSave() && !force) {
            return false;
        }
        this.server.getPluginManager().callEvent(new LevelSaveEvent(this));
        this.provider.setTime((int)this.time);
        this.provider.setRaining(this.raining);
        this.provider.setRainTime(this.rainTime);
        this.provider.setThundering(this.thundering);
        this.provider.setThunderTime(this.thunderTime);
        this.provider.setCurrentTick(this.levelCurrentTick);
        this.provider.setGameRules(this.gameRules);
        this.saveChunks();
        if (this.provider instanceof BaseLevelProvider) {
            this.provider.saveLevelData();
        }
        return true;
    }

    public void saveChunks() {
        this.provider.saveChunks();
    }

    public void updateAroundRedstone(Vector3 pos, BlockFace face) {
        for (BlockFace side : BlockFace.values()) {
            if (face != null && side == face || this.getBlock(pos) instanceof BlockPistonBase) continue;
            this.getBlock(pos.getSide(side)).onUpdate(6);
        }
    }

    public void updateComparatorOutputLevel(Vector3 v) {
        for (BlockFace face : BlockFace.Plane.HORIZONTAL) {
            Vector3 pos = v.getSide(face);
            if (!this.isChunkLoaded((int)pos.x >> 4, (int)pos.z >> 4)) continue;
            Block block1 = this.getBlock(pos);
            if (BlockRedstoneDiode.isDiode(block1)) {
                block1.onUpdate(6);
                continue;
            }
            if (!block1.isNormalBlock() || !BlockRedstoneDiode.isDiode(block1 = this.getBlock(pos = pos.getSide(face)))) continue;
            block1.onUpdate(6);
        }
    }

    public void updateAround(Vector3 pos) {
        Block block = this.getBlock(pos);
        for (BlockFace face : BlockFace.values()) {
            Block side = block.getSideAtLayer(0, face);
            this.normalUpdateQueue.add(side);
            this.normalUpdateQueue.add(side.getLevelBlockAtLayer(1));
        }
    }

    public void updateAround(int x, int y, int z) {
        this.updateAround(new Vector3(x, y, z));
    }

    public void scheduleUpdate(Block pos, int delay) {
        this.scheduleUpdate(pos, pos, delay, 0, true);
    }

    public void scheduleUpdate(Block block, Vector3 pos, int delay) {
        this.scheduleUpdate(block, pos, delay, 0, true);
    }

    public void scheduleUpdate(Block block, Vector3 pos, int delay, int priority) {
        this.scheduleUpdate(block, pos, delay, priority, true);
    }

    public void scheduleUpdate(Block block, Vector3 pos, int delay, int priority, boolean checkArea) {
        if (block.getId() == 0 || checkArea && !this.isChunkLoaded(block.getFloorX() >> 4, block.getFloorZ() >> 4)) {
            return;
        }
        BlockUpdateEntry entry = new BlockUpdateEntry(pos.floor(), block, (long)delay + this.getCurrentTick(), priority);
        if (!this.updateQueue.contains(entry)) {
            this.updateQueue.add(entry);
        }
    }

    public boolean cancelSheduledUpdate(Vector3 pos, Block block) {
        return this.updateQueue.remove(new BlockUpdateEntry(pos, block));
    }

    public boolean isUpdateScheduled(Vector3 pos, Block block) {
        return this.updateQueue.contains(new BlockUpdateEntry(pos, block));
    }

    public boolean isBlockTickPending(Vector3 pos, Block block) {
        return this.updateQueue.isBlockTickPending(pos, block);
    }

    public Set<BlockUpdateEntry> getPendingBlockUpdates(FullChunk chunk) {
        int minX = (chunk.getX() << 4) - 2;
        int maxX = minX + 16 + 2;
        int minZ = (chunk.getZ() << 4) - 2;
        int maxZ = minZ + 16 + 2;
        return this.getPendingBlockUpdates(new SimpleAxisAlignedBB(minX, 0.0, minZ, maxX, 256.0, maxZ));
    }

    public Set<BlockUpdateEntry> getPendingBlockUpdates(AxisAlignedBB boundingBox) {
        return this.updateQueue.getPendingBlockUpdates(boundingBox);
    }

    public Block[] getCollisionBlocks(AxisAlignedBB bb) {
        return this.getCollisionBlocks(bb, false);
    }

    public Block[] getCollisionBlocks(AxisAlignedBB bb, boolean targetFirst) {
        return this.getCollisionBlocks(bb, targetFirst, false);
    }

    public Block[] getCollisionBlocks(AxisAlignedBB bb, boolean targetFirst, boolean ignoreCollidesCheck) {
        return this.getCollisionBlocks(bb, targetFirst, ignoreCollidesCheck, block -> block.getId() != 0);
    }

    public Block[] getCollisionBlocks(AxisAlignedBB bb, boolean targetFirst, boolean ignoreCollidesCheck, Predicate<Block> condition) {
        int minX = NukkitMath.floorDouble(bb.getMinX());
        int minY = NukkitMath.floorDouble(bb.getMinY());
        int minZ = NukkitMath.floorDouble(bb.getMinZ());
        int maxX = NukkitMath.ceilDouble(bb.getMaxX());
        int maxY = NukkitMath.ceilDouble(bb.getMaxY());
        int maxZ = NukkitMath.ceilDouble(bb.getMaxZ());
        ArrayList<Block> collides = new ArrayList<Block>();
        if (targetFirst) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int x = minX; x <= maxX; ++x) {
                    for (int y = minY; y <= maxY; ++y) {
                        Block block = this.getBlock(this.temporalVector.setComponents(x, y, z), false);
                        if (block == null || !condition.test(block) || !ignoreCollidesCheck && !block.collidesWithBB(bb)) continue;
                        return new Block[]{block};
                    }
                }
            }
        } else {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int x = minX; x <= maxX; ++x) {
                    for (int y = minY; y <= maxY; ++y) {
                        Block block = this.getBlock(this.temporalVector.setComponents(x, y, z), false);
                        if (block == null || !condition.test(block) || !ignoreCollidesCheck && !block.collidesWithBB(bb)) continue;
                        collides.add(block);
                    }
                }
            }
        }
        return collides.toArray(new Block[0]);
    }

    public boolean isFullBlock(Vector3 pos) {
        AxisAlignedBB bb;
        if (pos instanceof Block) {
            if (((Block)pos).isSolid()) {
                return true;
            }
            bb = ((Block)pos).getBoundingBox();
        } else {
            bb = this.getBlock(pos).getBoundingBox();
        }
        return bb != null && bb.getAverageEdgeLength() >= 1.0;
    }

    public AxisAlignedBB[] getCollisionCubes(Entity entity, AxisAlignedBB bb) {
        return this.getCollisionCubes(entity, bb, true);
    }

    public AxisAlignedBB[] getCollisionCubes(Entity entity, AxisAlignedBB bb, boolean entities) {
        return this.getCollisionCubes(entity, bb, entities, false);
    }

    public AxisAlignedBB[] getCollisionCubes(Entity entity, AxisAlignedBB bb, boolean entities, boolean solidEntities) {
        int minX = NukkitMath.floorDouble(bb.getMinX());
        int minY = NukkitMath.floorDouble(bb.getMinY());
        int minZ = NukkitMath.floorDouble(bb.getMinZ());
        int maxX = NukkitMath.ceilDouble(bb.getMaxX());
        int maxY = NukkitMath.ceilDouble(bb.getMaxY());
        int maxZ = NukkitMath.ceilDouble(bb.getMaxZ());
        ArrayList<AxisAlignedBB> collides = new ArrayList<AxisAlignedBB>();
        for (int z = minZ; z <= maxZ; ++z) {
            for (int x = minX; x <= maxX; ++x) {
                for (int y = minY; y <= maxY; ++y) {
                    Block block = this.getBlock(this.temporalVector.setComponents(x, y, z), false);
                    if (block.canPassThrough() || !block.collidesWithBB(bb)) continue;
                    collides.add(block.getBoundingBox());
                }
            }
        }
        if (entities || solidEntities) {
            for (Entity ent : this.getCollidingEntities(bb.grow(0.25, 0.25, 0.25), entity)) {
                if (!solidEntities || ent.canPassThrough()) continue;
                collides.add(ent.boundingBox.clone());
            }
        }
        return collides.toArray(new AxisAlignedBB[0]);
    }

    public boolean hasCollision(Entity entity, AxisAlignedBB bb, boolean entities) {
        int minX = NukkitMath.floorDouble(bb.getMinX());
        int minY = NukkitMath.floorDouble(bb.getMinY());
        int minZ = NukkitMath.floorDouble(bb.getMinZ());
        int maxX = NukkitMath.ceilDouble(bb.getMaxX());
        int maxY = NukkitMath.ceilDouble(bb.getMaxY());
        int maxZ = NukkitMath.ceilDouble(bb.getMaxZ());
        for (int z = minZ; z <= maxZ; ++z) {
            for (int x = minX; x <= maxX; ++x) {
                for (int y = minY; y <= maxY; ++y) {
                    Block block = this.getBlock(this.temporalVector.setComponents(x, y, z));
                    if (block.canPassThrough() || !block.collidesWithBB(bb)) continue;
                    return true;
                }
            }
        }
        if (entities) {
            return this.getCollidingEntities(bb.grow(0.25, 0.25, 0.25), entity).length > 0;
        }
        return false;
    }

    public int getFullLight(Vector3 pos) {
        BaseFullChunk chunk = this.getChunk((int)pos.x >> 4, (int)pos.z >> 4, false);
        int level = 0;
        if (chunk != null) {
            level = chunk.getBlockSkyLight((int)pos.x & 0xF, (int)pos.y & 0xFF, (int)pos.z & 0xF);
            if ((level = (int)((float)level - this.skyLightSubtracted)) < 15) {
                level = Math.max(chunk.getBlockLight((int)pos.x & 0xF, (int)pos.y & 0xFF, (int)pos.z & 0xF), level);
            }
        }
        return level;
    }

    public int calculateSkylightSubtracted(float tickDiff) {
        float angle = this.getCelestialAngle(tickDiff);
        float light = 1.0f - (MathHelper.cos(angle * ((float)Math.PI * 2)) * 2.0f + 0.5f);
        light = MathHelper.clamp(light, 0.0f, 1.0f);
        light = 1.0f - light;
        light = (float)((double)light * (1.0 - (double)(this.getRainStrength(tickDiff) * 5.0f) / 16.0));
        light = (float)((double)light * (1.0 - (double)(this.getThunderStrength(tickDiff) * 5.0f) / 16.0));
        light = 1.0f - light;
        return (int)(light * 11.0f);
    }

    public float getRainStrength(float tickDiff) {
        return this.isRaining() ? 1.0f : 0.0f;
    }

    public float getThunderStrength(float tickDiff) {
        return this.isThundering() ? 1.0f : 0.0f;
    }

    public float getCelestialAngle(float tickDiff) {
        return this.calculateCelestialAngle(this.getTime(), tickDiff);
    }

    public float calculateCelestialAngle(int time, float tickDiff) {
        int i = (int)((long)time % 24000L);
        float angle = ((float)i + tickDiff) / 24000.0f - 0.25f;
        if (angle < 0.0f) {
            angle += 1.0f;
        }
        if (angle > 1.0f) {
            angle -= 1.0f;
        }
        float f1 = 1.0f - (float)((Math.cos((double)angle * Math.PI) + 1.0) / 2.0);
        angle += (f1 - angle) / 3.0f;
        return angle;
    }

    public int getMoonPhase(long worldTime) {
        return (int)(worldTime / 24000L % 8L + 8L) % 8;
    }

    @Deprecated
    @DeprecationDetails(reason="Does not support hyper ids", since="1.3.0.0-PN")
    public int getFullBlock(int x, int y, int z) {
        return this.getFullBlock(x, y, z, 0);
    }

    @Deprecated
    @DeprecationDetails(reason="Does not support hyper ids", since="1.3.0.0-PN")
    public int getFullBlock(int x, int y, int z, int layer) {
        return this.getChunk(x >> 4, z >> 4, false).getFullBlock(x & 0xF, y & 0xFF, z & 0xF, layer);
    }

    @PowerNukkitOnly
    @Since(value="1.3.0.0-PN")
    public int getBlockRuntimeId(int x, int y, int z) {
        return this.getBlockRuntimeId(x, y, z, 0);
    }

    @PowerNukkitOnly
    @Since(value="1.3.0.0-PN")
    public int getBlockRuntimeId(int x, int y, int z, int layer) {
        return this.getChunk(x >> 4, z >> 4, false).getBlockRuntimeId(x & 0xF, y & 0xFF, z & 0xF, layer);
    }

    public synchronized Block getBlock(Vector3 pos) {
        return this.getBlock(pos, 0);
    }

    public synchronized Block getBlock(Vector3 pos, int layer) {
        return this.getBlock(pos.getFloorX(), pos.getFloorY(), pos.getFloorZ(), layer);
    }

    public synchronized Block getBlock(Vector3 pos, boolean load) {
        return this.getBlock(pos, 0, load);
    }

    public synchronized Block getBlock(Vector3 pos, int layer, boolean load) {
        return this.getBlock(pos.getFloorX(), pos.getFloorY(), pos.getFloorZ(), layer, load);
    }

    public synchronized Block getBlock(int x, int y, int z) {
        return this.getBlock(x, y, z, 0);
    }

    public synchronized Block getBlock(int x, int y, int z, int layer) {
        return this.getBlock(x, y, z, layer, true);
    }

    public synchronized Block getBlock(int x, int y, int z, boolean load) {
        return this.getBlock(x, y, z, 0, load);
    }

    public synchronized Block getBlock(int x, int y, int z, int layer, boolean load) {
        int[] fullState;
        if (y >= 0 && y < 256) {
            int cx = x >> 4;
            int cz = z >> 4;
            BaseFullChunk chunk = load ? this.getChunk(cx, cz) : this.getChunkIfLoaded(cx, cz);
            fullState = chunk != null ? chunk.getBlockState(x & 0xF, y, z & 0xF, layer) : new int[]{0, 0};
        } else {
            fullState = new int[]{0, 0};
        }
        Block block = Block.get(fullState[0], fullState[1]);
        block.x = x;
        block.y = y;
        block.z = z;
        block.level = this;
        block.layer = layer;
        return block;
    }

    public void updateAllLight(Vector3 pos) {
        this.updateBlockSkyLight((int)pos.x, (int)pos.y, (int)pos.z);
        this.addLightUpdate((int)pos.x, (int)pos.y, (int)pos.z);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateBlockSkyLight(int x, int y, int z) {
        int newHeightMap;
        BaseFullChunk chunk = this.getChunkIfLoaded(x >> 4, z >> 4);
        if (chunk == null) {
            return;
        }
        int oldHeightMap = chunk.getHeightMap(x & 0xF, z & 0xF);
        int sourceId = this.getBlockIdAt(x, y, z);
        int yPlusOne = y + 1;
        if (yPlusOne == oldHeightMap) {
            newHeightMap = chunk.recalculateHeightMapColumn(x & 0xF, z & 0xF);
        } else if (yPlusOne > oldHeightMap) {
            if (Block.lightFilter[sourceId] <= 1 && !Block.diffusesSkyLight[sourceId]) return;
            chunk.setHeightMap(x & 0xF, y & 0xF, yPlusOne);
            newHeightMap = yPlusOne;
        } else {
            newHeightMap = oldHeightMap;
        }
        if (newHeightMap > oldHeightMap) {
            for (int i = y; i >= oldHeightMap; --i) {
                this.setBlockSkyLightAt(x, i, z, 0);
            }
            return;
        } else if (newHeightMap < oldHeightMap) {
            for (int i = y; i >= newHeightMap; --i) {
                this.setBlockSkyLightAt(x, i, z, 15);
            }
            return;
        } else {
            this.setBlockSkyLightAt(x, y, z, Math.max(0, this.getHighestAdjacentBlockSkyLight(x, y, z) - Block.lightFilter[sourceId]));
        }
    }

    public int getHighestAdjacentBlockSkyLight(int x, int y, int z) {
        int[] lightLevels = new int[]{this.getBlockSkyLightAt(x + 1, y, z), this.getBlockSkyLightAt(x - 1, y, z), this.getBlockSkyLightAt(x, y + 1, z), this.getBlockSkyLightAt(x, y - 1, z), this.getBlockSkyLightAt(x, y, z + 1), this.getBlockSkyLightAt(x, y, z - 1)};
        int maxValue = lightLevels[0];
        for (int i = 1; i < lightLevels.length; ++i) {
            if (lightLevels[i] <= maxValue) continue;
            maxValue = lightLevels[i];
        }
        return maxValue;
    }

    public void updateBlockLight(Map<Long, Map<Character, Object>> map) {
        int size = map.size();
        if (size == 0) {
            return;
        }
        ConcurrentLinkedQueue<Long> lightPropagationQueue = new ConcurrentLinkedQueue<Long>();
        ConcurrentLinkedQueue<Object[]> lightRemovalQueue = new ConcurrentLinkedQueue<Object[]>();
        Long2ObjectOpenHashMap visited = new Long2ObjectOpenHashMap();
        Long2ObjectOpenHashMap removalVisited = new Long2ObjectOpenHashMap();
        Iterator<Map.Entry<Long, Map<Character, Object>>> iter = map.entrySet().iterator();
        while (iter.hasNext() && size-- > 0) {
            Map.Entry<Long, Map<Character, Object>> entry = iter.next();
            iter.remove();
            long index = entry.getKey();
            Map<Character, Object> blocks = entry.getValue();
            int chunkX = Level.getHashX(index);
            int chunkZ = Level.getHashZ(index);
            int bx = chunkX << 4;
            int bz = chunkZ << 4;
            for (char blockHash : blocks.keySet()) {
                int newLevel;
                int lcz;
                int lcx;
                int oldLevel;
                byte hi = (byte)(blockHash >>> 8);
                byte lo = (byte)blockHash;
                int y = lo & 0xFF;
                int x = (hi & 0xF) + bx;
                int z = (hi >> 4 & 0xF) + bz;
                BaseFullChunk chunk = this.getChunk(x >> 4, z >> 4, false);
                if (chunk == null || (oldLevel = chunk.getBlockLight(lcx = x & 0xF, y, lcz = z & 0xF)) == (newLevel = Block.fullLight[chunk.getFullBlock(lcx, y, lcz)])) continue;
                this.setBlockLightAt(x, y, z, newLevel);
                if (newLevel < oldLevel) {
                    removalVisited.put(Hash.hashBlock(x, y, z), this.changeBlocksPresent);
                    lightRemovalQueue.add(new Object[]{Hash.hashBlock(x, y, z), oldLevel});
                    continue;
                }
                visited.put(Hash.hashBlock(x, y, z), this.changeBlocksPresent);
                lightPropagationQueue.add(Hash.hashBlock(x, y, z));
            }
        }
        while (!lightRemovalQueue.isEmpty()) {
            Object[] val = (Object[])lightRemovalQueue.poll();
            long node = (Long)val[0];
            int x = Hash.hashBlockX(node);
            int y = Hash.hashBlockY(node);
            int z = Hash.hashBlockZ(node);
            int lightLevel = (Integer)val[1];
            this.computeRemoveBlockLight(x - 1, y, z, lightLevel, lightRemovalQueue, lightPropagationQueue, (Map<Long, Object>)removalVisited, (Map<Long, Object>)visited);
            this.computeRemoveBlockLight(x + 1, y, z, lightLevel, lightRemovalQueue, lightPropagationQueue, (Map<Long, Object>)removalVisited, (Map<Long, Object>)visited);
            this.computeRemoveBlockLight(x, y - 1, z, lightLevel, lightRemovalQueue, lightPropagationQueue, (Map<Long, Object>)removalVisited, (Map<Long, Object>)visited);
            this.computeRemoveBlockLight(x, y + 1, z, lightLevel, lightRemovalQueue, lightPropagationQueue, (Map<Long, Object>)removalVisited, (Map<Long, Object>)visited);
            this.computeRemoveBlockLight(x, y, z - 1, lightLevel, lightRemovalQueue, lightPropagationQueue, (Map<Long, Object>)removalVisited, (Map<Long, Object>)visited);
            this.computeRemoveBlockLight(x, y, z + 1, lightLevel, lightRemovalQueue, lightPropagationQueue, (Map<Long, Object>)removalVisited, (Map<Long, Object>)visited);
        }
        while (!lightPropagationQueue.isEmpty()) {
            int z;
            int y;
            long node = (Long)lightPropagationQueue.poll();
            int x = Hash.hashBlockX(node);
            int lightLevel = this.getBlockLightAt(x, y = Hash.hashBlockY(node), z = Hash.hashBlockZ(node)) - Block.lightFilter[this.getBlockIdAt(x, y, z)];
            if (lightLevel < 1) continue;
            this.computeSpreadBlockLight(x - 1, y, z, lightLevel, lightPropagationQueue, (Map<Long, Object>)visited);
            this.computeSpreadBlockLight(x + 1, y, z, lightLevel, lightPropagationQueue, (Map<Long, Object>)visited);
            this.computeSpreadBlockLight(x, y - 1, z, lightLevel, lightPropagationQueue, (Map<Long, Object>)visited);
            this.computeSpreadBlockLight(x, y + 1, z, lightLevel, lightPropagationQueue, (Map<Long, Object>)visited);
            this.computeSpreadBlockLight(x, y, z - 1, lightLevel, lightPropagationQueue, (Map<Long, Object>)visited);
            this.computeSpreadBlockLight(x, y, z + 1, lightLevel, lightPropagationQueue, (Map<Long, Object>)visited);
        }
    }

    private void computeRemoveBlockLight(int x, int y, int z, int currentLight, Queue<Object[]> queue, Queue<Long> spreadQueue, Map<Long, Object> visited, Map<Long, Object> spreadVisited) {
        int current = this.getBlockLightAt(x, y, z);
        long index = Hash.hashBlock(x, y, z);
        if (current != 0 && current < currentLight) {
            this.setBlockLightAt(x, y, z, 0);
            if (current > 1 && !visited.containsKey(index)) {
                visited.put(index, this.changeBlocksPresent);
                queue.add(new Object[]{Hash.hashBlock(x, y, z), current});
            }
        } else if (current >= currentLight && !spreadVisited.containsKey(index)) {
            spreadVisited.put(index, this.changeBlocksPresent);
            spreadQueue.add(Hash.hashBlock(x, y, z));
        }
    }

    private void computeSpreadBlockLight(int x, int y, int z, int currentLight, Queue<Long> queue, Map<Long, Object> visited) {
        int current = this.getBlockLightAt(x, y, z);
        long index = Hash.hashBlock(x, y, z);
        if (current < currentLight - 1) {
            this.setBlockLightAt(x, y, z, currentLight);
            if (!visited.containsKey(index)) {
                visited.put(index, this.changeBlocksPresent);
                if (currentLight > 1) {
                    queue.add(Hash.hashBlock(x, y, z));
                }
            }
        }
    }

    public void addLightUpdate(int x, int y, int z) {
        long index = Level.chunkHash(x >> 4, z >> 4);
        Map<Character, Object> currentMap = this.lightQueue.get(index);
        if (currentMap == null) {
            currentMap = new ConcurrentHashMap<Character, Object>(8, 0.9f, 1);
            this.lightQueue.put(index, currentMap);
        }
        currentMap.put(Character.valueOf(Level.localBlockHash(x, y, z)), this.changeBlocksPresent);
    }

    @Override
    public synchronized void setBlockFullIdAt(int x, int y, int z, int fullId) {
        this.setBlockFullIdAt(x, y, z, 0, fullId);
    }

    @Override
    public synchronized void setBlockFullIdAt(int x, int y, int z, int layer, int fullId) {
        this.setBlock(x, y, z, layer, Block.fullList[fullId], false, false);
    }

    public synchronized boolean setBlock(Vector3 pos, Block block) {
        return this.setBlock(pos, 0, block);
    }

    public synchronized boolean setBlock(Vector3 pos, int layer, Block block) {
        return this.setBlock(pos, layer, block, false);
    }

    public synchronized boolean setBlock(Vector3 pos, Block block, boolean direct) {
        return this.setBlock(pos, 0, block, direct);
    }

    public synchronized boolean setBlock(Vector3 pos, int layer, Block block, boolean direct) {
        return this.setBlock(pos, layer, block, direct, true);
    }

    public synchronized boolean setBlock(Vector3 pos, Block block, boolean direct, boolean update) {
        return this.setBlock(pos, 0, block, direct, update);
    }

    public synchronized boolean setBlock(Vector3 pos, int layer, Block block, boolean direct, boolean update) {
        return this.setBlock(pos.getFloorX(), pos.getFloorY(), pos.getFloorZ(), layer, block, direct, update);
    }

    public synchronized boolean setBlock(int x, int y, int z, Block block, boolean direct, boolean update) {
        return this.setBlock(x, y, z, 0, block, direct, update);
    }

    public synchronized boolean setBlock(int x, int y, int z, int layer, Block block, boolean direct, boolean update) {
        if (y < 0 || y >= 256 || layer < 0 || layer > this.provider.getMaximumLayer()) {
            return false;
        }
        BaseFullChunk chunk = this.getChunk(x >> 4, z >> 4, true);
        Block blockPrevious = chunk.getAndSetBlock(x & 0xF, y, z & 0xF, layer, block);
        if (Block.equals(blockPrevious, block, true)) {
            return false;
        }
        block.x = x;
        block.y = y;
        block.z = z;
        block.level = this;
        block.layer = layer;
        int cx = x >> 4;
        int cz = z >> 4;
        long index = Level.chunkHash(cx, cz);
        if (direct) {
            this.sendBlocks(this.getChunkPlayers(cx, cz).values().toArray(new Player[0]), (Vector3[])new Block[]{block}, 11, block.layer);
        } else {
            this.addBlockChange(index, x, y, z);
        }
        for (ChunkLoader loader : this.getChunkLoaders(cx, cz)) {
            loader.onBlockChanged(block);
        }
        if (update) {
            this.updateAllLight(block);
            BlockUpdateEvent ev = new BlockUpdateEvent(block);
            this.server.getPluginManager().callEvent(ev);
            if (!ev.isCancelled()) {
                for (Entity entity : this.getNearbyEntities(new SimpleAxisAlignedBB(x - 1, y - 1, z - 1, x + 1, y + 1, z + 1))) {
                    entity.scheduleUpdate();
                }
                block = ev.getBlock();
                block.onUpdate(1);
                block.getLevelBlockAtLayer(layer == 0 ? 1 : 0).onUpdate(1);
                this.updateAround(x, y, z);
                if (block.hasComparatorInputOverride()) {
                    this.updateComparatorOutputLevel(block);
                }
            }
        }
        blockPrevious.afterRemoval(block, update);
        return true;
    }

    private void addBlockChange(int x, int y, int z) {
        long index = Level.chunkHash(x >> 4, z >> 4);
        this.addBlockChange(index, x, y, z);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addBlockChange(long index, int x, int y, int z) {
        Long2ObjectOpenHashMap<SoftReference<Map<Character, Object>>> long2ObjectOpenHashMap = this.changedBlocks;
        synchronized (long2ObjectOpenHashMap) {
            SoftReference current = (SoftReference)this.changedBlocks.computeIfAbsent(index, k -> new SoftReference(new HashMap()));
            Map currentMap = (Map)current.get();
            if (currentMap != this.changeBlocksFullMap && currentMap != null) {
                if (currentMap.size() > 512) {
                    this.changedBlocks.put(index, new SoftReference<Map<Character, Object>>(this.changeBlocksFullMap));
                } else {
                    currentMap.put(Character.valueOf(Level.localBlockHash(x, y, z)), this.changeBlocksPresent);
                }
            }
        }
    }

    public void dropItem(Vector3 source, Item item) {
        this.dropItem(source, item, null);
    }

    public void dropItem(Vector3 source, Item item, Vector3 motion) {
        this.dropItem(source, item, motion, 10);
    }

    public void dropItem(Vector3 source, Item item, Vector3 motion, int delay) {
        this.dropItem(source, item, motion, false, delay);
    }

    public void dropItem(Vector3 source, Item item, Vector3 motion, boolean dropAround, int delay) {
        EntityItem itemEntity;
        if (motion == null) {
            if (dropAround) {
                float f = ThreadLocalRandom.current().nextFloat() * 0.5f;
                float f1 = ThreadLocalRandom.current().nextFloat() * ((float)Math.PI * 2);
                motion = new Vector3(-MathHelper.sin(f1) * f, 0.2f, MathHelper.cos(f1) * f);
            } else {
                motion = new Vector3(new Random().nextDouble() * 0.2 - 0.1, 0.2, new Random().nextDouble() * 0.2 - 0.1);
            }
        }
        if (item.getId() > 0 && item.getCount() > 0 && (itemEntity = (EntityItem)Entity.createEntity("Item", (FullChunk)this.getChunk((int)source.getX() >> 4, (int)source.getZ() >> 4, true), Entity.getDefaultNBT(source, motion, new Random().nextFloat() * 360.0f, 0.0f).putShort("Health", 5).putCompound("Item", NBTIO.putItemHelper(item)).putShort("PickupDelay", delay), new Object[0])) != null) {
            itemEntity.spawnToAll();
        }
    }

    @Since(value="1.3.2.0-PN")
    public EntityItem dropAndGetItem(Vector3 source, Item item) {
        return this.dropAndGetItem(source, item, null);
    }

    @Since(value="1.3.2.0-PN")
    public EntityItem dropAndGetItem(Vector3 source, Item item, Vector3 motion) {
        return this.dropAndGetItem(source, item, motion, 10);
    }

    @Since(value="1.3.2.0-PN")
    public EntityItem dropAndGetItem(Vector3 source, Item item, Vector3 motion, int delay) {
        return this.dropAndGetItem(source, item, motion, false, delay);
    }

    @Since(value="1.3.2.0-PN")
    public EntityItem dropAndGetItem(Vector3 source, Item item, Vector3 motion, boolean dropAround, int delay) {
        EntityItem itemEntity = null;
        if (motion == null) {
            if (dropAround) {
                float f = ThreadLocalRandom.current().nextFloat() * 0.5f;
                float f1 = ThreadLocalRandom.current().nextFloat() * ((float)Math.PI * 2);
                motion = new Vector3(-MathHelper.sin(f1) * f, 0.2f, MathHelper.cos(f1) * f);
            } else {
                motion = new Vector3(new Random().nextDouble() * 0.2 - 0.1, 0.2, new Random().nextDouble() * 0.2 - 0.1);
            }
        }
        CompoundTag itemTag = NBTIO.putItemHelper(item);
        itemTag.setName("Item");
        if (item.getId() != 0 && item.getCount() > 0 && (itemEntity = (EntityItem)Entity.createEntity("Item", (FullChunk)this.getChunk((int)source.getX() >> 4, (int)source.getZ() >> 4, true), new CompoundTag().putList(new ListTag<DoubleTag>("Pos").add(new DoubleTag("", source.getX())).add(new DoubleTag("", source.getY())).add(new DoubleTag("", source.getZ()))).putList(new ListTag<DoubleTag>("Motion").add(new DoubleTag("", motion.x)).add(new DoubleTag("", motion.y)).add(new DoubleTag("", motion.z))).putList(new ListTag<FloatTag>("Rotation").add(new FloatTag("", ThreadLocalRandom.current().nextFloat() * 360.0f)).add(new FloatTag("", 0.0f))).putShort("Health", 5).putCompound("Item", itemTag).putShort("PickupDelay", delay), new Object[0])) != null) {
            itemEntity.spawnToAll();
        }
        return itemEntity;
    }

    public Item useBreakOn(Vector3 vector) {
        return this.useBreakOn(vector, null);
    }

    public Item useBreakOn(Vector3 vector, Item item) {
        return this.useBreakOn(vector, item, null);
    }

    public Item useBreakOn(Vector3 vector, Item item, Player player) {
        return this.useBreakOn(vector, item, player, false);
    }

    public Item useBreakOn(Vector3 vector, Item item, Player player, boolean createParticles) {
        return this.useBreakOn(vector, null, item, player, createParticles);
    }

    public Item useBreakOn(Vector3 vector, BlockFace face, Item item, Player player, boolean createParticles) {
        return this.useBreakOn(vector, face, item, player, createParticles, false);
    }

    public Item useBreakOn(Vector3 vector, BlockFace face, Item item, Player player, boolean createParticles, boolean setBlockDestroy) {
        if (vector instanceof Block) {
            return this.useBreakOn(vector, ((Block)vector).layer, face, item, player, createParticles, setBlockDestroy);
        }
        return this.useBreakOn(vector, 0, face, item, player, createParticles, setBlockDestroy);
    }

    public Item useBreakOn(Vector3 vector, int layer, BlockFace face, Item item, Player player, boolean createParticles, boolean setBlockDestroy) {
        BlockEntity blockEntity;
        Item[] drops;
        boolean isSilkTouch;
        if (player != null && player.getGamemode() > 2) {
            return null;
        }
        Block target = this.getBlock(vector, layer);
        int dropExp = target.getDropExp();
        if (item == null) {
            item = new ItemBlock(Block.get(0), (Integer)0, 0);
        }
        boolean mustDrop = target.mustDrop(vector, layer, face, item, player);
        boolean mustSilkTouch = target.mustSilkTouch(vector, layer, face, item, player);
        boolean bl = isSilkTouch = mustSilkTouch || item.getEnchantment(16) != null;
        if (player != null) {
            Enchantment eff;
            if (player.getGamemode() == 2) {
                Tag tag = item.getNamedTagEntry("CanDestroy");
                boolean canBreak = false;
                if (tag instanceof ListTag) {
                    for (Tag v : ((ListTag)tag).getAll()) {
                        Item entry;
                        if (!(v instanceof StringTag) || (entry = Item.fromString(((StringTag)v).data)).getId() <= 0 || entry.getBlock() == null || entry.getBlock().getId() != target.getId()) continue;
                        canBreak = true;
                        break;
                    }
                }
                if (!canBreak) {
                    return null;
                }
            }
            double breakTime = target.getBreakTime(item, player);
            if ((setBlockDestroy || player.isCreative()) && breakTime > 0.15) {
                breakTime = 0.15;
            }
            if (player.hasEffect(3)) {
                breakTime *= 1.0 - 0.2 * (double)(player.getEffect(3).getAmplifier() + 1);
            }
            if (player.hasEffect(4)) {
                breakTime *= 1.0 - 0.3 * (double)(player.getEffect(4).getAmplifier() + 1);
            }
            if ((eff = item.getEnchantment(15)) != null && eff.getLevel() > 0) {
                breakTime *= 1.0 - 0.3 * (double)eff.getLevel();
            }
            breakTime -= 0.15;
            Item[] eventDrops = !mustDrop && !setBlockDestroy && !player.isSurvival() ? new Item[]{} : (mustSilkTouch || isSilkTouch && target.canSilkTouch() ? new Item[]{target.toItem()} : target.getDrops(item));
            if (!setBlockDestroy) {
                BlockBreakEvent ev = new BlockBreakEvent(player, target, face, item, eventDrops, player.isCreative(), Long.sum(player.lastBreak, (long)breakTime * 1000L) > System.currentTimeMillis());
                if (player.isSurvival() && !target.isBreakable(item)) {
                    ev.setCancelled();
                } else if (!player.isOp() && this.isInSpawnRadius(target)) {
                    ev.setCancelled();
                } else if (!ev.getInstaBreak() && ev.isFastBreak()) {
                    ev.setCancelled();
                }
                this.server.getPluginManager().callEvent(ev);
                if (ev.isCancelled()) {
                    return null;
                }
                if (!ev.getInstaBreak() && ev.isFastBreak()) {
                    return null;
                }
                player.lastBreak = System.currentTimeMillis();
                drops = ev.getDrops();
                dropExp = ev.getDropExp();
            } else {
                drops = eventDrops;
            }
        } else {
            if (!target.isBreakable(item)) {
                return null;
            }
            drops = isSilkTouch ? new Item[]{target.toItem()} : target.getDrops(item);
        }
        Block above = this.getBlock(new Vector3(target.x, target.y + 1.0, target.z), 0);
        if (above != null && above.getId() == 51) {
            this.setBlock((Vector3)above, Block.get(0), true);
        }
        if (createParticles) {
            Map<Integer, Player> players = this.getChunkPlayers((int)target.x >> 4, (int)target.z >> 4);
            this.addParticle((Particle)new DestroyBlockParticle(target.add(0.5), target), players.values());
            if (player != null && !setBlockDestroy) {
                players.remove(player.getLoaderId());
            }
        }
        if (layer == 0 && (blockEntity = this.getBlockEntity(target)) != null) {
            blockEntity.onBreak(isSilkTouch);
            blockEntity.close();
            this.updateComparatorOutputLevel(target);
        }
        target.onBreak(item);
        item.useOn(target);
        if (item.isTool() && item.getDamage() >= item.getMaxDurability()) {
            item = new ItemBlock(Block.get(0), (Integer)0, 0);
        }
        if (this.gameRules.getBoolean(GameRule.DO_TILE_DROPS)) {
            if (!isSilkTouch && (mustDrop || player != null && (player.isSurvival() || setBlockDestroy)) && dropExp > 0 && drops.length != 0) {
                this.dropExpOrb(vector.add(0.5, 0.5, 0.5), dropExp);
            }
            if (mustDrop || player == null || setBlockDestroy || player.isSurvival()) {
                for (Item drop : drops) {
                    if (drop.getCount() <= 0) continue;
                    this.dropItem(vector.add(0.5, 0.5, 0.5), drop);
                }
            }
        }
        return item;
    }

    public void dropExpOrb(Vector3 source, int exp) {
        this.dropExpOrb(source, exp, null);
    }

    public void dropExpOrb(Vector3 source, int exp, Vector3 motion) {
        this.dropExpOrb(source, exp, motion, 10);
    }

    public void dropExpOrb(Vector3 source, int exp, Vector3 motion, int delay) {
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        for (int split : EntityXPOrb.splitIntoOrbSizes(exp)) {
            CompoundTag nbt = Entity.getDefaultNBT(source, motion == null ? new Vector3((((Random)rand).nextDouble() * 0.2 - 0.1) * 2.0, ((Random)rand).nextDouble() * 0.4, (((Random)rand).nextDouble() * 0.2 - 0.1) * 2.0) : motion, ((Random)rand).nextFloat() * 360.0f, 0.0f);
            nbt.putShort("Value", split);
            nbt.putShort("PickupDelay", delay);
            Entity entity = Entity.createEntity("XpOrb", (FullChunk)this.getChunk(source.getChunkX(), source.getChunkZ()), nbt, new Object[0]);
            if (entity == null) continue;
            entity.spawnToAll();
        }
    }

    public Item useItemOn(Vector3 vector, Item item, BlockFace face, float fx, float fy, float fz) {
        return this.useItemOn(vector, item, face, fx, fy, fz, null);
    }

    public Item useItemOn(Vector3 vector, Item item, BlockFace face, float fx, float fy, float fz, Player player) {
        return this.useItemOn(vector, item, face, fx, fy, fz, player, true);
    }

    @PowerNukkitDifference(info="PowerNukkit#403", since="1.3.1.2-PN")
    public Item useItemOn(Vector3 vector, Item item, BlockFace face, float fx, float fy, float fz, Player player, boolean playSound) {
        Block target = this.getBlock(vector);
        Block block = target.getSide(face);
        if (item.getBlock() instanceof BlockScaffolding && face == BlockFace.UP && block.getId() == 420) {
            while (block instanceof BlockScaffolding) {
                block = block.up();
            }
        }
        if (block.y > 255.0 || block.y < 0.0) {
            return null;
        }
        if (block.y > 127.0 && this.getDimension() == 1) {
            return null;
        }
        if (target.getId() == 0) {
            return null;
        }
        if (player != null) {
            PlayerInteractEvent ev = new PlayerInteractEvent(player, item, target, face, target.getId() == 0 ? PlayerInteractEvent.Action.RIGHT_CLICK_AIR : PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK);
            if (player.getGamemode() > 2) {
                ev.setCancelled();
            }
            if (!player.isOp() && this.isInSpawnRadius(target)) {
                ev.setCancelled();
            }
            this.server.getPluginManager().callEvent(ev);
            if (!ev.isCancelled()) {
                target.onUpdate(5);
                if ((!player.isSneaking() && this.getBlockEntity(target) != null || this.getBlockEntity(target) == null || player.getInventory().getItemInHand().isNull()) && target.canBeActivated() && target.onActivate(item, player)) {
                    if (item.isTool() && item.getDamage() >= item.getMaxDurability()) {
                        item = new ItemBlock(Block.get(0), (Integer)0, 0);
                    }
                    return item;
                }
                if (item.canBeActivated() && item.onActivate(this, player, block, target, face, fx, fy, fz) && item.getCount() <= 0) {
                    item = new ItemBlock(Block.get(0), (Integer)0, 0);
                    return item;
                }
            } else {
                if (item instanceof ItemBucket && ((ItemBucket)item).isWater()) {
                    player.getLevel().sendBlocks(new Player[]{player}, (Vector3[])new Block[]{Block.get(0, 0, target.getLevelBlockAtLayer(1))}, 11, 1);
                }
                return null;
            }
            if (item instanceof ItemBucket && ((ItemBucket)item).isWater()) {
                player.getLevel().sendBlocks(new Player[]{player}, (Vector3[])new Block[]{target.getLevelBlockAtLayer(1)}, 11, 1);
            }
        } else if (target.canBeActivated() && target.onActivate(item, player)) {
            if (item.isTool() && item.getDamage() >= item.getMaxDurability()) {
                item = new ItemBlock(Block.get(0), (Integer)0, 0);
            }
            return item;
        }
        if (!item.canBePlaced()) {
            return null;
        }
        Block hand = item.getBlock();
        hand.position(block);
        if (!(block.canBeReplaced() || hand.getId() == 44 && block.getId() == 44)) {
            return null;
        }
        if (target.canBeReplaced()) {
            block = target;
            hand.position(block);
        }
        if (!hand.canPassThrough() && hand.getBoundingBox() != null) {
            Position diff;
            Entity[] entities = this.getCollidingEntities(hand.getBoundingBox());
            int realCount = 0;
            for (Entity e : entities) {
                if (e instanceof EntityArrow || e instanceof EntityItem || e instanceof Player && ((Player)e).isSpectator()) continue;
                ++realCount;
            }
            if (player != null && (diff = player.getNextPosition().subtract(player.getPosition())).lengthSquared() > 1.0E-5) {
                AxisAlignedBB bb = player.getBoundingBox().getOffsetBoundingBox(diff.x, diff.y, diff.z);
                if (hand.getBoundingBox().intersectsWith(bb)) {
                    ++realCount;
                }
            }
            if (realCount > 0) {
                return null;
            }
        }
        if (player != null) {
            BlockPlaceEvent event = new BlockPlaceEvent(player, hand, block, target, item);
            if (player.getGamemode() == 2) {
                Tag tag = item.getNamedTagEntry("CanPlaceOn");
                boolean canPlace = false;
                if (tag instanceof ListTag) {
                    for (Tag v : ((ListTag)tag).getAll()) {
                        Item entry;
                        if (!(v instanceof StringTag) || (entry = Item.fromString(((StringTag)v).data)).getId() <= 0 || entry.getBlock() == null || entry.getBlock().getId() != target.getId()) continue;
                        canPlace = true;
                        break;
                    }
                }
                if (!canPlace) {
                    event.setCancelled();
                }
            }
            if (!player.isOp() && this.isInSpawnRadius(target)) {
                event.setCancelled();
            }
            this.server.getPluginManager().callEvent(event);
            if (event.isCancelled()) {
                return null;
            }
        }
        if (hand.getWaterloggingLevel() == 0 && hand.canBeFlowedInto() && (block instanceof BlockLiquid || block.getLevelBlockAtLayer(1) instanceof BlockLiquid)) {
            return null;
        }
        boolean liquidMoved = false;
        if (block instanceof BlockLiquid && ((BlockLiquid)block).usesWaterLogging()) {
            liquidMoved = true;
            this.setBlock(block, 1, block, false, false);
            this.setBlock(block, 0, Block.get(0), false, false);
            this.scheduleUpdate(block, 1);
        }
        if (!hand.place(item, block, target, face, fx, fy, fz, player)) {
            if (liquidMoved) {
                this.setBlock(block, 0, block, false, false);
                this.setBlock(block, 1, Block.get(0), false, false);
            }
            return null;
        }
        if (player != null && !player.isCreative()) {
            item.setCount(item.getCount() - 1);
        }
        if (playSound) {
            this.addLevelSoundEvent(hand, 6, GlobalBlockPalette.getOrCreateRuntimeId(hand.getId(), hand.getDamage()));
        }
        if (item.getCount() <= 0) {
            item = new ItemBlock(Block.get(0), (Integer)0, 0);
        }
        return item;
    }

    public boolean isInSpawnRadius(Vector3 vector3) {
        int distance = this.server.getSpawnRadius();
        if (distance > -1) {
            Vector2 t = new Vector2(vector3.x, vector3.z);
            Vector2 s = new Vector2(this.getSpawnLocation().x, this.getSpawnLocation().z);
            return t.distance(s) <= (double)distance;
        }
        return false;
    }

    public Entity getEntity(long entityId) {
        return this.entities.containsKey(entityId) ? (Entity)this.entities.get(entityId) : null;
    }

    public Entity[] getEntities() {
        return (Entity[])this.entities.values().toArray((Object[])new Entity[0]);
    }

    public Entity[] getCollidingEntities(AxisAlignedBB bb) {
        return this.getCollidingEntities(bb, null);
    }

    public Entity[] getCollidingEntities(AxisAlignedBB bb, Entity entity) {
        ArrayList<Entity> nearby = new ArrayList<Entity>();
        if (entity == null || entity.canCollide()) {
            int minX = NukkitMath.floorDouble((bb.getMinX() - 2.0) / 16.0);
            int maxX = NukkitMath.ceilDouble((bb.getMaxX() + 2.0) / 16.0);
            int minZ = NukkitMath.floorDouble((bb.getMinZ() - 2.0) / 16.0);
            int maxZ = NukkitMath.ceilDouble((bb.getMaxZ() + 2.0) / 16.0);
            for (int x = minX; x <= maxX; ++x) {
                for (int z = minZ; z <= maxZ; ++z) {
                    for (Entity ent : this.getChunkEntities(x, z, false).values()) {
                        if (entity != null && (ent == entity || !entity.canCollideWith(ent)) || !ent.boundingBox.intersectsWith(bb)) continue;
                        nearby.add(ent);
                    }
                }
            }
        }
        return nearby.toArray(new Entity[0]);
    }

    public Entity[] getNearbyEntities(AxisAlignedBB bb) {
        return this.getNearbyEntities(bb, null);
    }

    public Entity[] getNearbyEntities(AxisAlignedBB bb, Entity entity) {
        return this.getNearbyEntities(bb, entity, false);
    }

    public Entity[] getNearbyEntities(AxisAlignedBB bb, Entity entity, boolean loadChunks) {
        Entity[] copy;
        int index = 0;
        int minX = NukkitMath.floorDouble((bb.getMinX() - 2.0) * 0.0625);
        int maxX = NukkitMath.ceilDouble((bb.getMaxX() + 2.0) * 0.0625);
        int minZ = NukkitMath.floorDouble((bb.getMinZ() - 2.0) * 0.0625);
        int maxZ = NukkitMath.ceilDouble((bb.getMaxZ() + 2.0) * 0.0625);
        ArrayList<Entity> overflow = null;
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (Entity ent : this.getChunkEntities(x, z, loadChunks).values()) {
                    if (ent == entity || !ent.boundingBox.intersectsWith(bb)) continue;
                    if (index < ENTITY_BUFFER.length) {
                        Level.ENTITY_BUFFER[index] = ent;
                    } else {
                        if (overflow == null) {
                            overflow = new ArrayList<Entity>(1024);
                        }
                        overflow.add(ent);
                    }
                    ++index;
                }
            }
        }
        if (index == 0) {
            return EMPTY_ENTITY_ARR;
        }
        if (overflow == null) {
            copy = Arrays.copyOfRange(ENTITY_BUFFER, 0, index);
            Arrays.fill(ENTITY_BUFFER, 0, index, null);
        } else {
            copy = new Entity[ENTITY_BUFFER.length + overflow.size()];
            System.arraycopy(ENTITY_BUFFER, 0, copy, 0, ENTITY_BUFFER.length);
            for (int i = 0; i < overflow.size(); ++i) {
                copy[Level.ENTITY_BUFFER.length + i] = (Entity)overflow.get(i);
            }
        }
        return copy;
    }

    public Map<Long, BlockEntity> getBlockEntities() {
        return this.blockEntities;
    }

    public BlockEntity getBlockEntityById(long blockEntityId) {
        return this.blockEntities.containsKey(blockEntityId) ? (BlockEntity)this.blockEntities.get(blockEntityId) : null;
    }

    public Map<Long, Player> getPlayers() {
        return this.players;
    }

    public Map<Integer, ChunkLoader> getLoaders() {
        return this.loaders;
    }

    public BlockEntity getBlockEntity(Vector3 pos) {
        return this.getBlockEntity(pos.asBlockVector3());
    }

    public BlockEntity getBlockEntity(BlockVector3 pos) {
        BaseFullChunk chunk = this.getChunk(pos.x >> 4, pos.z >> 4, false);
        if (chunk != null) {
            return chunk.getTile(pos.x & 0xF, pos.y & 0xFF, pos.z & 0xF);
        }
        return null;
    }

    public BlockEntity getBlockEntityIfLoaded(Vector3 pos) {
        BaseFullChunk chunk = this.getChunkIfLoaded((int)pos.x >> 4, (int)pos.z >> 4);
        if (chunk != null) {
            return chunk.getTile((int)pos.x & 0xF, (int)pos.y & 0xFF, (int)pos.z & 0xF);
        }
        return null;
    }

    public Map<Long, Entity> getChunkEntities(int X, int Z) {
        return this.getChunkEntities(X, Z, true);
    }

    public Map<Long, Entity> getChunkEntities(int X, int Z, boolean loadChunks) {
        BaseFullChunk chunk = loadChunks ? this.getChunk(X, Z) : this.getChunkIfLoaded(X, Z);
        return chunk != null ? chunk.getEntities() : Collections.emptyMap();
    }

    public Map<Long, BlockEntity> getChunkBlockEntities(int X, int Z) {
        BaseFullChunk chunk = this.getChunk(X, Z);
        return chunk != null ? chunk.getBlockEntities() : Collections.emptyMap();
    }

    @Override
    public int getBlockIdAt(int x, int y, int z) {
        return this.getBlockIdAt(x, y, z, 0);
    }

    @Override
    public synchronized int getBlockIdAt(int x, int y, int z, int layer) {
        return this.getChunk(x >> 4, z >> 4, true).getBlockId(x & 0xF, y & 0xFF, z & 0xF, layer);
    }

    @Override
    public void setBlockIdAt(int x, int y, int z, int id) {
        this.setBlockIdAt(x, y, z, 0, id);
    }

    @Override
    public synchronized void setBlockIdAt(int x, int y, int z, int layer, int id) {
        this.getChunk(x >> 4, z >> 4, true).setBlockId(x & 0xF, y & 0xFF, z & 0xF, layer, id & 0xFFF);
        this.addBlockChange(x, y, z);
        this.temporalVector.setComponents(x, y, z);
        for (ChunkLoader loader : this.getChunkLoaders(x >> 4, z >> 4)) {
            loader.onBlockChanged(this.temporalVector);
        }
    }

    @Override
    public synchronized void setBlockAt(int x, int y, int z, int id, int data) {
        this.setBlockAtLayer(x, y, z, 0, id, data);
    }

    @Override
    public synchronized boolean setBlockAtLayer(int x, int y, int z, int layer, int id, int data) {
        BaseFullChunk chunk = this.getChunk(x >> 4, z >> 4, true);
        boolean changed = chunk.setBlockAtLayer(x & 0xF, y & 0xFF, z & 0xF, layer, id & 0xFF, data & 0xF);
        chunk.setBlockId(x & 0xF, y & 0xFF, z & 0xF, id & 0xFF);
        chunk.setBlockData(x & 0xF, y & 0xFF, z & 0xF, data & 0xF);
        this.addBlockChange(x, y, z);
        this.temporalVector.setComponents(x, y, z);
        for (ChunkLoader loader : this.getChunkLoaders(x >> 4, z >> 4)) {
            loader.onBlockChanged(this.temporalVector);
        }
        return changed;
    }

    @Override
    public int getBlockDataAt(int x, int y, int z) {
        return this.getBlockDataAt(x, y, z, 0);
    }

    public synchronized int getBlockExtraDataAt(int x, int y, int z) {
        return this.getChunk(x >> 4, z >> 4, true).getBlockExtraData(x & 0xF, y & 0xFF, z & 0xF);
    }

    public synchronized void setBlockExtraDataAt(int x, int y, int z, int id, int data) {
        this.getChunk(x >> 4, z >> 4, true).setBlockExtraData(x & 0xF, y & 0xFF, z & 0xF, data << 8 | id);
        this.sendBlockExtraData(x, y, z, id, data);
    }

    @Override
    public synchronized int getBlockDataAt(int x, int y, int z, int layer) {
        return this.getChunk(x >> 4, z >> 4, true).getBlockData(x & 0xF, y & 0xFF, z & 0xF, layer);
    }

    @Override
    public void setBlockDataAt(int x, int y, int z, int data) {
        this.setBlockDataAt(x, y, z, 0, data);
    }

    @Override
    public synchronized void setBlockDataAt(int x, int y, int z, int layer, int data) {
        this.getChunk(x >> 4, z >> 4, true).setBlockData(x & 0xF, y & 0xFF, z & 0xF, layer, data & 0xF);
        this.addBlockChange(x, y, z);
        this.temporalVector.setComponents(x, y, z);
        for (ChunkLoader loader : this.getChunkLoaders(x >> 4, z >> 4)) {
            loader.onBlockChanged(this.temporalVector);
        }
    }

    public synchronized int getBlockSkyLightAt(int x, int y, int z) {
        return this.getChunk(x >> 4, z >> 4, true).getBlockSkyLight(x & 0xF, y & 0xFF, z & 0xF);
    }

    public synchronized void setBlockSkyLightAt(int x, int y, int z, int level) {
        this.getChunk(x >> 4, z >> 4, true).setBlockSkyLight(x & 0xF, y & 0xFF, z & 0xF, level & 0xF);
    }

    public synchronized int getBlockLightAt(int x, int y, int z) {
        return this.getChunk(x >> 4, z >> 4, true).getBlockLight(x & 0xF, y & 0xFF, z & 0xF);
    }

    public synchronized void setBlockLightAt(int x, int y, int z, int level) {
        this.getChunk(x >> 4, z >> 4, true).setBlockLight(x & 0xF, y & 0xFF, z & 0xF, level & 0xF);
    }

    public int getBiomeId(int x, int z) {
        return this.getChunk(x >> 4, z >> 4, true).getBiomeId(x & 0xF, z & 0xF);
    }

    public void setBiomeId(int x, int z, byte biomeId) {
        this.getChunk(x >> 4, z >> 4, true).setBiomeId(x & 0xF, z & 0xF, biomeId);
    }

    public int getHeightMap(int x, int z) {
        return this.getChunk(x >> 4, z >> 4, true).getHeightMap(x & 0xF, z & 0xF);
    }

    public void setHeightMap(int x, int z, int value) {
        this.getChunk(x >> 4, z >> 4, true).setHeightMap(x & 0xF, z & 0xF, value & 0xF);
    }

    public Map<Long, ? extends FullChunk> getChunks() {
        return this.provider.getLoadedChunks();
    }

    @Override
    public BaseFullChunk getChunk(int chunkX, int chunkZ) {
        return this.getChunk(chunkX, chunkZ, false);
    }

    public BaseFullChunk getChunk(int chunkX, int chunkZ, boolean create) {
        long index = Level.chunkHash(chunkX, chunkZ);
        BaseFullChunk chunk = this.provider.getLoadedChunk(index);
        if (chunk == null) {
            chunk = this.forceLoadChunk(index, chunkX, chunkZ, create);
        }
        return chunk;
    }

    public BaseFullChunk getChunkIfLoaded(int chunkX, int chunkZ) {
        long index = Level.chunkHash(chunkX, chunkZ);
        return this.provider.getLoadedChunk(index);
    }

    public void generateChunkCallback(int x, int z, BaseFullChunk chunk) {
        this.generateChunkCallback(x, z, chunk, true);
    }

    public void generateChunkCallback(int x, int z, BaseFullChunk chunk, boolean isPopulated) {
        Timings.generationCallbackTimer.startTiming();
        long index = Level.chunkHash(x, z);
        if (this.chunkPopulationQueue.containsKey(index)) {
            BaseFullChunk oldChunk = this.getChunk(x, z, false);
            for (int xx = -1; xx <= 1; ++xx) {
                for (int zz = -1; zz <= 1; ++zz) {
                    this.chunkPopulationLock.remove(Level.chunkHash(x + xx, z + zz));
                }
            }
            this.chunkPopulationQueue.remove(index);
            chunk.setProvider(this.provider);
            this.setChunk(x, z, chunk, false);
            chunk = this.getChunk(x, z, false);
            if (chunk != null && (oldChunk == null || !isPopulated) && chunk.isPopulated() && chunk.getProvider() != null) {
                this.server.getPluginManager().callEvent(new ChunkPopulateEvent(chunk));
                for (ChunkLoader loader : this.getChunkLoaders(x, z)) {
                    loader.onChunkPopulated(chunk);
                }
            }
        } else if (this.chunkGenerationQueue.containsKey(index) || this.chunkPopulationLock.containsKey(index)) {
            this.chunkGenerationQueue.remove(index);
            this.chunkPopulationLock.remove(index);
            chunk.setProvider(this.provider);
            this.setChunk(x, z, chunk, false);
        } else {
            chunk.setProvider(this.provider);
            this.setChunk(x, z, chunk, false);
        }
        Timings.generationCallbackTimer.stopTiming();
    }

    @Override
    public void setChunk(int chunkX, int chunkZ) {
        this.setChunk(chunkX, chunkZ, null);
    }

    @Override
    public void setChunk(int chunkX, int chunkZ, BaseFullChunk chunk) {
        this.setChunk(chunkX, chunkZ, chunk, true);
    }

    public void setChunk(int chunkX, int chunkZ, BaseFullChunk chunk, boolean unload) {
        if (chunk == null) {
            return;
        }
        long index = Level.chunkHash(chunkX, chunkZ);
        BaseFullChunk oldChunk = this.getChunk(chunkX, chunkZ, false);
        if (oldChunk != chunk) {
            if (unload && oldChunk != null) {
                this.unloadChunk(chunkX, chunkZ, false, false);
                this.provider.setChunk(chunkX, chunkZ, chunk);
            } else {
                Map.Entry<Object, Object> entry;
                Iterator<Map.Entry<Object, Object>> iter;
                Map<Object, Object> oldBlockEntities;
                Map<Object, Object> oldEntities = oldChunk != null ? oldChunk.getEntities() : Collections.emptyMap();
                Map<Object, Object> map = oldBlockEntities = oldChunk != null ? oldChunk.getBlockEntities() : Collections.emptyMap();
                if (!oldEntities.isEmpty()) {
                    iter = oldEntities.entrySet().iterator();
                    while (iter.hasNext()) {
                        entry = iter.next();
                        Entity entity = (Entity)entry.getValue();
                        chunk.addEntity(entity);
                        if (oldChunk == null) continue;
                        iter.remove();
                        oldChunk.removeEntity(entity);
                        entity.chunk = chunk;
                    }
                }
                if (!oldBlockEntities.isEmpty()) {
                    iter = oldBlockEntities.entrySet().iterator();
                    while (iter.hasNext()) {
                        entry = iter.next();
                        BlockEntity blockEntity = (BlockEntity)entry.getValue();
                        chunk.addBlockEntity(blockEntity);
                        if (oldChunk == null) continue;
                        iter.remove();
                        oldChunk.removeBlockEntity(blockEntity);
                        blockEntity.chunk = chunk;
                    }
                }
                this.provider.setChunk(chunkX, chunkZ, chunk);
            }
        }
        chunk.setChanged();
        if (!this.isChunkInUse(index)) {
            this.unloadChunkRequest(chunkX, chunkZ);
        } else {
            for (ChunkLoader loader : this.getChunkLoaders(chunkX, chunkZ)) {
                loader.onChunkChanged(chunk);
            }
        }
    }

    public int getHighestBlockAt(int x, int z) {
        return this.getChunk(x >> 4, z >> 4, true).getHighestBlockAt(x & 0xF, z & 0xF);
    }

    public BlockColor getMapColorAt(int x, int z) {
        for (int y = this.getHighestBlockAt(x, z); y > 1; --y) {
            Block block = this.getBlock(new Vector3(x, y, z));
            BlockColor blockColor = block.getColor();
            if (blockColor.getAlpha() == 0) {
                continue;
            }
            return blockColor;
        }
        return BlockColor.VOID_BLOCK_COLOR;
    }

    public boolean isChunkLoaded(int x, int z) {
        return this.provider.isChunkLoaded(x, z);
    }

    private boolean areNeighboringChunksLoaded(long hash) {
        return this.provider.isChunkLoaded(hash + 1L) && this.provider.isChunkLoaded(hash - 1L) && this.provider.isChunkLoaded(hash + 0x100000000L) && this.provider.isChunkLoaded(hash - 0x100000000L);
    }

    public boolean isChunkGenerated(int x, int z) {
        BaseFullChunk chunk = this.getChunk(x, z);
        return chunk != null && chunk.isGenerated();
    }

    public boolean isChunkPopulated(int x, int z) {
        BaseFullChunk chunk = this.getChunk(x, z);
        return chunk != null && chunk.isPopulated();
    }

    public Position getSpawnLocation() {
        return Position.fromObject(this.provider.getSpawn(), this);
    }

    public Position getFuzzySpawnLocation() {
        Position spawn = this.getSpawnLocation();
        int radius = this.gameRules.getInteger(GameRule.SPAWN_RADIUS);
        if (radius > 0) {
            ThreadLocalRandom random = ThreadLocalRandom.current();
            int negativeFlags = random.nextInt(4);
            spawn = spawn.add((double)radius * random.nextDouble() * (double)((negativeFlags & 1) > 0 ? -1 : 1), 0.0, (double)radius * random.nextDouble() * (double)((negativeFlags & 2) > 0 ? -1 : 1));
        }
        return spawn;
    }

    public void setSpawnLocation(Vector3 pos) {
        Position previousSpawn = this.getSpawnLocation();
        this.provider.setSpawn(pos);
        this.server.getPluginManager().callEvent(new SpawnChangeEvent(this, previousSpawn));
        SetSpawnPositionPacket pk = new SetSpawnPositionPacket();
        pk.spawnType = 1;
        pk.x = pos.getFloorX();
        pk.y = pos.getFloorY();
        pk.z = pos.getFloorZ();
        pk.dimension = this.getDimension();
        for (Player p : this.getPlayers().values()) {
            p.dataPacket(pk);
        }
    }

    public void requestChunk(int x, int z, Player player) {
        Preconditions.checkState((player.getLoaderId() > 0 ? 1 : 0) != 0, (Object)(player.getName() + " has no chunk loader"));
        long index = Level.chunkHash(x, z);
        this.chunkSendQueue.putIfAbsent(index, (Int2ObjectMap<Player>)new Int2ObjectOpenHashMap());
        ((Int2ObjectMap)this.chunkSendQueue.get(index)).put(player.getLoaderId(), (Object)player);
    }

    private void sendChunk(int x, int z, long index, DataPacket packet) {
        if (this.chunkSendTasks.contains(index)) {
            for (Player player : ((Int2ObjectMap)this.chunkSendQueue.get(index)).values()) {
                if (!player.isConnected() || !player.usedChunks.containsKey(index)) continue;
                player.sendChunk(x, z, packet);
            }
            this.chunkSendQueue.remove(index);
            this.chunkSendTasks.remove(index);
        }
    }

    private void processChunkRequest() {
        this.timings.syncChunkSendTimer.startTiming();
        Iterator iterator = this.chunkSendQueue.keySet().iterator();
        while (iterator.hasNext()) {
            BatchPacket packet;
            long index = (Long)iterator.next();
            if (this.chunkSendTasks.contains(index)) continue;
            int x = Level.getHashX(index);
            int z = Level.getHashZ(index);
            this.chunkSendTasks.add(index);
            BaseFullChunk chunk = this.getChunk(x, z);
            if (chunk != null && (packet = chunk.getChunkPacket()) != null) {
                this.sendChunk(x, z, index, packet);
                continue;
            }
            this.timings.syncChunkSendPrepareTimer.startTiming();
            AsyncTask task = this.provider.requestChunkTask(x, z);
            if (task != null) {
                this.server.getScheduler().scheduleAsyncTask(task);
            }
            this.timings.syncChunkSendPrepareTimer.stopTiming();
        }
        this.timings.syncChunkSendTimer.stopTiming();
    }

    public void chunkRequestCallback(long timestamp, int x, int z, int subChunkCount, byte[] payload) {
        this.timings.syncChunkSendTimer.startTiming();
        long index = Level.chunkHash(x, z);
        if (this.cacheChunks) {
            BatchPacket data = Player.getChunkCacheFromData(x, z, subChunkCount, payload);
            BaseFullChunk chunk = this.getChunk(x, z, false);
            if (chunk != null && chunk.getChanges() <= timestamp) {
                chunk.setChunkPacket(data);
            }
            this.sendChunk(x, z, index, data);
            this.timings.syncChunkSendTimer.stopTiming();
            return;
        }
        if (this.chunkSendTasks.contains(index)) {
            for (Player player : ((Int2ObjectMap)this.chunkSendQueue.get(index)).values()) {
                if (!player.isConnected() || !player.usedChunks.containsKey(index)) continue;
                player.sendChunk(x, z, subChunkCount, payload);
            }
            this.chunkSendQueue.remove(index);
            this.chunkSendTasks.remove(index);
        }
        this.timings.syncChunkSendTimer.stopTiming();
    }

    public void removeEntity(Entity entity) {
        if (entity.getLevel() != this) {
            throw new LevelException("Invalid Entity level");
        }
        if (entity instanceof Player) {
            this.players.remove(entity.getId());
            this.checkSleep();
        } else {
            entity.close();
        }
        this.entities.remove(entity.getId());
        this.updateEntities.remove(entity.getId());
    }

    public void addEntity(Entity entity) {
        if (entity.getLevel() != this) {
            throw new LevelException("Invalid Entity level");
        }
        if (entity instanceof Player) {
            this.players.put(entity.getId(), (Object)((Player)entity));
        }
        this.entities.put(entity.getId(), (Object)entity);
    }

    public void addBlockEntity(BlockEntity blockEntity) {
        if (blockEntity.getLevel() != this) {
            throw new LevelException("Invalid Block Entity level");
        }
        this.blockEntities.put(blockEntity.getId(), (Object)blockEntity);
    }

    public void scheduleBlockEntityUpdate(BlockEntity entity) {
        Preconditions.checkNotNull((Object)entity, (Object)"entity");
        Preconditions.checkArgument((entity.getLevel() == this ? 1 : 0) != 0, (Object)"BlockEntity is not in this level");
        if (!this.updateBlockEntities.contains(entity)) {
            this.updateBlockEntities.add(entity);
        }
    }

    public void removeBlockEntity(BlockEntity entity) {
        Preconditions.checkNotNull((Object)entity, (Object)"entity");
        Preconditions.checkArgument((entity.getLevel() == this ? 1 : 0) != 0, (Object)"BlockEntity is not in this level");
        this.blockEntities.remove(entity.getId());
        this.updateBlockEntities.remove(entity);
    }

    public boolean isChunkInUse(int x, int z) {
        return this.isChunkInUse(Level.chunkHash(x, z));
    }

    public boolean isChunkInUse(long hash) {
        return this.chunkLoaders.containsKey(hash) && !((Map)this.chunkLoaders.get(hash)).isEmpty();
    }

    public boolean loadChunk(int x, int z) {
        return this.loadChunk(x, z, true);
    }

    public boolean loadChunk(int x, int z, boolean generate) {
        long index = Level.chunkHash(x, z);
        if (this.provider.isChunkLoaded(index)) {
            return true;
        }
        return this.forceLoadChunk(index, x, z, generate) != null;
    }

    private synchronized BaseFullChunk forceLoadChunk(long index, int x, int z, boolean generate) {
        this.timings.syncChunkLoadTimer.startTiming();
        BaseFullChunk chunk = this.provider.getChunk(x, z, generate);
        if (chunk == null) {
            if (generate) {
                throw new IllegalStateException("Could not create new Chunk");
            }
            this.timings.syncChunkLoadTimer.stopTiming();
            return chunk;
        }
        if (chunk.getProvider() == null) {
            this.unloadChunk(x, z, false);
            this.timings.syncChunkLoadTimer.stopTiming();
            return chunk;
        }
        this.server.getPluginManager().callEvent(new ChunkLoadEvent(chunk, !chunk.isGenerated()));
        chunk.backwardCompatibilityUpdate(this);
        chunk.initChunk();
        if (!chunk.isLightPopulated() && chunk.isPopulated() && this.getServer().getConfig("chunk-ticking.light-updates", false).booleanValue()) {
            this.getServer().getScheduler().scheduleAsyncTask(new LightPopulationTask(this, chunk));
        }
        if (this.isChunkInUse(index)) {
            this.unloadQueue.remove(index);
            for (ChunkLoader loader : this.getChunkLoaders(x, z)) {
                loader.onChunkLoaded(chunk);
            }
        } else {
            this.unloadQueue.put(index, System.currentTimeMillis());
        }
        this.timings.syncChunkLoadTimer.stopTiming();
        return chunk;
    }

    private void queueUnloadChunk(int x, int z) {
        long index = Level.chunkHash(x, z);
        this.unloadQueue.put(index, System.currentTimeMillis());
    }

    public boolean unloadChunkRequest(int x, int z) {
        return this.unloadChunkRequest(x, z, true);
    }

    public boolean unloadChunkRequest(int x, int z, boolean safe) {
        if (safe && this.isChunkInUse(x, z) || this.isSpawnChunk(x, z)) {
            return false;
        }
        this.queueUnloadChunk(x, z);
        return true;
    }

    public void cancelUnloadChunkRequest(int x, int z) {
        this.cancelUnloadChunkRequest(Level.chunkHash(x, z));
    }

    public void cancelUnloadChunkRequest(long hash) {
        this.unloadQueue.remove(hash);
    }

    public boolean unloadChunk(int x, int z) {
        return this.unloadChunk(x, z, true);
    }

    public boolean unloadChunk(int x, int z, boolean safe) {
        return this.unloadChunk(x, z, safe, true);
    }

    public synchronized boolean unloadChunk(int x, int z, boolean safe, boolean trySave) {
        if (safe && this.isChunkInUse(x, z)) {
            return false;
        }
        if (!this.isChunkLoaded(x, z)) {
            return true;
        }
        this.timings.doChunkUnload.startTiming();
        BaseFullChunk chunk = this.getChunk(x, z);
        if (chunk != null && chunk.getProvider() != null) {
            ChunkUnloadEvent ev = new ChunkUnloadEvent(chunk);
            this.server.getPluginManager().callEvent(ev);
            if (ev.isCancelled()) {
                this.timings.doChunkUnload.stopTiming();
                return false;
            }
        }
        try {
            if (chunk != null) {
                if (trySave && this.getAutoSave()) {
                    int entities = 0;
                    for (Entity e : chunk.getEntities().values()) {
                        if (e instanceof Player) continue;
                        ++entities;
                    }
                    if (chunk.hasChanged() || !chunk.getBlockEntities().isEmpty() || entities > 0) {
                        this.provider.setChunk(x, z, chunk);
                        this.provider.saveChunk(x, z);
                    }
                }
                for (ChunkLoader loader : this.getChunkLoaders(x, z)) {
                    loader.onChunkUnloaded(chunk);
                }
            }
            this.provider.unloadChunk(x, z, safe);
        }
        catch (Exception e) {
            MainLogger logger = this.server.getLogger();
            logger.error(this.server.getLanguage().translateString("nukkit.level.chunkUnloadError", e.toString()));
            logger.logException(e);
        }
        this.timings.doChunkUnload.stopTiming();
        return true;
    }

    public boolean isSpawnChunk(int X, int Z) {
        Vector3 spawn = this.provider.getSpawn();
        return Math.abs(X - (spawn.getFloorX() >> 4)) <= 1 && Math.abs(Z - (spawn.getFloorZ() >> 4)) <= 1;
    }

    public Position getSafeSpawn() {
        return this.getSafeSpawn(null);
    }

    public Position getSafeSpawn(Vector3 spawn) {
        if (spawn == null || spawn.y < 1.0) {
            spawn = this.getFuzzySpawnLocation();
        }
        if (spawn != null) {
            Vector3 v = spawn.floor();
            BaseFullChunk chunk = this.getChunk((int)v.x >> 4, (int)v.z >> 4, false);
            int x = (int)v.x & 0xF;
            int z = (int)v.z & 0xF;
            if (chunk != null && chunk.isGenerated()) {
                Block block;
                int[] b;
                boolean wasAir;
                int y = (int)NukkitMath.clamp(v.y, 1.0, 254.0);
                boolean bl = wasAir = chunk.getBlockId(x, y - 1, z) == 0;
                while (y > 0) {
                    b = chunk.getBlockState(x, y, z);
                    block = Block.get(b[0], b[1]);
                    if (this.isFullBlock(block)) {
                        if (wasAir) {
                            ++y;
                            break;
                        }
                    } else {
                        wasAir = true;
                    }
                    --y;
                }
                while (y >= 0 && y < 255) {
                    b = chunk.getBlockState(x, y + 1, z);
                    block = Block.get(b[0], b[1]);
                    if (!this.isFullBlock(block)) {
                        b = chunk.getBlockState(x, y, z);
                        block = Block.get(b[0], b[1]);
                        if (!this.isFullBlock(block)) {
                            return new Position(spawn.x, y == (int)spawn.y ? spawn.y : (double)y, spawn.z, this);
                        }
                    } else {
                        ++y;
                    }
                    ++y;
                }
                v.y = y;
            }
            return new Position(spawn.x, v.y, spawn.z, this);
        }
        return null;
    }

    public int getTime() {
        return (int)this.time;
    }

    public boolean isDaytime() {
        return this.skyLightSubtracted < 4.0f;
    }

    public long getCurrentTick() {
        return this.levelCurrentTick;
    }

    public String getName() {
        return this.provider.getName();
    }

    public String getFolderName() {
        return this.folderName;
    }

    public void setTime(int time) {
        this.time = time;
        this.sendTime();
    }

    public void stopTime() {
        this.stopTime = true;
        this.sendTime();
    }

    public void startTime() {
        this.stopTime = false;
        this.sendTime();
    }

    @Override
    public long getSeed() {
        return this.provider.getSeed();
    }

    public void setSeed(int seed) {
        this.provider.setSeed(seed);
    }

    public boolean populateChunk(int x, int z) {
        return this.populateChunk(x, z, false);
    }

    public boolean populateChunk(int x, int z, boolean force) {
        long index = Level.chunkHash(x, z);
        if (this.chunkPopulationQueue.containsKey(index) || this.chunkPopulationQueue.size() >= this.chunkPopulationQueueSize && !force) {
            return false;
        }
        BaseFullChunk chunk = this.getChunk(x, z, true);
        if (!chunk.isPopulated()) {
            int zz;
            int xx;
            Timings.populationTimer.startTiming();
            boolean populate = true;
            block0: for (xx = -1; xx <= 1; ++xx) {
                for (zz = -1; zz <= 1; ++zz) {
                    if (!this.chunkPopulationLock.containsKey(Level.chunkHash(x + xx, z + zz))) continue;
                    populate = false;
                    continue block0;
                }
            }
            if (populate && !this.chunkPopulationQueue.containsKey(index)) {
                this.chunkPopulationQueue.put(index, (Object)Boolean.TRUE);
                for (xx = -1; xx <= 1; ++xx) {
                    for (zz = -1; zz <= 1; ++zz) {
                        this.chunkPopulationLock.put(Level.chunkHash(x + xx, z + zz), (Object)Boolean.TRUE);
                    }
                }
                PopulationTask task = new PopulationTask(this, chunk);
                this.server.getScheduler().scheduleAsyncTask(task);
            }
            Timings.populationTimer.stopTiming();
            return false;
        }
        return true;
    }

    public void generateChunk(int x, int z) {
        this.generateChunk(x, z, false);
    }

    public void generateChunk(int x, int z, boolean force) {
        if (this.chunkGenerationQueue.size() >= this.chunkGenerationQueueSize && !force) {
            return;
        }
        long index = Level.chunkHash(x, z);
        if (!this.chunkGenerationQueue.containsKey(index)) {
            Timings.generationTimer.startTiming();
            this.chunkGenerationQueue.put(index, (Object)Boolean.TRUE);
            GenerationTask task = new GenerationTask(this, this.getChunk(x, z, true));
            this.server.getScheduler().scheduleAsyncTask(task);
            Timings.generationTimer.stopTiming();
        }
    }

    public void regenerateChunk(int x, int z) {
        this.unloadChunk(x, z, false);
        this.cancelUnloadChunkRequest(x, z);
        BaseFullChunk chunk = this.provider.getEmptyChunk(x, z);
        this.provider.setChunk(x, z, chunk);
        this.generateChunk(x, z);
    }

    public void doChunkGarbageCollection() {
        this.timings.doChunkGC.startTiming();
        if (!this.blockEntities.isEmpty()) {
            ObjectIterator iter = this.blockEntities.values().iterator();
            while (iter.hasNext()) {
                BlockEntity blockEntity = (BlockEntity)iter.next();
                if (blockEntity != null) {
                    if (blockEntity.isValid()) continue;
                    iter.remove();
                    blockEntity.close();
                    continue;
                }
                iter.remove();
            }
        }
        for (Map.Entry<Long, ? extends FullChunk> entry : this.provider.getLoadedChunks().entrySet()) {
            int Z;
            FullChunk chunk;
            int X;
            long index = entry.getKey();
            if (this.unloadQueue.containsKey(index) || this.isSpawnChunk(X = (chunk = entry.getValue()).getX(), Z = chunk.getZ())) continue;
            this.unloadChunkRequest(X, Z, true);
        }
        this.provider.doGarbageCollection();
        this.timings.doChunkGC.stopTiming();
    }

    public void doGarbageCollection(long allocatedTime) {
        long start = System.currentTimeMillis();
        if (this.unloadChunks(start, allocatedTime, false)) {
            this.provider.doGarbageCollection(allocatedTime -= System.currentTimeMillis() - start);
        }
    }

    public void unloadChunks() {
        this.unloadChunks(false);
    }

    public void unloadChunks(boolean force) {
        this.unloadChunks(96, force);
    }

    public void unloadChunks(int maxUnload, boolean force) {
        if (!this.unloadQueue.isEmpty()) {
            long index;
            long now = System.currentTimeMillis();
            LongArrayList toRemove = null;
            for (Long2LongMap.Entry entry : this.unloadQueue.long2LongEntrySet()) {
                index = entry.getLongKey();
                if (this.isChunkInUse(index)) continue;
                if (!force) {
                    long time = entry.getLongValue();
                    if (maxUnload <= 0) break;
                    if (time > now - 30000L) continue;
                }
                if (toRemove == null) {
                    toRemove = new LongArrayList();
                }
                toRemove.add(index);
            }
            if (toRemove != null) {
                int size = toRemove.size();
                for (int i = 0; i < size; ++i) {
                    int Z;
                    index = toRemove.getLong(i);
                    int X = Level.getHashX(index);
                    if (!this.unloadChunk(X, Z = Level.getHashZ(index), true)) continue;
                    this.unloadQueue.remove(index);
                    --maxUnload;
                }
            }
        }
    }

    private boolean unloadChunks(long now, long allocatedTime, boolean force) {
        if (!this.unloadQueue.isEmpty()) {
            boolean result = true;
            int maxIterations = this.unloadQueue.size();
            if (this.lastUnloadIndex > maxIterations) {
                this.lastUnloadIndex = 0;
            }
            ObjectIterator iter = this.unloadQueue.long2LongEntrySet().iterator();
            if (this.lastUnloadIndex != 0) {
                iter.skip(this.lastUnloadIndex);
            }
            LongArrayList toUnload = null;
            for (int i = 0; i < maxIterations; ++i) {
                long time;
                Long2LongMap.Entry entry;
                long index;
                if (!iter.hasNext()) {
                    iter = this.unloadQueue.long2LongEntrySet().iterator();
                }
                if (this.isChunkInUse(index = (entry = (Long2LongMap.Entry)iter.next()).getLongKey()) || !force && (time = entry.getLongValue()) > now - 30000L) continue;
                if (toUnload == null) {
                    toUnload = new LongArrayList();
                }
                toUnload.add(index);
            }
            if (toUnload != null) {
                long[] arr;
                for (long index : arr = toUnload.toLongArray()) {
                    int Z;
                    int X = Level.getHashX(index);
                    if (!this.unloadChunk(X, Z = Level.getHashZ(index), true)) continue;
                    this.unloadQueue.remove(index);
                    if (System.currentTimeMillis() - now < allocatedTime) continue;
                    result = false;
                    break;
                }
            }
            return result;
        }
        return true;
    }

    @Override
    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) throws Exception {
        this.server.getLevelMetadata().setMetadata(this, metadataKey, newMetadataValue);
    }

    @Override
    public List<MetadataValue> getMetadata(String metadataKey) throws Exception {
        return this.server.getLevelMetadata().getMetadata(this, metadataKey);
    }

    @Override
    public boolean hasMetadata(String metadataKey) throws Exception {
        return this.server.getLevelMetadata().hasMetadata(this, metadataKey);
    }

    @Override
    public void removeMetadata(String metadataKey, Plugin owningPlugin) throws Exception {
        this.server.getLevelMetadata().removeMetadata(this, metadataKey, owningPlugin);
    }

    public void addPlayerMovement(Entity entity, double x, double y, double z, double yaw, double pitch, double headYaw) {
        MovePlayerPacket pk = new MovePlayerPacket();
        pk.eid = entity.getId();
        pk.x = (float)x;
        pk.y = (float)y;
        pk.z = (float)z;
        pk.yaw = (float)yaw;
        pk.headYaw = (float)headYaw;
        pk.pitch = (float)pitch;
        Server.broadcastPacket(entity.getViewers().values(), (DataPacket)pk);
    }

    public void addEntityMovement(Entity entity, double x, double y, double z, double yaw, double pitch, double headYaw) {
        MoveEntityAbsolutePacket pk = new MoveEntityAbsolutePacket();
        pk.eid = entity.getId();
        pk.x = (float)x;
        pk.y = (float)y;
        pk.z = (float)z;
        pk.yaw = (float)yaw;
        pk.headYaw = (float)headYaw;
        pk.pitch = (float)pitch;
        pk.onGround = entity.onGround;
        Server.broadcastPacket(entity.getViewers().values(), (DataPacket)pk);
    }

    public boolean isRaining() {
        return this.raining;
    }

    public boolean setRaining(boolean raining) {
        WeatherChangeEvent ev = new WeatherChangeEvent(this, raining);
        this.getServer().getPluginManager().callEvent(ev);
        if (ev.isCancelled()) {
            return false;
        }
        this.raining = raining;
        LevelEventPacket pk = new LevelEventPacket();
        if (raining) {
            int time;
            pk.evid = 3001;
            pk.data = time = ThreadLocalRandom.current().nextInt(12000) + 12000;
            this.setRainTime(time);
        } else {
            pk.evid = 3003;
            this.setRainTime(ThreadLocalRandom.current().nextInt(168000) + 12000);
        }
        Server.broadcastPacket(this.getPlayers().values(), (DataPacket)pk);
        return true;
    }

    public int getRainTime() {
        return this.rainTime;
    }

    public void setRainTime(int rainTime) {
        this.rainTime = rainTime;
    }

    public boolean isThundering() {
        return this.isRaining() && this.thundering;
    }

    public boolean setThundering(boolean thundering) {
        ThunderChangeEvent ev = new ThunderChangeEvent(this, thundering);
        this.getServer().getPluginManager().callEvent(ev);
        if (ev.isCancelled()) {
            return false;
        }
        if (thundering && !this.isRaining()) {
            this.setRaining(true);
        }
        this.thundering = thundering;
        LevelEventPacket pk = new LevelEventPacket();
        if (thundering) {
            int time;
            pk.evid = 3002;
            pk.data = time = ThreadLocalRandom.current().nextInt(12000) + 3600;
            this.setThunderTime(time);
        } else {
            pk.evid = 3004;
            this.setThunderTime(ThreadLocalRandom.current().nextInt(168000) + 12000);
        }
        Server.broadcastPacket(this.getPlayers().values(), (DataPacket)pk);
        return true;
    }

    public int getThunderTime() {
        return this.thunderTime;
    }

    public void setThunderTime(int thunderTime) {
        this.thunderTime = thunderTime;
    }

    public void sendWeather(Player[] players) {
        if (players == null) {
            players = this.getPlayers().values().toArray(new Player[0]);
        }
        LevelEventPacket pk = new LevelEventPacket();
        if (this.isRaining()) {
            pk.evid = 3001;
            pk.data = this.rainTime;
        } else {
            pk.evid = 3003;
        }
        Server.broadcastPacket(players, (DataPacket)pk);
        if (this.isThundering()) {
            pk.evid = 3002;
            pk.data = this.thunderTime;
        } else {
            pk.evid = 3004;
        }
        Server.broadcastPacket(players, (DataPacket)pk);
    }

    public void sendWeather(Player player) {
        if (player != null) {
            this.sendWeather(new Player[]{player});
        }
    }

    public void sendWeather(Collection<Player> players) {
        if (players == null) {
            players = this.getPlayers().values();
        }
        this.sendWeather(players.toArray(new Player[0]));
    }

    public int getDimension() {
        return this.dimension;
    }

    public boolean canBlockSeeSky(Vector3 pos) {
        return (double)this.getHighestBlockAt(pos.getFloorX(), pos.getFloorZ()) < pos.getY();
    }

    public int getStrongPower(Vector3 pos, BlockFace direction) {
        return this.getBlock(pos).getStrongPower(direction);
    }

    public int getStrongPower(Vector3 pos) {
        int i = 0;
        for (BlockFace face : BlockFace.values()) {
            if ((i = Math.max(i, this.getStrongPower(pos.getSide(face), face))) < 15) continue;
            return i;
        }
        return i;
    }

    public boolean isSidePowered(Vector3 pos, BlockFace face) {
        return this.getRedstonePower(pos, face) > 0;
    }

    public int getRedstonePower(Vector3 pos, BlockFace face) {
        Block block;
        if (pos instanceof Block) {
            block = (Block)pos;
            pos = pos.add(0.0);
        } else {
            block = this.getBlock(pos);
        }
        return block.isNormalBlock() ? this.getStrongPower(pos) : block.getWeakPower(face);
    }

    public boolean isBlockPowered(Vector3 pos) {
        for (BlockFace face : BlockFace.values()) {
            if (this.getRedstonePower(pos.getSide(face), face) <= 0) continue;
            return true;
        }
        return false;
    }

    public int isBlockIndirectlyGettingPowered(Vector3 pos) {
        int power = 0;
        for (BlockFace face : BlockFace.values()) {
            int blockPower = this.getRedstonePower(pos.getSide(face), face);
            if (blockPower >= 15) {
                return 15;
            }
            if (blockPower <= power) continue;
            power = blockPower;
        }
        return power;
    }

    public boolean isAreaLoaded(AxisAlignedBB bb) {
        if (bb.getMaxY() < 0.0 || bb.getMinY() >= 256.0) {
            return false;
        }
        int minX = NukkitMath.floorDouble(bb.getMinX()) >> 4;
        int minZ = NukkitMath.floorDouble(bb.getMinZ()) >> 4;
        int maxX = NukkitMath.floorDouble(bb.getMaxX()) >> 4;
        int maxZ = NukkitMath.floorDouble(bb.getMaxZ()) >> 4;
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                if (this.isChunkLoaded(x, z)) continue;
                return false;
            }
        }
        return true;
    }

    public int getUpdateLCG() {
        this.updateLCG = this.updateLCG * 3 ^ 0x3C6EF35F;
        return this.updateLCG;
    }

    public boolean createPortal(Block target) {
        int i;
        int maxPortalSize = 23;
        int targX = target.getFloorX();
        int targY = target.getFloorY();
        int targZ = target.getFloorZ();
        for (int i2 = 1; i2 < 4; ++i2) {
            if (this.getBlockIdAt(targX, targY + i2, targZ) == 0) continue;
            return false;
        }
        int sizePosX = 0;
        int sizeNegX = 0;
        int sizePosZ = 0;
        int sizeNegZ = 0;
        for (i = 1; i < maxPortalSize && this.getBlockIdAt(targX + i, targY, targZ) == 49; ++i) {
            ++sizePosX;
        }
        for (i = 1; i < maxPortalSize && this.getBlockIdAt(targX - i, targY, targZ) == 49; ++i) {
            ++sizeNegX;
        }
        for (i = 1; i < maxPortalSize && this.getBlockIdAt(targX, targY, targZ + i) == 49; ++i) {
            ++sizePosZ;
        }
        for (i = 1; i < maxPortalSize && this.getBlockIdAt(targX, targY, targZ - i) == 49; ++i) {
            ++sizeNegZ;
        }
        int sizeX = sizePosX + sizeNegX + 1;
        int sizeZ = sizePosZ + sizeNegZ + 1;
        if (sizeX >= 2 && sizeX <= maxPortalSize) {
            int width;
            int height;
            int scanX = targX;
            int scanY = targY + 1;
            int scanZ = targZ;
            for (int i3 = 0; i3 < sizePosX + 1; ++i3) {
                if (this.getBlockIdAt(scanX + i3, scanY, scanZ) != 0) {
                    return false;
                }
                if (this.getBlockIdAt(scanX + i3 + 1, scanY, scanZ) != 49) continue;
                scanX += i3;
                break;
            }
            if (this.getBlockIdAt(scanX + 1, scanY, scanZ) != 49) {
                return false;
            }
            int innerWidth = 0;
            block22: for (int i4 = 0; i4 < maxPortalSize - 2; ++i4) {
                int id = this.getBlockIdAt(scanX - i4, scanY, scanZ);
                switch (id) {
                    case 0: {
                        ++innerWidth;
                        continue block22;
                    }
                    case 49: {
                        break block22;
                    }
                    default: {
                        return false;
                    }
                }
            }
            int innerHeight = 0;
            block23: for (int i5 = 0; i5 < maxPortalSize - 2; ++i5) {
                int id = this.getBlockIdAt(scanX, scanY + i5, scanZ);
                switch (id) {
                    case 0: {
                        ++innerHeight;
                        continue block23;
                    }
                    case 49: {
                        break block23;
                    }
                    default: {
                        return false;
                    }
                }
            }
            if (innerWidth > maxPortalSize - 2 || innerWidth < 2 || innerHeight > maxPortalSize - 2 || innerHeight < 3) {
                return false;
            }
            for (height = 0; height < innerHeight + 1; ++height) {
                if (height == innerHeight) {
                    for (width = 0; width < innerWidth; ++width) {
                        if (this.getBlockIdAt(scanX - width, scanY + height, scanZ) == 49) continue;
                        return false;
                    }
                    continue;
                }
                if (this.getBlockIdAt(scanX + 1, scanY + height, scanZ) != 49 || this.getBlockIdAt(scanX - innerWidth, scanY + height, scanZ) != 49) {
                    return false;
                }
                for (width = 0; width < innerWidth; ++width) {
                    if (this.getBlockIdAt(scanX - width, scanY + height, scanZ) == 0) continue;
                    return false;
                }
            }
            for (height = 0; height < innerHeight; ++height) {
                for (width = 0; width < innerWidth; ++width) {
                    this.setBlock(new Vector3(scanX - width, scanY + height, scanZ), Block.get(90));
                }
            }
            this.addLevelSoundEvent(target, 50);
            return true;
        }
        if (sizeZ >= 2 && sizeZ <= maxPortalSize) {
            int width;
            int height;
            int scanX = targX;
            int scanY = targY + 1;
            int scanZ = targZ;
            for (int i6 = 0; i6 < sizePosZ + 1; ++i6) {
                if (this.getBlockIdAt(scanX, scanY, scanZ + i6) != 0) {
                    return false;
                }
                if (this.getBlockIdAt(scanX, scanY, scanZ + i6 + 1) != 49) continue;
                scanZ += i6;
                break;
            }
            if (this.getBlockIdAt(scanX, scanY, scanZ + 1) != 49) {
                return false;
            }
            int innerWidth = 0;
            block30: for (int i7 = 0; i7 < maxPortalSize - 2; ++i7) {
                int id = this.getBlockIdAt(scanX, scanY, scanZ - i7);
                switch (id) {
                    case 0: {
                        ++innerWidth;
                        continue block30;
                    }
                    case 49: {
                        break block30;
                    }
                    default: {
                        return false;
                    }
                }
            }
            int innerHeight = 0;
            block31: for (int i8 = 0; i8 < maxPortalSize - 2; ++i8) {
                int id = this.getBlockIdAt(scanX, scanY + i8, scanZ);
                switch (id) {
                    case 0: {
                        ++innerHeight;
                        continue block31;
                    }
                    case 49: {
                        break block31;
                    }
                    default: {
                        return false;
                    }
                }
            }
            if (innerWidth > maxPortalSize - 2 || innerWidth < 2 || innerHeight > maxPortalSize - 2 || innerHeight < 3) {
                return false;
            }
            for (height = 0; height < innerHeight + 1; ++height) {
                if (height == innerHeight) {
                    for (width = 0; width < innerWidth; ++width) {
                        if (this.getBlockIdAt(scanX, scanY + height, scanZ - width) == 49) continue;
                        return false;
                    }
                    continue;
                }
                if (this.getBlockIdAt(scanX, scanY + height, scanZ + 1) != 49 || this.getBlockIdAt(scanX, scanY + height, scanZ - innerWidth) != 49) {
                    return false;
                }
                for (width = 0; width < innerWidth; ++width) {
                    if (this.getBlockIdAt(scanX, scanY + height, scanZ - width) == 0) continue;
                    return false;
                }
            }
            for (height = 0; height < innerHeight; ++height) {
                for (width = 0; width < innerWidth; ++width) {
                    this.setBlock(new Vector3(scanX, scanY + height, scanZ - width), Block.get(90));
                }
            }
            this.addLevelSoundEvent(target, 50);
            return true;
        }
        return false;
    }

    static {
        Level.randomTickBlocks[2] = true;
        Level.randomTickBlocks[60] = true;
        Level.randomTickBlocks[110] = true;
        Level.randomTickBlocks[6] = true;
        Level.randomTickBlocks[18] = true;
        Level.randomTickBlocks[161] = true;
        Level.randomTickBlocks[78] = true;
        Level.randomTickBlocks[79] = true;
        Level.randomTickBlocks[10] = true;
        Level.randomTickBlocks[11] = true;
        Level.randomTickBlocks[81] = true;
        Level.randomTickBlocks[244] = true;
        Level.randomTickBlocks[141] = true;
        Level.randomTickBlocks[142] = true;
        Level.randomTickBlocks[105] = true;
        Level.randomTickBlocks[104] = true;
        Level.randomTickBlocks[59] = true;
        Level.randomTickBlocks[83] = true;
        Level.randomTickBlocks[40] = true;
        Level.randomTickBlocks[39] = true;
        Level.randomTickBlocks[115] = true;
        Level.randomTickBlocks[51] = true;
        Level.randomTickBlocks[74] = true;
        Level.randomTickBlocks[127] = true;
        Level.randomTickBlocks[106] = true;
        Level.randomTickBlocks[388] = true;
        Level.randomTickBlocks[389] = true;
        Level.randomTickBlocks[393] = true;
        Level.randomTickBlocks[462] = true;
        Level.randomTickBlocks[414] = true;
        Level.randomTickBlocks[418] = true;
        Level.randomTickBlocks[419] = true;
        EMPTY_ENTITY_ARR = new Entity[0];
        ENTITY_BUFFER = new Entity[512];
    }
}

