/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level;

import cn.nukkit.level.Level;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.level.format.LevelProvider;
import cn.nukkit.level.format.anvil.Anvil;
import cn.nukkit.level.format.generic.ChunkConverter;
import cn.nukkit.level.format.leveldb.Chunk;
import cn.nukkit.level.format.leveldb.LevelDB;
import cn.nukkit.level.format.mcregion.McRegion;
import cn.nukkit.level.format.mcregion.RegionLoader;
import cn.nukkit.nbt.NBTIO;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.utils.LevelException;
import cn.nukkit.utils.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class LevelProviderConverter {
    private LevelProvider provider;
    private Class<? extends LevelProvider> toClass;
    private Level level;
    private String path;

    LevelProviderConverter(Level level, String path) {
        this.level = level;
        this.path = path;
    }

    LevelProviderConverter from(LevelProvider provider) {
        if (!(provider instanceof McRegion) && !(provider instanceof LevelDB)) {
            throw new IllegalArgumentException("From type can be only McRegion or LevelDB");
        }
        this.provider = provider;
        return this;
    }

    LevelProviderConverter to(Class<? extends LevelProvider> toClass) {
        if (toClass != Anvil.class) {
            throw new IllegalArgumentException("To type can be only Anvil");
        }
        this.toClass = toClass;
        return this;
    }

    LevelProvider perform() throws IOException {
        LevelProvider result;
        new File(this.path).mkdir();
        File dat = new File(this.provider.getPath(), "level.dat.old");
        new File(this.provider.getPath(), "level.dat").renameTo(dat);
        Utils.copyFile(dat, new File(this.path, "level.dat"));
        try {
            block26: {
                if (this.provider instanceof LevelDB) {
                    try (FileInputStream fileInputStream = new FileInputStream(this.path + "level.dat");){
                        fileInputStream.skip(8L);
                        CompoundTag levelData = NBTIO.read(fileInputStream, ByteOrder.LITTLE_ENDIAN);
                        if (levelData != null) {
                            NBTIO.writeGZIPCompressed(new CompoundTag().putCompound("Data", levelData), new FileOutputStream(this.path + "level.dat"));
                            break block26;
                        }
                        throw new IOException("LevelData can not be null");
                    }
                    catch (IOException iOException) {
                        throw new LevelException("Invalid level.dat");
                    }
                }
            }
            result = this.toClass.getConstructor(Level.class, String.class).newInstance(this.level, this.path);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (this.toClass == Anvil.class) {
            if (this.provider instanceof McRegion) {
                new File(this.path, "region").mkdir();
                for (File file : new File(this.provider.getPath() + "region/").listFiles()) {
                    int regionZ;
                    int regionX;
                    Matcher m = Pattern.compile("-?\\d+").matcher(file.getName());
                    try {
                        if (!m.find()) continue;
                        regionX = Integer.parseInt(m.group());
                        if (!m.find()) continue;
                        regionZ = Integer.parseInt(m.group());
                    }
                    catch (NumberFormatException e) {
                        continue;
                    }
                    RegionLoader region = new RegionLoader(this.provider, regionX, regionZ);
                    for (Integer index : region.getLocationIndexes()) {
                        int chunkZ;
                        int chunkX = index & 0x1F;
                        cn.nukkit.level.format.mcregion.Chunk old = region.readChunk(chunkX, chunkZ = index >> 5);
                        if (old == null) continue;
                        int x = regionX << 5 | chunkX;
                        int z = regionZ << 5 | chunkZ;
                        FullChunk chunk = new ChunkConverter(result).from(old).to(cn.nukkit.level.format.anvil.Chunk.class).perform();
                        result.saveChunk(x, z, chunk);
                    }
                    region.close();
                }
            }
            if (this.provider instanceof LevelDB) {
                new File(this.path, "region").mkdir();
                for (byte[] key : ((LevelDB)this.provider).getTerrainKeys()) {
                    int x = LevelProviderConverter.getChunkX(key);
                    int z = LevelProviderConverter.getChunkZ(key);
                    Chunk old = ((LevelDB)this.provider).readChunk(x, z);
                    FullChunk chunk = new ChunkConverter(result).from(old).to(cn.nukkit.level.format.anvil.Chunk.class).perform();
                    result.saveChunk(x, z, chunk);
                }
            }
            result.doGarbageCollection();
        }
        return result;
    }

    private static int getChunkX(byte[] key) {
        return key[3] << 24 | key[2] << 16 | key[1] << 8 | key[0];
    }

    private static int getChunkZ(byte[] key) {
        return key[7] << 24 | key[6] << 16 | key[5] << 8 | key[4];
    }
}

