/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.format.anvil;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.block.Block;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.entity.Entity;
import cn.nukkit.level.format.ChunkSection;
import cn.nukkit.level.format.LevelProvider;
import cn.nukkit.level.format.anvil.Anvil;
import cn.nukkit.level.format.anvil.palette.BiomePalette;
import cn.nukkit.level.format.generic.BaseChunk;
import cn.nukkit.level.format.generic.EmptyChunkSection;
import cn.nukkit.nbt.NBTIO;
import cn.nukkit.nbt.tag.ByteArrayTag;
import cn.nukkit.nbt.tag.ByteTag;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.nbt.tag.LongTag;
import cn.nukkit.nbt.tag.StringTag;
import cn.nukkit.nbt.tag.Tag;
import cn.nukkit.utils.BinaryStream;
import cn.nukkit.utils.BlockUpdateEntry;
import cn.nukkit.utils.ChunkException;
import cn.nukkit.utils.Zlib;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Chunk
extends BaseChunk {
    protected long inhabitedTime;
    protected boolean terrainPopulated;
    protected boolean terrainGenerated;

    @Override
    public Chunk clone() {
        return (Chunk)super.clone();
    }

    public Chunk(LevelProvider level) {
        this(level, null);
    }

    public Chunk(Class<? extends LevelProvider> providerClass) {
        this((LevelProvider)null, null);
        this.providerClass = providerClass;
    }

    public Chunk(Class<? extends LevelProvider> providerClass, CompoundTag nbt) {
        this((LevelProvider)null, nbt);
        this.providerClass = providerClass;
    }

    public Chunk(LevelProvider level, CompoundTag nbt) {
        ListTag<CompoundTag> updateEntries;
        int i;
        this.provider = level;
        if (level != null) {
            this.providerClass = level.getClass();
        }
        if (nbt == null) {
            this.biomes = new byte[256];
            this.sections = new ChunkSection[16];
            System.arraycopy(EmptyChunkSection.EMPTY, 0, this.sections, 0, 16);
            return;
        }
        this.sections = new ChunkSection[16];
        for (Tag tag : nbt.getList("Sections").getAll()) {
            int y;
            if (!(tag instanceof CompoundTag) || (y = ((CompoundTag)tag).getByte("Y")) >= 16) continue;
            this.sections[y] = new cn.nukkit.level.format.anvil.ChunkSection((CompoundTag)tag);
        }
        for (int y = 0; y < 16; ++y) {
            if (this.sections[y] != null) continue;
            this.sections[y] = EmptyChunkSection.EMPTY[y];
        }
        HashMap<Integer, Integer> extraData = new HashMap<Integer, Integer>();
        Tag tag = nbt.get("ExtraData");
        if (tag instanceof ByteArrayTag) {
            BinaryStream stream = new BinaryStream(((ByteArrayTag)tag).data);
            for (i = 0; i < stream.getInt(); ++i) {
                int key = stream.getInt();
                extraData.put(key, stream.getShort());
            }
        }
        this.setPosition(nbt.getInt("xPos"), nbt.getInt("zPos"));
        if (this.sections.length > 16) {
            throw new ChunkException("Invalid amount of chunks");
        }
        if (nbt.contains("BiomeColors")) {
            this.biomes = new byte[256];
            int[] biomeColors = nbt.getIntArray("BiomeColors");
            if (biomeColors != null && biomeColors.length == 256) {
                BiomePalette palette = new BiomePalette(biomeColors);
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        this.biomes[x << 4 | z] = (byte)(palette.get(x, z) >> 24);
                    }
                }
            }
        } else {
            this.biomes = Arrays.copyOf(nbt.getByteArray("Biomes"), 256);
        }
        int[] heightMap = nbt.getIntArray("HeightMap");
        this.heightMap = new byte[256];
        if (heightMap.length != 256) {
            Arrays.fill(this.heightMap, (byte)-1);
        } else {
            for (i = 0; i < heightMap.length; ++i) {
                this.heightMap[i] = (byte)heightMap[i];
            }
        }
        if (!extraData.isEmpty()) {
            this.extraData = extraData;
        }
        this.NBTentities = nbt.getList("Entities", CompoundTag.class).getAll();
        this.NBTtiles = nbt.getList("TileEntities", CompoundTag.class).getAll();
        if (this.NBTentities.isEmpty()) {
            this.NBTentities = null;
        }
        if (this.NBTtiles.isEmpty()) {
            this.NBTtiles = null;
        }
        if ((updateEntries = nbt.getList("TileTicks", CompoundTag.class)) != null && updateEntries.size() > 0) {
            for (CompoundTag entryNBT : updateEntries.getAll()) {
                Block block;
                block22: {
                    block = null;
                    try {
                        Tag tag2 = entryNBT.get("i");
                        if (!(tag2 instanceof StringTag)) break block22;
                        String name = ((StringTag)tag2).data;
                        Class<?> clazz = Class.forName("cn.nukkit.block." + name);
                        Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
                        constructor.setAccessible(true);
                        block = (Block)constructor.newInstance(new Object[0]);
                    }
                    catch (Throwable e) {
                        continue;
                    }
                }
                if (block == null) continue;
                block.x = entryNBT.getInt("x");
                block.y = entryNBT.getInt("y");
                block.z = entryNBT.getInt("z");
                block.layer = 0;
                this.provider.getLevel().scheduleUpdate(block, block, entryNBT.getInt("t"), entryNBT.getInt("p"), false);
            }
        }
        this.inhabitedTime = nbt.getLong("InhabitedTime");
        this.terrainPopulated = nbt.getBoolean("TerrainPopulated");
        this.terrainGenerated = nbt.getBoolean("TerrainGenerated");
    }

    @Override
    public boolean isPopulated() {
        return this.terrainPopulated;
    }

    @Override
    public void setPopulated() {
        this.setPopulated(true);
    }

    @Override
    public void setPopulated(boolean value) {
        if (value != this.terrainPopulated) {
            this.terrainPopulated = value;
            this.setChanged();
        }
    }

    @Override
    public boolean isGenerated() {
        return this.terrainGenerated || this.terrainPopulated;
    }

    @Override
    public void setGenerated() {
        this.setGenerated(true);
    }

    @Override
    public void setGenerated(boolean value) {
        if (this.terrainGenerated != value) {
            this.terrainGenerated = value;
            this.setChanged();
        }
    }

    public CompoundTag getNBT() {
        CompoundTag tag = new CompoundTag();
        tag.put("LightPopulated", new ByteTag("LightPopulated", (byte)(this.isLightPopulated() ? 1 : 0)));
        tag.put("InhabitedTime", new LongTag("InhabitedTime", this.inhabitedTime));
        tag.put("V", new ByteTag("V", 1));
        tag.put("TerrainGenerated", new ByteTag("TerrainGenerated", (byte)(this.isGenerated() ? 1 : 0)));
        tag.put("TerrainPopulated", new ByteTag("TerrainPopulated", (byte)(this.isPopulated() ? 1 : 0)));
        return tag;
    }

    public static Chunk fromBinary(byte[] data) {
        return Chunk.fromBinary(data, null);
    }

    public static Chunk fromBinary(byte[] data, LevelProvider provider) {
        try {
            CompoundTag chunk = NBTIO.read(new ByteArrayInputStream(Zlib.inflate(data)), ByteOrder.BIG_ENDIAN);
            if (!chunk.contains("Level") || !(chunk.get("Level") instanceof CompoundTag)) {
                return null;
            }
            return new Chunk(provider, chunk.getCompound("Level"));
        }
        catch (Exception e) {
            Server.getInstance().getLogger().logException(e);
            return null;
        }
    }

    public static Chunk fromFastBinary(byte[] data) {
        return Chunk.fromFastBinary(data, null);
    }

    public static Chunk fromFastBinary(byte[] data, LevelProvider provider) {
        try {
            CompoundTag chunk = NBTIO.read(new DataInputStream(new ByteArrayInputStream(data)), ByteOrder.BIG_ENDIAN);
            if (!chunk.contains("Level") || !(chunk.get("Level") instanceof CompoundTag)) {
                return null;
            }
            return new Chunk(provider, chunk.getCompound("Level"));
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public byte[] toFastBinary() {
        CompoundTag nbt = this.getNBT().copy();
        nbt.remove("BiomeColors");
        nbt.putInt("xPos", this.getX());
        nbt.putInt("zPos", this.getZ());
        nbt.putByteArray("Biomes", this.getBiomeIdArray());
        int[] heightInts = new int[256];
        byte[] heightBytes = this.getHeightMapArray();
        for (int i = 0; i < heightInts.length; ++i) {
            heightInts[i] = heightBytes[i] & 0xFF;
        }
        for (ChunkSection section : this.getSections()) {
            if (section instanceof EmptyChunkSection) continue;
            CompoundTag s = section.toNBT();
            nbt.getList("Sections", CompoundTag.class).add(s);
        }
        ArrayList<CompoundTag> entities = new ArrayList<CompoundTag>();
        for (Entity entity : this.getEntities().values()) {
            if (entity instanceof Player || entity.closed) continue;
            entity.saveNBT();
            entities.add(entity.namedTag);
        }
        ListTag<CompoundTag> entityListTag = new ListTag<CompoundTag>("Entities");
        entityListTag.setAll(entities);
        nbt.putList(entityListTag);
        ArrayList<CompoundTag> tiles = new ArrayList<CompoundTag>();
        for (BlockEntity blockEntity : this.getBlockEntities().values()) {
            blockEntity.saveNBT();
            tiles.add(blockEntity.namedTag);
        }
        ListTag<CompoundTag> tileListTag = new ListTag<CompoundTag>("TileEntities");
        tileListTag.setAll(tiles);
        nbt.putList(tileListTag);
        Set<BlockUpdateEntry> entries = this.provider.getLevel().getPendingBlockUpdates(this);
        if (entries != null) {
            ListTag<CompoundTag> tileTickTag = new ListTag<CompoundTag>("TileTicks");
            long totalTime = this.provider.getLevel().getCurrentTick();
            for (BlockUpdateEntry entry : entries) {
                CompoundTag entryNBT = new CompoundTag().putString("i", entry.block.getSaveId()).putInt("x", entry.pos.getFloorX()).putInt("y", entry.pos.getFloorY()).putInt("z", entry.pos.getFloorZ()).putInt("t", (int)(entry.delay - totalTime)).putInt("p", entry.priority);
                tileTickTag.add(entryNBT);
            }
            nbt.putList(tileTickTag);
        }
        BinaryStream extraData = new BinaryStream();
        Map<Integer, Integer> extraDataArray = this.getBlockExtraDataArray();
        extraData.putInt(extraDataArray.size());
        for (Integer key : extraDataArray.keySet()) {
            extraData.putInt(key);
            extraData.putShort(extraDataArray.get(key));
        }
        nbt.putByteArray("ExtraData", extraData.getBuffer());
        CompoundTag chunk = new CompoundTag("");
        chunk.putCompound("Level", nbt);
        try {
            return NBTIO.write(chunk, ByteOrder.BIG_ENDIAN);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] toBinary() {
        CompoundTag nbt = this.getNBT().copy();
        nbt.remove("BiomeColors");
        nbt.putInt("xPos", this.getX());
        nbt.putInt("zPos", this.getZ());
        ListTag<CompoundTag> sectionList = new ListTag<CompoundTag>("Sections");
        for (ChunkSection section : this.getSections()) {
            if (section instanceof EmptyChunkSection) continue;
            CompoundTag s = section.toNBT();
            sectionList.add(s);
        }
        nbt.putList(sectionList);
        nbt.putByteArray("Biomes", this.getBiomeIdArray());
        int[] heightInts = new int[256];
        byte[] heightBytes = this.getHeightMapArray();
        for (int i = 0; i < heightInts.length; ++i) {
            heightInts[i] = heightBytes[i] & 0xFF;
        }
        nbt.putIntArray("HeightMap", heightInts);
        ArrayList<CompoundTag> entities = new ArrayList<CompoundTag>();
        for (Entity entity : this.getEntities().values()) {
            if (entity instanceof Player || entity.closed) continue;
            entity.saveNBT();
            entities.add(entity.namedTag);
        }
        ListTag<CompoundTag> entityListTag = new ListTag<CompoundTag>("Entities");
        entityListTag.setAll(entities);
        nbt.putList(entityListTag);
        ArrayList<CompoundTag> tiles = new ArrayList<CompoundTag>();
        for (BlockEntity blockEntity : this.getBlockEntities().values()) {
            blockEntity.saveNBT();
            tiles.add(blockEntity.namedTag);
        }
        ListTag<CompoundTag> tileListTag = new ListTag<CompoundTag>("TileEntities");
        tileListTag.setAll(tiles);
        nbt.putList(tileListTag);
        Set<BlockUpdateEntry> entries = this.provider.getLevel().getPendingBlockUpdates(this);
        if (entries != null) {
            ListTag<CompoundTag> tileTickTag = new ListTag<CompoundTag>("TileTicks");
            long totalTime = this.provider.getLevel().getCurrentTick();
            for (BlockUpdateEntry entry : entries) {
                CompoundTag entryNBT = new CompoundTag().putString("i", entry.block.getSaveId()).putInt("x", entry.pos.getFloorX()).putInt("y", entry.pos.getFloorY()).putInt("z", entry.pos.getFloorZ()).putInt("t", (int)(entry.delay - totalTime)).putInt("p", entry.priority);
                tileTickTag.add(entryNBT);
            }
            nbt.putList(tileTickTag);
        }
        BinaryStream extraData = new BinaryStream();
        Map<Integer, Integer> extraDataArray = this.getBlockExtraDataArray();
        extraData.putInt(extraDataArray.size());
        for (Integer key : extraDataArray.keySet()) {
            extraData.putInt(key);
            extraData.putShort(extraDataArray.get(key));
        }
        nbt.putByteArray("ExtraData", extraData.getBuffer());
        CompoundTag chunk = new CompoundTag("");
        chunk.putCompound("Level", nbt);
        try {
            return Zlib.deflate(NBTIO.write(chunk, ByteOrder.BIG_ENDIAN), 7);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getBlockSkyLight(int x, int y, int z) {
        ChunkSection section = this.sections[y >> 4];
        if (section instanceof cn.nukkit.level.format.anvil.ChunkSection) {
            cn.nukkit.level.format.anvil.ChunkSection anvilSection = (cn.nukkit.level.format.anvil.ChunkSection)section;
            if (anvilSection.skyLight != null) {
                return section.getBlockSkyLight(x, y & 0xF, z);
            }
            if (!anvilSection.hasSkyLight) {
                return 0;
            }
            int height = this.getHighestBlockAt(x, z);
            if (height < y) {
                return 15;
            }
            if (height == y) {
                return Block.transparent[this.getBlockId(x, y, z)] ? 15 : 0;
            }
            return section.getBlockSkyLight(x, y & 0xF, z);
        }
        return section.getBlockSkyLight(x, y & 0xF, z);
    }

    @Override
    public int getBlockLight(int x, int y, int z) {
        ChunkSection section = this.sections[y >> 4];
        if (section instanceof cn.nukkit.level.format.anvil.ChunkSection) {
            cn.nukkit.level.format.anvil.ChunkSection anvilSection = (cn.nukkit.level.format.anvil.ChunkSection)section;
            if (anvilSection.blockLight != null) {
                return section.getBlockLight(x, y & 0xF, z);
            }
            if (!anvilSection.hasBlockLight) {
                return 0;
            }
            return section.getBlockLight(x, y & 0xF, z);
        }
        return section.getBlockLight(x, y & 0xF, z);
    }

    public static Chunk getEmptyChunk(int chunkX, int chunkZ) {
        return Chunk.getEmptyChunk(chunkX, chunkZ, null);
    }

    public static Chunk getEmptyChunk(int chunkX, int chunkZ, LevelProvider provider) {
        try {
            Chunk chunk = provider != null ? new Chunk(provider, null) : new Chunk(Anvil.class, null);
            chunk.setPosition(chunkX, chunkZ);
            chunk.heightMap = new byte[256];
            chunk.inhabitedTime = 0L;
            chunk.terrainGenerated = false;
            chunk.terrainPopulated = false;
            return chunk;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public boolean compress() {
        super.compress();
        boolean result = false;
        for (ChunkSection section : this.getSections()) {
            cn.nukkit.level.format.anvil.ChunkSection anvilSection;
            if (!(section instanceof cn.nukkit.level.format.anvil.ChunkSection) || (anvilSection = (cn.nukkit.level.format.anvil.ChunkSection)section).isEmpty()) continue;
            result |= anvilSection.compress();
        }
        return result;
    }
}

