/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.format.anvil.palette;

import cn.nukkit.level.format.anvil.palette.BitArray256;
import cn.nukkit.level.format.anvil.palette.IntPalette;
import cn.nukkit.math.MathHelper;
import cn.nukkit.utils.ThreadCache;
import java.util.Arrays;

@Deprecated
public final class BiomePalette {
    private int biome;
    private BitArray256 encodedData;
    private IntPalette palette;

    private BiomePalette(BiomePalette clone) {
        this.biome = clone.biome;
        if (clone.encodedData != null) {
            this.encodedData = clone.encodedData.clone();
            this.palette = clone.palette.clone();
        }
    }

    public BiomePalette(int[] biomeColors) {
        for (int i = 0; i < 256; ++i) {
            this.set(i, biomeColors[i]);
        }
    }

    public BiomePalette() {
        this.biome = Integer.MIN_VALUE;
    }

    public int get(int x, int z) {
        return this.get(this.getIndex(x, z));
    }

    public synchronized int get(int index) {
        if (this.encodedData == null) {
            return this.biome;
        }
        return this.palette.getKey(this.encodedData.getAt(index));
    }

    public void set(int x, int z, int value) {
        this.set(this.getIndex(x, z), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void set(int index, int value) {
        if (this.encodedData == null) {
            if (value == this.biome) {
                return;
            }
            if (this.biome == Integer.MIN_VALUE) {
                this.biome = value;
                return;
            }
            BiomePalette biomePalette = this;
            synchronized (biomePalette) {
                this.palette = new IntPalette();
                this.palette.add(this.biome);
                this.palette.add(value);
                this.encodedData = new BitArray256(1);
                if (value < this.biome) {
                    Arrays.fill(this.encodedData.data, -1L);
                    this.encodedData.setAt(index, 0);
                } else {
                    this.encodedData.setAt(index, 1);
                }
                return;
            }
        }
        int encodedValue = this.palette.getValue(value);
        if (encodedValue != Integer.MIN_VALUE) {
            this.encodedData.setAt(index, encodedValue);
        } else {
            BiomePalette biomePalette = this;
            synchronized (biomePalette) {
                int[] raw = this.encodedData.toRaw((int[])ThreadCache.intCache256.get());
                for (int i = 0; i < 256; ++i) {
                    raw[i] = this.palette.getKey(raw[i]);
                }
                int oldRaw = raw[4];
                raw[index] = value;
                this.palette.add(value);
                int oldBits = MathHelper.log2(this.palette.length() - 2);
                int newBits = MathHelper.log2(this.palette.length() - 1);
                if (oldBits != newBits) {
                    this.encodedData = new BitArray256(newBits);
                }
                for (int i = 0; i < raw.length; ++i) {
                    raw[i] = this.palette.getValue(raw[i]);
                }
                this.encodedData.fromRaw(raw);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int[] toRaw() {
        int[] buffer = (int[])ThreadCache.intCache256.get();
        if (this.encodedData == null) {
            Arrays.fill(buffer, this.biome);
        } else {
            BiomePalette biomePalette = this;
            synchronized (biomePalette) {
                buffer = this.encodedData.toRaw(buffer);
                for (int i = 0; i < 256; ++i) {
                    buffer[i] = this.palette.getKey(buffer[i]);
                }
            }
        }
        return buffer;
    }

    public int getIndex(int x, int z) {
        return z << 4 | x;
    }

    public synchronized BiomePalette clone() {
        return new BiomePalette(this);
    }
}

