/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.generator.populator.helper;

import cn.nukkit.block.BlockID;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.level.generator.populator.helper.EnsureCover;
import cn.nukkit.level.generator.populator.helper.EnsureGrassBelow;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;

public final class PopulatorHelpers
implements BlockID {
    private static final IntSet nonSolidBlocks = new IntOpenHashSet();

    private PopulatorHelpers() {
    }

    public static boolean canGrassStay(int x, int y, int z, FullChunk chunk) {
        return EnsureCover.ensureCover(x, y, z, chunk) && EnsureGrassBelow.ensureGrassBelow(x, y, z, chunk);
    }

    public static boolean isNonSolid(int id) {
        return nonSolidBlocks.contains(id);
    }

    static {
        nonSolidBlocks.add(0);
        nonSolidBlocks.add(18);
        nonSolidBlocks.add(161);
        nonSolidBlocks.add(78);
    }
}

