/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.generator.populator.impl;

import cn.nukkit.level.ChunkManager;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.level.generator.populator.type.Populator;
import cn.nukkit.math.MathHelper;
import cn.nukkit.math.NukkitRandom;
import java.util.Random;

public class PopulatorRavines
extends Populator {
    protected int checkAreaSize = 8;
    private Random random;
    private long worldLong1;
    private long worldLong2;
    private int ravineRarity = 1;
    private int ravineMinAltitude = 20;
    private int ravineMaxAltitude = 67;
    private int ravineMinLength = 84;
    private int ravineMaxLength = 111;
    private double ravineDepth = 3.0;
    private int worldHeightCap = 256;
    private float[] a = new float[1024];

    @Override
    public void populate(ChunkManager level, int chunkX, int chunkZ, NukkitRandom random, FullChunk chunk) {
        this.random = new Random();
        this.random.setSeed(level.getSeed());
        this.worldLong1 = this.random.nextLong();
        this.worldLong2 = this.random.nextLong();
        int i = this.checkAreaSize;
        for (int x = chunkX - i; x <= chunkX + i; ++x) {
            for (int z = chunkZ - i; z <= chunkZ + i; ++z) {
                long l3 = (long)x * this.worldLong1;
                long l4 = (long)z * this.worldLong2;
                this.random.setSeed(l3 ^ l4 ^ level.getSeed());
                this.generateChunk(chunkX, chunkZ, level.getChunk(chunkX, chunkZ));
            }
        }
    }

    protected void generateChunk(int chunkX, int chunkZ, FullChunk generatingChunkBuffer) {
        if (this.random.nextInt(300) >= this.ravineRarity) {
            return;
        }
        double d1 = chunkX * 16 + this.random.nextInt(16);
        double d2 = PopulatorRavines.numberInRange(this.random, this.ravineMinAltitude, this.ravineMaxAltitude);
        double d3 = chunkZ * 16 + this.random.nextInt(16);
        int i = 1;
        for (int j = 0; j < i; ++j) {
            float f1 = this.random.nextFloat() * 3.141593f * 2.0f;
            float f2 = (this.random.nextFloat() - 0.5f) * 2.0f / 8.0f;
            float f3 = (this.random.nextFloat() * 2.0f + this.random.nextFloat()) * 2.0f;
            int size = PopulatorRavines.numberInRange(this.random, this.ravineMinLength, this.ravineMaxLength);
            this.createRavine(this.random.nextLong(), generatingChunkBuffer, d1, d2, d3, f3, f1, f2, size, this.ravineDepth);
        }
    }

    protected void createRavine(long paramLong, FullChunk generatingChunkBuffer, double paramDouble1, double paramDouble2, double paramDouble3, float paramFloat1, float paramFloat2, float paramFloat3, int size, double paramDouble4) {
        Random localRandom = new Random(paramLong);
        int chunkX = generatingChunkBuffer.getX();
        int chunkZ = generatingChunkBuffer.getZ();
        double d1 = chunkX * 16 + 8;
        double d2 = chunkZ * 16 + 8;
        float f1 = 0.0f;
        float f2 = 0.0f;
        boolean i = false;
        float f3 = 1.0f;
        for (int j = 0; j < this.worldHeightCap; ++j) {
            if (j == 0 || localRandom.nextInt(3) == 0) {
                f3 = 1.0f + localRandom.nextFloat() * localRandom.nextFloat() * 1.0f;
            }
            this.a[j] = f3 * f3;
        }
        for (int stepCount = 0; stepCount < size; ++stepCount) {
            int localX;
            double d3 = 1.5 + (double)(MathHelper.sin((float)stepCount * 3.141593f / (float)size) * paramFloat1 * 1.0f);
            double d4 = d3 * paramDouble4;
            d3 *= (double)localRandom.nextFloat() * 0.25 + 0.75;
            d4 *= (double)localRandom.nextFloat() * 0.25 + 0.75;
            float f4 = MathHelper.cos(paramFloat3);
            float f5 = MathHelper.sin(paramFloat3);
            paramDouble1 += (double)(MathHelper.cos(paramFloat2) * f4);
            paramDouble2 += (double)f5;
            paramDouble3 += (double)(MathHelper.sin(paramFloat2) * f4);
            paramFloat3 *= 0.7f;
            paramFloat3 += f2 * 0.05f;
            paramFloat2 += f1 * 0.05f;
            f2 *= 0.8f;
            f1 *= 0.5f;
            f2 += (localRandom.nextFloat() - localRandom.nextFloat()) * localRandom.nextFloat() * 2.0f;
            f1 += (localRandom.nextFloat() - localRandom.nextFloat()) * localRandom.nextFloat() * 4.0f;
            if (!i && localRandom.nextInt(4) == 0) continue;
            double d5 = paramDouble1 - d1;
            double d6 = paramDouble3 - d2;
            double d7 = size - stepCount;
            double d8 = paramFloat1 + 2.0f + 16.0f;
            if (d5 * d5 + d6 * d6 - d7 * d7 > d8 * d8) {
                return;
            }
            if (paramDouble1 < d1 - 16.0 - d3 * 2.0 || paramDouble3 < d2 - 16.0 - d3 * 2.0 || paramDouble1 > d1 + 16.0 + d3 * 2.0 || paramDouble3 > d2 + 16.0 + d3 * 2.0) continue;
            int k = MathHelper.floor(paramDouble1 - d3) - chunkX * 16 - 1;
            int m = MathHelper.floor(paramDouble1 + d3) - chunkZ * 16 + 1;
            int maxY = MathHelper.floor(paramDouble2 - d4) - 1;
            int minY = MathHelper.floor(paramDouble2 + d4) + 1;
            int i2 = MathHelper.floor(paramDouble3 - d3) - chunkX * 16 - 1;
            int i3 = MathHelper.floor(paramDouble3 + d3) - chunkZ * 16 + 1;
            if (k < 0) {
                k = 0;
            }
            if (m > 16) {
                m = 16;
            }
            if (maxY < 1) {
                maxY = 1;
            }
            if (minY > this.worldHeightCap - 8) {
                minY = this.worldHeightCap - 8;
            }
            if (i2 < 0) {
                i2 = 0;
            }
            if (i3 > 16) {
                i3 = 16;
            }
            boolean i4 = false;
            for (localX = k; !i4 && localX < m; ++localX) {
                for (int localZ = i2; !i4 && localZ < i3; ++localZ) {
                    for (int localY = minY + 1; !i4 && localY >= maxY - 1; --localY) {
                        if (localY < 0 || localY >= this.worldHeightCap) continue;
                        int materialAtPosition = generatingChunkBuffer.getBlockId(localX, localY, localZ);
                        if (materialAtPosition == 8 || materialAtPosition == 9) {
                            i4 = true;
                        }
                        if (localY == maxY - 1 || localX == k || localX == m - 1 || localZ == i2 || localZ == i3 - 1) continue;
                        localY = maxY;
                    }
                }
            }
            if (i4) continue;
            for (localX = k; localX < m; ++localX) {
                double d9 = ((double)(localX + chunkX * 16) + 0.5 - paramDouble1) / d3;
                for (int localZ = i2; localZ < i3; ++localZ) {
                    double d10 = ((double)(localZ + chunkZ * 16) + 0.5 - paramDouble3) / d3;
                    if (!(d9 * d9 + d10 * d10 < 1.0)) continue;
                    for (int localY = minY; localY >= maxY; --localY) {
                        int material;
                        double d11 = ((double)(localY - 1) + 0.5 - paramDouble2) / d4;
                        if (!((d9 * d9 + d10 * d10) * (double)this.a[localY - 1] + d11 * d11 / 6.0 < 1.0) || (material = generatingChunkBuffer.getBlockId(localX, localY, localZ)) != 2) continue;
                        if (localY - 1 < 10) {
                            generatingChunkBuffer.setBlock(localX, localY, localZ, 10);
                            continue;
                        }
                        generatingChunkBuffer.setBlock(localX, localY, localZ, 0);
                    }
                }
            }
            if (i) break;
        }
    }

    public static int numberInRange(Random random, int min, int max) {
        return min + random.nextInt(max - min + 1);
    }
}

