/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.network.protocol;

import cn.nukkit.entity.data.Skin;
import cn.nukkit.network.protocol.DataPacket;
import cn.nukkit.network.protocol.ProtocolInfo;
import cn.nukkit.utils.PersonaPiece;
import cn.nukkit.utils.PersonaPieceTint;
import cn.nukkit.utils.SerializedImage;
import cn.nukkit.utils.SkinAnimation;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class LoginPacket
extends DataPacket {
    public static final byte NETWORK_ID = 1;
    public String username;
    public int protocol;
    public UUID clientUUID;
    public long clientId;
    public Skin skin;

    @Override
    public byte pid() {
        return 1;
    }

    @Override
    public void decode() {
        this.protocol = this.getInt();
        if (this.protocol == 0) {
            this.setOffset(this.getOffset() + 2);
            this.protocol = this.getInt();
        }
        if (!ProtocolInfo.SUPPORTED_PROTOCOLS.contains(this.protocol)) {
            return;
        }
        this.setBuffer(this.getByteArray(), 0);
        this.decodeChainData();
        this.decodeSkinData();
    }

    @Override
    public void encode() {
    }

    public int getProtocol() {
        return this.protocol;
    }

    private void decodeChainData() {
        Map map = (Map)new Gson().fromJson(new String(this.get(this.getLInt()), StandardCharsets.UTF_8), new TypeToken<Map<String, List<String>>>(){}.getType());
        if (map.isEmpty() || !map.containsKey("chain") || ((List)map.get("chain")).isEmpty()) {
            return;
        }
        List chains = (List)map.get("chain");
        for (String c : chains) {
            JsonObject chainMap = this.decodeToken(c);
            if (chainMap == null || !chainMap.has("extraData")) continue;
            JsonObject extra = chainMap.get("extraData").getAsJsonObject();
            if (extra.has("displayName")) {
                this.username = extra.get("displayName").getAsString();
            }
            if (!extra.has("identity")) continue;
            this.clientUUID = UUID.fromString(extra.get("identity").getAsString());
        }
    }

    private void decodeSkinData() {
        JsonObject skinToken = this.decodeToken(new String(this.get(this.getLInt())));
        if (skinToken.has("ClientRandomId")) {
            this.clientId = skinToken.get("ClientRandomId").getAsLong();
        }
        this.skin = new Skin();
        if (skinToken.has("SkinId")) {
            this.skin.setSkinId(skinToken.get("SkinId").getAsString());
        }
        if (skinToken.has("CapeId")) {
            this.skin.setCapeId(skinToken.get("CapeId").getAsString());
        }
        this.skin.setSkinData(LoginPacket.getImage(skinToken, "Skin"));
        this.skin.setCapeData(LoginPacket.getImage(skinToken, "Cape"));
        if (skinToken.has("PremiumSkin")) {
            this.skin.setPremium(skinToken.get("PremiumSkin").getAsBoolean());
        }
        if (skinToken.has("PersonaSkin")) {
            this.skin.setPersona(skinToken.get("PersonaSkin").getAsBoolean());
        }
        if (skinToken.has("CapeOnClassicSkin")) {
            this.skin.setCapeOnClassic(skinToken.get("CapeOnClassicSkin").getAsBoolean());
        }
        if (skinToken.has("SkinResourcePatch")) {
            this.skin.setSkinResourcePatch(new String(Base64.getDecoder().decode(skinToken.get("SkinResourcePatch").getAsString()), StandardCharsets.UTF_8));
        }
        if (skinToken.has("SkinGeometryData")) {
            this.skin.setGeometryData(new String(Base64.getDecoder().decode(skinToken.get("SkinGeometryData").getAsString()), StandardCharsets.UTF_8));
        }
        if (skinToken.has("AnimationData")) {
            this.skin.setAnimationData(new String(Base64.getDecoder().decode(skinToken.get("AnimationData").getAsString()), StandardCharsets.UTF_8));
        }
        if (skinToken.has("AnimatedImageData")) {
            JsonArray array = skinToken.get("AnimatedImageData").getAsJsonArray();
            for (JsonElement element : array) {
                this.skin.getAnimations().add(LoginPacket.getAnimation(element.getAsJsonObject()));
            }
        }
        if (skinToken.has("SkinColor")) {
            this.skin.setSkinColor(skinToken.get("SkinColor").getAsString());
        }
        if (skinToken.has("ArmSize")) {
            this.skin.setArmSize(skinToken.get("ArmSize").getAsString());
        }
        if (skinToken.has("PersonaPieces")) {
            for (JsonElement object : skinToken.get("PersonaPieces").getAsJsonArray()) {
                this.skin.getPersonaPieces().add(LoginPacket.getPersonaPiece(object.getAsJsonObject()));
            }
        }
        if (skinToken.has("PieceTintColors")) {
            for (JsonElement object : skinToken.get("PieceTintColors").getAsJsonArray()) {
                this.skin.getTintColors().add(LoginPacket.getTint(object.getAsJsonObject()));
            }
        }
    }

    private JsonObject decodeToken(String token) {
        String[] base = token.split("\\.");
        if (base.length < 2) {
            return null;
        }
        return (JsonObject)new Gson().fromJson(new String(Base64.getDecoder().decode(base[1]), StandardCharsets.UTF_8), JsonObject.class);
    }

    private static SkinAnimation getAnimation(JsonObject element) {
        float frames = element.get("Frames").getAsFloat();
        int type = element.get("Type").getAsInt();
        byte[] data = Base64.getDecoder().decode(element.get("Image").getAsString());
        int width = element.get("ImageWidth").getAsInt();
        int height = element.get("ImageHeight").getAsInt();
        int expression = element.get("AnimationExpression").getAsInt();
        return new SkinAnimation(new SerializedImage(width, height, data), type, frames, expression);
    }

    private static SerializedImage getImage(JsonObject token, String name) {
        if (token.has(name + "Data")) {
            byte[] skinImage = Base64.getDecoder().decode(token.get(name + "Data").getAsString());
            if (token.has(name + "ImageHeight") && token.has(name + "ImageWidth")) {
                int width = token.get(name + "ImageWidth").getAsInt();
                int height = token.get(name + "ImageHeight").getAsInt();
                return new SerializedImage(width, height, skinImage);
            }
            return SerializedImage.fromLegacy(skinImage);
        }
        return SerializedImage.EMPTY;
    }

    private static PersonaPiece getPersonaPiece(JsonObject object) {
        String pieceId = object.get("PieceId").getAsString();
        String pieceType = object.get("PieceType").getAsString();
        String packId = object.get("PackId").getAsString();
        boolean isDefault = object.get("IsDefault").getAsBoolean();
        String productId = object.get("ProductId").getAsString();
        return new PersonaPiece(pieceId, pieceType, packId, isDefault, productId);
    }

    public static PersonaPieceTint getTint(JsonObject object) {
        String pieceType = object.get("PieceType").getAsString();
        ArrayList<String> colors = new ArrayList<String>();
        for (JsonElement element : object.get("Colors").getAsJsonArray()) {
            colors.add(element.getAsString());
        }
        return new PersonaPieceTint(pieceType, colors);
    }

    public String toString() {
        return "LoginPacket(username=" + this.username + ", protocol=" + this.getProtocol() + ", clientUUID=" + this.clientUUID + ", clientId=" + this.clientId + ", skin=" + this.skin + ")";
    }
}

