/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.network.protocol;

import cn.nukkit.api.Since;
import cn.nukkit.network.protocol.DataPacket;

public class NPCRequestPacket
extends DataPacket {
    @Since(value="1.3.2.0-PN")
    public long entityRuntimeId;
    @Since(value="1.3.2.0-PN")
    public RequestType requestType;
    @Since(value="1.3.2.0-PN")
    public String commandString;
    @Since(value="1.3.2.0-PN")
    public int actionType;

    @Override
    public byte pid() {
        return 98;
    }

    @Override
    public void decode() {
        this.entityRuntimeId = this.getEntityRuntimeId();
        this.requestType = RequestType.values()[this.getByte()];
        this.commandString = this.getString();
        this.actionType = this.getByte();
    }

    @Override
    public void encode() {
        this.putEntityRuntimeId(this.entityRuntimeId);
        this.putByte((byte)this.requestType.ordinal());
        this.putString(this.commandString);
        this.putByte((byte)this.actionType);
    }

    public String toString() {
        return "NPCRequestPacket(entityRuntimeId=" + this.entityRuntimeId + ", requestType=" + (Object)((Object)this.requestType) + ", commandString=" + this.commandString + ", actionType=" + this.actionType + ")";
    }

    @Since(value="1.3.2.0-PN")
    public static enum RequestType {
        SET_ACTIONS,
        EXECUTE_ACTION,
        EXECUTE_CLOSING_COMMANDS,
        SET_NAME,
        SET_SKIN,
        SET_INTERACTION_TEXT;

    }
}

