/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.timings;

import cn.nukkit.timings.JsonUtil;
import com.google.gson.JsonArray;

class TimingData {
    private int id;
    int count = 0;
    private int lagCount = 0;
    long totalTime = 0L;
    private long lagTotalTime = 0L;
    int curTickCount = 0;
    int curTickTotal = 0;

    TimingData(int id) {
        this.id = id;
    }

    TimingData(TimingData data) {
        this.id = data.id;
        this.count = data.count;
        this.lagCount = data.lagCount;
        this.totalTime = data.totalTime;
        this.lagTotalTime = data.lagTotalTime;
    }

    void add(long diff) {
        ++this.curTickCount;
        this.curTickTotal = (int)((long)this.curTickTotal + diff);
    }

    void tick(boolean violated) {
        this.count += this.curTickCount;
        this.totalTime += (long)this.curTickTotal;
        if (violated) {
            this.lagCount += this.curTickCount;
            this.lagTotalTime += (long)this.curTickTotal;
        }
        this.curTickCount = 0;
        this.curTickTotal = 0;
    }

    void reset() {
        this.count = 0;
        this.lagCount = 0;
        this.totalTime = 0L;
        this.lagTotalTime = 0L;
        this.curTickCount = 0;
        this.curTickTotal = 0;
    }

    protected TimingData clone() {
        return new TimingData(this);
    }

    JsonArray export() {
        JsonArray json = JsonUtil.toArray(this.id, this.count, this.totalTime);
        if (this.lagCount > 0) {
            json.add((Number)this.lagCount);
            json.add((Number)this.lagTotalTime);
        }
        return json;
    }
}

