/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.timings;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.entity.Entity;
import cn.nukkit.level.Level;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.timings.JsonUtil;
import co.aikar.timings.Timing;
import co.aikar.timings.TimingData;
import co.aikar.timings.Timings;
import co.aikar.timings.TimingsHistoryEntry;
import co.aikar.timings.TimingsManager;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.management.ManagementFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class TimingsHistory {
    public static long lastMinuteTime;
    public static long timedTicks;
    public static long playerTicks;
    public static long entityTicks;
    public static long tileEntityTicks;
    public static long activatedEntityTicks;
    private static int levelIdPool;
    static Map<String, Integer> levelMap;
    static Map<Integer, String> entityMap;
    static Map<Integer, String> blockEntityMap;
    private final long endTime;
    private final long startTime;
    private final long totalTicks;
    private final long totalTime;
    private final MinuteReport[] minuteReports;
    private final TimingsHistoryEntry[] entries;
    private final JsonObject levels = new JsonObject();

    TimingsHistory() {
        this.endTime = System.currentTimeMillis() / 1000L;
        this.startTime = TimingsManager.historyStart / 1000L;
        if (timedTicks % 1200L != 0L || TimingsManager.MINUTE_REPORTS.isEmpty()) {
            this.minuteReports = TimingsManager.MINUTE_REPORTS.toArray(new MinuteReport[TimingsManager.MINUTE_REPORTS.size() + 1]);
            this.minuteReports[this.minuteReports.length - 1] = new MinuteReport();
        } else {
            this.minuteReports = TimingsManager.MINUTE_REPORTS.toArray(new MinuteReport[0]);
        }
        long ticks = 0L;
        for (MinuteReport mr : this.minuteReports) {
            ticks += mr.ticksRecord.timed;
        }
        this.totalTicks = ticks;
        this.totalTime = Timings.fullServerTickTimer.record.totalTime;
        this.entries = new TimingsHistoryEntry[TimingsManager.TIMINGS.size()];
        int i = 0;
        for (Timing timing : TimingsManager.TIMINGS) {
            this.entries[i++] = new TimingsHistoryEntry(timing);
        }
        HashMap<Integer, AtomicInteger> entityCounts = new HashMap<Integer, AtomicInteger>();
        HashMap<Integer, AtomicInteger> blockEntityCounts = new HashMap<Integer, AtomicInteger>();
        Gson GSON = new Gson();
        for (Level level : Server.getInstance().getLevels().values()) {
            JsonArray jsonLevel = new JsonArray();
            for (FullChunk fullChunk : level.getChunks().values()) {
                entityCounts.clear();
                blockEntityCounts.clear();
                for (Entity entity : fullChunk.getEntities().values()) {
                    if (!entityCounts.containsKey(entity.getNetworkId())) {
                        entityCounts.put(entity.getNetworkId(), new AtomicInteger(0));
                    }
                    ((AtomicInteger)entityCounts.get(entity.getNetworkId())).incrementAndGet();
                    entityMap.put(entity.getNetworkId(), entity.getClass().getSimpleName());
                }
                for (BlockEntity blockEntity : fullChunk.getBlockEntities().values()) {
                    if (!blockEntityCounts.containsKey(blockEntity.getBlock().getId())) {
                        blockEntityCounts.put(blockEntity.getBlock().getId(), new AtomicInteger(0));
                    }
                    ((AtomicInteger)blockEntityCounts.get(blockEntity.getBlock().getId())).incrementAndGet();
                    blockEntityMap.put(blockEntity.getBlock().getId(), blockEntity.getClass().getSimpleName());
                }
                if (blockEntityCounts.isEmpty() && entityCounts.isEmpty()) continue;
                JsonArray jsonChunk = new JsonArray();
                jsonChunk.add((Number)fullChunk.getX());
                jsonChunk.add((Number)fullChunk.getZ());
                jsonChunk.add((JsonElement)GSON.toJsonTree((Object)JsonUtil.mapToObject(entityCounts.entrySet(), entry -> new JsonUtil.JSONPair((Integer)entry.getKey(), (Object)((AtomicInteger)entry.getValue()).get()))).getAsJsonObject());
                jsonChunk.add((JsonElement)GSON.toJsonTree((Object)JsonUtil.mapToObject(blockEntityCounts.entrySet(), entry -> new JsonUtil.JSONPair((Integer)entry.getKey(), (Object)((AtomicInteger)entry.getValue()).get()))).getAsJsonObject());
                jsonLevel.add((JsonElement)jsonChunk);
            }
            if (!levelMap.containsKey(level.getName())) {
                levelMap.put(level.getName(), levelIdPool++);
            }
            this.levels.add(String.valueOf(levelMap.get(level.getName())), (JsonElement)jsonLevel);
        }
    }

    static void resetTicks(boolean fullReset) {
        if (fullReset) {
            timedTicks = 0L;
        }
        lastMinuteTime = System.nanoTime();
        playerTicks = 0L;
        tileEntityTicks = 0L;
        entityTicks = 0L;
        activatedEntityTicks = 0L;
    }

    JsonObject export() {
        JsonObject json = new JsonObject();
        json.addProperty("s", (Number)this.startTime);
        json.addProperty("e", (Number)this.endTime);
        json.addProperty("tk", (Number)this.totalTicks);
        json.addProperty("tm", (Number)this.totalTime);
        json.add("w", (JsonElement)this.levels);
        json.add("h", (JsonElement)JsonUtil.mapToArray(this.entries, entry -> {
            if (entry.data.count == 0) {
                return null;
            }
            return entry.export();
        }));
        json.add("mp", (JsonElement)JsonUtil.mapToArray(this.minuteReports, MinuteReport::export));
        return json;
    }

    static {
        levelIdPool = 1;
        levelMap = new HashMap<String, Integer>();
        entityMap = new HashMap<Integer, String>();
        blockEntityMap = new HashMap<Integer, String>();
    }

    private static class PingRecord {
        final double avg;

        PingRecord() {
            Collection<Player> onlinePlayers = Server.getInstance().getOnlinePlayers().values();
            int totalPing = 0;
            for (Player player : onlinePlayers) {
                totalPing += player.getPing();
            }
            this.avg = onlinePlayers.isEmpty() ? 0.0 : (double)((float)totalPing / (float)onlinePlayers.size());
        }
    }

    private static class TicksRecord {
        final long timed = timedTicks - (long)(TimingsManager.MINUTE_REPORTS.size() * 1200);
        final long player = playerTicks;
        final long entity = entityTicks;
        final long activatedEntity = activatedEntityTicks;
        final long tileEntity = tileEntityTicks;

        TicksRecord() {
        }
    }

    static class MinuteReport {
        final long time = System.currentTimeMillis() / 1000L;
        final TicksRecord ticksRecord = new TicksRecord();
        final PingRecord pingRecord = new PingRecord();
        final TimingData fst;
        final double tps;
        final double usedMemory;
        final double freeMemory;
        final double loadAvg;

        MinuteReport() {
            this.fst = Timings.fullServerTickTimer.minuteData.clone();
            this.tps = 1.0E9 / (double)(System.nanoTime() - lastMinuteTime) * (double)this.ticksRecord.timed;
            this.usedMemory = Timings.fullServerTickTimer.avgUsedMemory;
            this.freeMemory = Timings.fullServerTickTimer.avgFreeMemory;
            this.loadAvg = ManagementFactory.getOperatingSystemMXBean().getSystemLoadAverage();
        }

        JsonArray export() {
            return JsonUtil.toArray(this.time, (double)Math.round(this.tps * 100.0) / 100.0, (double)Math.round(this.pingRecord.avg * 100.0) / 100.0, this.fst.export(), JsonUtil.toArray(this.ticksRecord.timed, this.ticksRecord.player, this.ticksRecord.entity, this.ticksRecord.activatedEntity, this.ticksRecord.tileEntity), this.usedMemory, this.freeMemory, this.loadAvg);
        }
    }
}

