/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.block.BlockIceFrosted;
import cn.nukkit.block.BlockSolidMeta;
import cn.nukkit.block.BlockWater;
import cn.nukkit.event.block.BlockFadeEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;
import java.util.concurrent.ThreadLocalRandom;

public class BlockCoralBlock
extends BlockSolidMeta {
    public BlockCoralBlock() {
        this(0);
    }

    public BlockCoralBlock(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 387;
    }

    public boolean isDead() {
        return (this.getDamage() & 8) == 8;
    }

    public void setDead(boolean dead) {
        if (dead) {
            this.setDamage(this.getDamage() | 8);
        } else {
            this.setDamage(this.getDamage() ^ 8);
        }
    }

    @Override
    public String getName() {
        String[] names = new String[]{"Tube Coral Block", "Brain Coral Block", "Bubble Coral Block", "Fire Coral Block", "Horn Coral Block", "Tube Coral Block", "Tube Coral Block", "Tube Coral Block"};
        String name = names[this.getDamage() & 7];
        if (this.isDead()) {
            return "Dead " + name;
        }
        return name;
    }

    @Override
    public BlockColor getColor() {
        if (this.isDead()) {
            return BlockColor.GRAY_BLOCK_COLOR;
        }
        BlockColor[] colors = new BlockColor[]{BlockColor.BLUE_BLOCK_COLOR, BlockColor.PINK_BLOCK_COLOR, BlockColor.PURPLE_BLOCK_COLOR, BlockColor.RED_BLOCK_COLOR, BlockColor.YELLOW_BLOCK_COLOR, BlockColor.BLUE_BLOCK_COLOR, BlockColor.BLUE_BLOCK_COLOR, BlockColor.BLUE_BLOCK_COLOR};
        return colors[this.getDamage() & 7];
    }

    @Override
    public double getHardness() {
        return 7.0;
    }

    @Override
    public double getResistance() {
        return 6.0;
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }

    @Override
    public int getToolType() {
        return 3;
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1) {
            if (!this.isDead()) {
                this.getLevel().scheduleUpdate(this, 60 + ThreadLocalRandom.current().nextInt(40));
            }
            return type;
        }
        if (type == 3) {
            if (!this.isDead()) {
                for (BlockFace face : BlockFace.values()) {
                    if (!(this.getSideAtLayer(0, face) instanceof BlockWater) && !(this.getSideAtLayer(1, face) instanceof BlockWater) && !(this.getSideAtLayer(0, face) instanceof BlockIceFrosted) && !(this.getSideAtLayer(1, face) instanceof BlockIceFrosted)) continue;
                    return type;
                }
                BlockFadeEvent event = new BlockFadeEvent(this, new BlockCoralBlock(this.getDamage() | 8));
                if (!event.isCancelled()) {
                    this.setDead(true);
                    this.getLevel().setBlock((Vector3)this, event.getNewState(), true, true);
                }
            }
            return type;
        }
        return 0;
    }

    @Override
    public Item[] getDrops(Item item) {
        if (item.isPickaxe() && item.getTier() >= 1) {
            if (item.getEnchantment(16) != null) {
                return new Item[]{this.toItem()};
            }
            return new Item[]{new ItemBlock(this.clone(), (Integer)(this.getDamage() | 8))};
        }
        return new Item[0];
    }
}

