/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.block.Block;
import cn.nukkit.block.BlockCrops;
import cn.nukkit.block.BlockIceFrosted;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.block.BlockWater;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;

public class BlockFarmland
extends BlockTransparentMeta {
    public BlockFarmland() {
        this(0);
    }

    public BlockFarmland(int meta) {
        super(meta);
    }

    @Override
    public String getName() {
        return "Farmland";
    }

    @Override
    public int getId() {
        return 60;
    }

    @Override
    public double getResistance() {
        return 3.0;
    }

    @Override
    public double getHardness() {
        return 0.6;
    }

    @Override
    public int getToolType() {
        return 2;
    }

    @Override
    public double getMaxY() {
        return this.y + 1.0;
    }

    @Override
    public int onUpdate(int type) {
        if (type == 2) {
            Vector3 v = new Vector3();
            if (this.level.getBlock(v.setComponents(this.x, this.y + 1.0, this.z)) instanceof BlockCrops) {
                return 0;
            }
            if (this.level.getBlock(v.setComponents(this.x, this.y + 1.0, this.z)).isSolid()) {
                this.level.setBlock((Vector3)this, Block.get(3), false, true);
                return 2;
            }
            boolean found = false;
            if (this.level.isRaining()) {
                found = true;
            } else {
                int x = (int)this.x - 4;
                while ((double)x <= this.x + 4.0) {
                    int z = (int)this.z - 4;
                    while ((double)z <= this.z + 4.0) {
                        int y = (int)this.y;
                        while ((double)y <= this.y + 1.0) {
                            if ((double)z != this.z || (double)x != this.x || (double)y != this.y) {
                                v.setComponents(x, y, z);
                                int block = this.level.getBlockIdAt(v.getFloorX(), v.getFloorY(), v.getFloorZ());
                                if (block == 8 || block == 9 || block == 207) {
                                    found = true;
                                    break;
                                }
                                block = this.level.getBlockIdAt(v.getFloorX(), v.getFloorY(), v.getFloorZ(), 1);
                                if (block == 8 || block == 9 || block == 207) {
                                    found = true;
                                    break;
                                }
                            }
                            ++y;
                        }
                        ++z;
                    }
                    ++x;
                }
            }
            Block block = this.level.getBlock(v.setComponents(this.x, this.y - 1.0, this.z));
            if (found || block instanceof BlockWater || block instanceof BlockIceFrosted) {
                if (this.getDamage() < 7) {
                    this.setDamage(7);
                    this.level.setBlock((Vector3)this, this, false, false);
                }
                return 2;
            }
            if (this.getDamage() > 0) {
                this.setDamage(this.getDamage() - 1);
                this.level.setBlock((Vector3)this, this, false, false);
            } else {
                this.level.setBlock((Vector3)this, Block.get(3), false, true);
            }
            return 2;
        }
        return 0;
    }

    @Override
    public Item toItem() {
        return new ItemBlock(Block.get(3));
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.DIRT_BLOCK_COLOR;
    }
}

