/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.blockentity.BlockEntityHopper;
import cn.nukkit.inventory.ContainerInventory;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemHopper;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.utils.Faceable;

public class BlockHopper
extends BlockTransparentMeta
implements Faceable {
    public BlockHopper() {
        this(0);
    }

    public BlockHopper(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 154;
    }

    @Override
    public String getName() {
        return "Hopper Block";
    }

    @Override
    public double getHardness() {
        return 3.0;
    }

    @Override
    public double getResistance() {
        return 24.0;
    }

    @Override
    public int getWaterloggingLevel() {
        return 1;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        boolean powered;
        BlockFace facing = face.getOpposite();
        if (facing == BlockFace.UP) {
            facing = BlockFace.DOWN;
        }
        this.setDamage(facing.getIndex());
        if (this.level.getServer().isRedstoneEnabled() && (powered = this.level.isBlockPowered(this.getLocation())) == this.isEnabled()) {
            this.setEnabled(!powered);
        }
        this.level.setBlock(this, this);
        CompoundTag nbt = new CompoundTag().putList(new ListTag("Items")).putString("id", "Hopper").putInt("x", (int)this.x).putInt("y", (int)this.y).putInt("z", (int)this.z);
        BlockEntityHopper hopper = (BlockEntityHopper)BlockEntity.createBlockEntity("Hopper", this.level.getChunk(this.getFloorX() >> 4, this.getFloorZ() >> 4), nbt, new Object[0]);
        return hopper != null;
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        BlockEntity blockEntity = this.level.getBlockEntity(this);
        if (blockEntity instanceof BlockEntityHopper) {
            return player.addWindow(((BlockEntityHopper)blockEntity).getInventory()) != -1;
        }
        return false;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean hasComparatorInputOverride() {
        return true;
    }

    @Override
    public int getComparatorInputOverride() {
        BlockEntity blockEntity = this.level.getBlockEntity(this);
        if (blockEntity instanceof BlockEntityHopper) {
            return ContainerInventory.calculateRedstone(((BlockEntityHopper)blockEntity).getInventory());
        }
        return super.getComparatorInputOverride();
    }

    public BlockFace getFacing() {
        return BlockFace.fromIndex(this.getDamage() & 7);
    }

    public boolean isEnabled() {
        return (this.getDamage() & 8) != 8;
    }

    public void setEnabled(boolean enabled) {
        if (this.isEnabled() != enabled) {
            this.setDamage(this.getDamage() ^ 8);
        }
    }

    @Override
    public int onUpdate(int type) {
        if (!this.level.getServer().isRedstoneEnabled()) {
            return 0;
        }
        if (type == 1 || type == 6) {
            boolean powered = this.level.isBlockPowered(this.getLocation());
            if (powered == this.isEnabled()) {
                BlockEntity be;
                this.setEnabled(!powered);
                this.level.setBlock((Vector3)this, this, false, false);
                if (!powered && (be = this.level.getBlockEntity(this)) != null) {
                    be.scheduleUpdate();
                }
            }
            return type;
        }
        return 0;
    }

    @Override
    public int getToolType() {
        return 3;
    }

    @Override
    public Item[] getDrops(Item item) {
        if (item.getTier() >= 1) {
            return new Item[]{this.toItem()};
        }
        return new Item[0];
    }

    @Override
    public Item toItem() {
        return new ItemHopper();
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }

    @Override
    public BlockFace getBlockFace() {
        return BlockFace.fromHorizontalIndex(this.getDamage() & 7);
    }
}

