/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockSolid;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.blockentity.BlockEntityJukebox;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.item.ItemRecord;
import cn.nukkit.math.BlockFace;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.utils.BlockColor;

public class BlockJukebox
extends BlockSolid {
    @Override
    public String getName() {
        return "Jukebox";
    }

    @Override
    public int getId() {
        return 84;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public Item toItem() {
        return new ItemBlock(this, (Integer)0);
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        BlockEntityJukebox jukebox;
        BlockEntity blockEntity = this.getLevel().getBlockEntity(this);
        if (!(blockEntity instanceof BlockEntityJukebox)) {
            blockEntity = this.createBlockEntity();
        }
        if ((jukebox = (BlockEntityJukebox)blockEntity).getRecordItem().getId() != 0) {
            jukebox.dropItem();
        } else if (item instanceof ItemRecord) {
            jukebox.setRecordItem(item);
            jukebox.play();
            player.getInventory().decreaseCount(player.getInventory().getHeldItemIndex());
        }
        return false;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        if (super.place(item, block, target, face, fx, fy, fz, player)) {
            this.createBlockEntity();
            return true;
        }
        return false;
    }

    private BlockEntity createBlockEntity() {
        CompoundTag nbt = new CompoundTag().putList(new ListTag("Items")).putString("id", "Jukebox").putInt("x", this.getFloorX()).putInt("y", this.getFloorY()).putInt("z", this.getFloorZ());
        return BlockEntity.createBlockEntity("Jukebox", this.level.getChunk(this.getFloorX() >> 4, this.getFloorZ() >> 4), nbt, new Object[0]);
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.DIRT_BLOCK_COLOR;
    }
}

