/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockLiquid;
import cn.nukkit.block.BlockWater;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.item.EntityPrimedTNT;
import cn.nukkit.event.block.BlockIgniteEvent;
import cn.nukkit.event.entity.EntityCombustByBlockEvent;
import cn.nukkit.event.entity.EntityDamageByBlockEvent;
import cn.nukkit.event.entity.EntityDamageEvent;
import cn.nukkit.item.Item;
import cn.nukkit.level.GameRule;
import cn.nukkit.level.Position;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

public class BlockLava
extends BlockLiquid {
    public BlockLava() {
        this(0);
    }

    public BlockLava(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 10;
    }

    @Override
    public int getLightLevel() {
        return 15;
    }

    @Override
    public String getName() {
        return "Lava";
    }

    @Override
    public void onEntityCollide(Entity entity) {
        entity.highestPosition -= (entity.highestPosition - entity.y) * 0.5;
        EntityCombustByBlockEvent ev = new EntityCombustByBlockEvent(this, entity, 15);
        Server.getInstance().getPluginManager().callEvent(ev);
        if (!ev.isCancelled() && entity.isAlive() && entity.noDamageTicks == 0) {
            entity.setOnFire(ev.getDuration());
        }
        if (!entity.hasEffect(12)) {
            entity.attack(new EntityDamageByBlockEvent(this, entity, EntityDamageEvent.DamageCause.LAVA, 4.0f));
        }
        super.onEntityCollide(entity);
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        boolean ret = this.getLevel().setBlock((Vector3)this, this, true, false);
        this.getLevel().scheduleUpdate(this, this.tickRate());
        return ret;
    }

    @Override
    public int onUpdate(int type) {
        int result;
        block6: {
            result = super.onUpdate(type);
            if (type != 2 || !this.level.gameRules.getBoolean(GameRule.DO_FIRE_TICK)) break block6;
            ThreadLocalRandom random = ThreadLocalRandom.current();
            int i = ((Random)random).nextInt(3);
            if (i > 0) {
                for (int k = 0; k < i; ++k) {
                    Position v = this.add(((Random)random).nextInt(3) - 1, 1.0, ((Random)random).nextInt(3) - 1);
                    Block block = this.getLevel().getBlock(v);
                    if (block.getId() == 0) {
                        if (!this.isSurroundingBlockFlammable(block)) continue;
                        BlockIgniteEvent e = new BlockIgniteEvent(block, this, null, BlockIgniteEvent.BlockIgniteCause.LAVA);
                        this.level.getServer().getPluginManager().callEvent(e);
                        if (!e.isCancelled()) {
                            Block fire = Block.get(51);
                            this.getLevel().setBlock((Vector3)v, fire, true);
                            this.getLevel().scheduleUpdate(fire, fire.tickRate());
                            return 2;
                        }
                        return 0;
                    }
                    if (!block.isSolid()) continue;
                    return 2;
                }
            } else {
                for (int k = 0; k < 3; ++k) {
                    Position v = this.add(((Random)random).nextInt(3) - 1, 0.0, ((Random)random).nextInt(3) - 1);
                    Block block = this.getLevel().getBlock(v);
                    if (block.up().getId() != 0 || block.getBurnChance() <= 0) continue;
                    BlockIgniteEvent e = new BlockIgniteEvent(block, this, null, BlockIgniteEvent.BlockIgniteCause.LAVA);
                    this.level.getServer().getPluginManager().callEvent(e);
                    if (e.isCancelled()) continue;
                    Block fire = Block.get(51);
                    this.getLevel().setBlock((Vector3)v, fire, true);
                    this.getLevel().scheduleUpdate(fire, fire.tickRate());
                }
            }
        }
        return result;
    }

    protected boolean isSurroundingBlockFlammable(Block block) {
        for (BlockFace face : BlockFace.values()) {
            if (block.getSide(face).getBurnChance() <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.LAVA_BLOCK_COLOR;
    }

    @Override
    public BlockLiquid getBlock(int meta) {
        return (BlockLiquid)Block.get(10, meta);
    }

    @Override
    public int tickRate() {
        return 30;
    }

    @Override
    public int getFlowDecayPerBlock() {
        if (this.level.getDimension() == 1) {
            return 1;
        }
        return 2;
    }

    @Override
    protected void checkForHarden() {
        Block colliding = null;
        for (int side = 1; side < 6; ++side) {
            Block blockSide = this.getSide(BlockFace.fromIndex(side));
            if (!(blockSide instanceof BlockWater) && !(blockSide.getLevelBlockAtLayer(1) instanceof BlockWater)) continue;
            colliding = blockSide;
            break;
        }
        if (colliding != null) {
            if (this.getDamage() == 0) {
                this.liquidCollide(colliding, Block.get(49));
            } else if (this.getDamage() <= 4) {
                this.liquidCollide(colliding, Block.get(4));
            }
        }
    }

    @Override
    protected void flowIntoBlock(Block block, int newFlowDecay) {
        if (block instanceof BlockWater) {
            ((BlockLiquid)block).liquidCollide(this, Block.get(1));
        } else {
            super.flowIntoBlock(block, newFlowDecay);
        }
    }

    @Override
    public void addVelocityToEntity(Entity entity, Vector3 vector) {
        if (!(entity instanceof EntityPrimedTNT)) {
            super.addVelocityToEntity(entity, vector);
        }
    }
}

