/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.event.block.BlockRedstoneEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.Faceable;

public class BlockLever
extends BlockFlowable
implements Faceable {
    public BlockLever() {
        this(0);
    }

    public BlockLever(int meta) {
        super(meta);
    }

    @Override
    public String getName() {
        return "Lever";
    }

    @Override
    public int getId() {
        return 69;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public double getHardness() {
        return 0.5;
    }

    @Override
    public double getResistance() {
        return 2.5;
    }

    @Override
    public Item toItem() {
        return new ItemBlock(this, (Integer)0);
    }

    @Override
    public Item[] getDrops(Item item) {
        return new Item[]{this.toItem()};
    }

    public boolean isPowerOn() {
        return (this.getDamage() & 8) > 0;
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        this.level.getServer().getPluginManager().callEvent(new BlockRedstoneEvent(this, this.isPowerOn() ? 15 : 0, this.isPowerOn() ? 0 : 15));
        this.setDamage(this.getDamage() ^ 8);
        boolean redstone = this.level.getServer().isRedstoneEnabled();
        this.getLevel().setBlock((Vector3)this, this, false, !redstone);
        this.getLevel().addLevelEvent(this.add(0.5, 0.5, 0.5), 3500, this.isPowerOn() ? 600 : 500);
        LeverOrientation orientation = LeverOrientation.byMetadata(this.isPowerOn() ? this.getDamage() ^ 8 : this.getDamage());
        BlockFace face = orientation.getFacing();
        if (redstone) {
            Block target = this.getSide(face.getOpposite());
            target.onUpdate(6);
            this.level.updateAroundRedstone(this.getLocation(), this.isPowerOn() ? face.getOpposite() : null);
            this.level.updateAroundRedstone(target.getLocation(), this.isPowerOn() ? face : null);
        }
        return true;
    }

    @Override
    @PowerNukkitDifference(info="Allows to be placed on walls", since="1.3.0.0-PN")
    public int onUpdate(int type) {
        int face;
        BlockFace blockFace;
        Block side;
        if (!(type != 1 || (side = this.getSide(blockFace = LeverOrientation.byMetadata(face = this.isPowerOn() ? this.getDamage() ^ 8 : this.getDamage()).getFacing().getOpposite())).isSolid() || side.getId() == 139 && blockFace == BlockFace.DOWN)) {
            this.level.useBreakOn(this);
        }
        return 0;
    }

    @Override
    @PowerNukkitDifference(info="Allows to be placed on walls", since="1.3.0.0-PN")
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        if (target.isNormalBlock() || target.getId() == 78 || target.getId() == 139 && face == BlockFace.UP) {
            this.setDamage(LeverOrientation.forFacings(face, player.getHorizontalFacing()).getMetadata());
            this.getLevel().setBlock((Vector3)block, this, true, true);
            return true;
        }
        return false;
    }

    @Override
    public boolean onBreak(Item item) {
        this.getLevel().setBlock((Vector3)this, Block.get(0), true, true);
        if (this.isPowerOn()) {
            BlockFace face = LeverOrientation.byMetadata(this.isPowerOn() ? this.getDamage() ^ 8 : this.getDamage()).getFacing();
            this.level.updateAround(this.getLocation().getSide(face.getOpposite()));
        }
        return true;
    }

    @Override
    public int getWeakPower(BlockFace side) {
        return this.isPowerOn() ? 15 : 0;
    }

    @Override
    public int getStrongPower(BlockFace side) {
        return !this.isPowerOn() ? 0 : (LeverOrientation.byMetadata(this.isPowerOn() ? this.getDamage() ^ 8 : this.getDamage()).getFacing() == side ? 15 : 0);
    }

    @Override
    public boolean isPowerSource() {
        return true;
    }

    @Override
    public int getWaterloggingLevel() {
        return 2;
    }

    @Override
    public boolean canBeFlowedInto() {
        return false;
    }

    @Override
    @PowerNukkitDifference(info="Fixed the directions", since="1.3.0.0-PN")
    public BlockFace getBlockFace() {
        return BlockFace.fromIndex(this.getDamage() & 7).getOpposite();
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.AIR_BLOCK_COLOR;
    }

    public static enum LeverOrientation {
        DOWN_X(0, "down_x", BlockFace.DOWN),
        EAST(1, "east", BlockFace.EAST),
        WEST(2, "west", BlockFace.WEST),
        SOUTH(3, "south", BlockFace.SOUTH),
        NORTH(4, "north", BlockFace.NORTH),
        UP_Z(5, "up_z", BlockFace.UP),
        UP_X(6, "up_x", BlockFace.UP),
        DOWN_Z(7, "down_z", BlockFace.DOWN);

        private static final LeverOrientation[] META_LOOKUP;
        private final int meta;
        private final String name;
        private final BlockFace facing;

        private LeverOrientation(int meta, String name, BlockFace face) {
            this.meta = meta;
            this.name = name;
            this.facing = face;
        }

        public int getMetadata() {
            return this.meta;
        }

        public BlockFace getFacing() {
            return this.facing;
        }

        public String toString() {
            return this.name;
        }

        public static LeverOrientation byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public static LeverOrientation forFacings(BlockFace clickedSide, BlockFace playerDirection) {
            switch (clickedSide) {
                case DOWN: {
                    switch (playerDirection.getAxis()) {
                        case X: {
                            return DOWN_X;
                        }
                        case Z: {
                            return DOWN_Z;
                        }
                    }
                    throw new IllegalArgumentException("Invalid entityFacing " + (Object)((Object)playerDirection) + " for facing " + (Object)((Object)clickedSide));
                }
                case UP: {
                    switch (playerDirection.getAxis()) {
                        case X: {
                            return UP_X;
                        }
                        case Z: {
                            return UP_Z;
                        }
                    }
                    throw new IllegalArgumentException("Invalid entityFacing " + (Object)((Object)playerDirection) + " for facing " + (Object)((Object)clickedSide));
                }
                case NORTH: {
                    return NORTH;
                }
                case SOUTH: {
                    return SOUTH;
                }
                case WEST: {
                    return WEST;
                }
                case EAST: {
                    return EAST;
                }
            }
            throw new IllegalArgumentException("Invalid facing: " + (Object)((Object)clickedSide));
        }

        public String getName() {
            return this.name;
        }

        static {
            META_LOOKUP = new LeverOrientation[LeverOrientation.values().length];
            LeverOrientation[] leverOrientationArray = LeverOrientation.values();
            int n = leverOrientationArray.length;
            for (int i = 0; i < n; ++i) {
                LeverOrientation face;
                LeverOrientation.META_LOOKUP[face.getMetadata()] = face = leverOrientationArray[i];
            }
        }
    }
}

