/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockAir;
import cn.nukkit.block.BlockPistonHead;
import cn.nukkit.block.BlockSolidMeta;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.blockentity.BlockEntityMovingBlock;
import cn.nukkit.blockentity.BlockEntityPistonArm;
import cn.nukkit.event.block.BlockPistonEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.level.GlobalBlockPalette;
import cn.nukkit.level.Position;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.BlockVector3;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.utils.Faceable;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public abstract class BlockPistonBase
extends BlockSolidMeta
implements Faceable {
    public boolean sticky;

    public BlockPistonBase() {
        this(0);
    }

    public BlockPistonBase(int meta) {
        super(meta);
    }

    @Override
    public double getResistance() {
        return 2.5;
    }

    @Override
    public double getHardness() {
        return 0.5;
    }

    @Override
    public int getWaterloggingLevel() {
        return 1;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        if (Math.abs((double)player.getFloorX() - this.x) <= 1.0 && Math.abs((double)player.getFloorZ() - this.z) <= 1.0) {
            double y = player.y + (double)player.getEyeHeight();
            if (y - this.y > 2.0) {
                this.setDamage(BlockFace.UP.getIndex());
            } else if (this.y - y > 0.0) {
                this.setDamage(BlockFace.DOWN.getIndex());
            } else {
                this.setDamage(player.getHorizontalFacing().getIndex());
            }
        } else {
            this.setDamage(player.getHorizontalFacing().getIndex());
        }
        if (this.level.getBlockEntity(this) != null) {
            BlockEntity blockEntity = this.level.getBlockEntity(this);
            Server.getInstance().getLogger().warning("Found unused BlockEntity at world=" + blockEntity.getLevel().getName() + " x=" + blockEntity.getX() + " y=" + blockEntity.getY() + " z=" + blockEntity.getZ() + " whilst attempting to place piston, closing it.");
            blockEntity.saveNBT();
            blockEntity.close();
        }
        this.level.setBlock((Vector3)block, this, true, true);
        CompoundTag nbt = new CompoundTag("").putString("id", "PistonArm").putInt("x", (int)this.x).putInt("y", (int)this.y).putInt("z", (int)this.z).putInt("facing", this.getBlockFace().getIndex()).putBoolean("Sticky", this.sticky);
        BlockEntityPistonArm piston = (BlockEntityPistonArm)BlockEntity.createBlockEntity("PistonArm", this.level.getChunk(this.getChunkX(), this.getChunkZ()), nbt, new Object[0]);
        piston.powered = this.isPowered();
        this.checkState(piston.powered);
        return true;
    }

    @Override
    public boolean onBreak(Item item) {
        this.level.setBlock((Vector3)this, new BlockAir(), true, true);
        Block block = this.getSide(this.getBlockFace());
        if (block instanceof BlockPistonHead && ((BlockPistonHead)block).getBlockFace() == this.getBlockFace()) {
            block.onBreak(item);
        }
        return true;
    }

    public boolean isExtended() {
        BlockFace face = this.getBlockFace();
        Block block = this.getSide(face);
        return block instanceof BlockPistonHead && ((BlockPistonHead)block).getBlockFace() == face;
    }

    @Override
    public int onUpdate(int type) {
        if (type != 1 && type != 6 && type != 3) {
            return 0;
        }
        if (!this.level.getServer().isRedstoneEnabled()) {
            return 0;
        }
        BlockEntity blockEntity = this.level.getBlockEntity(this);
        if (blockEntity instanceof BlockEntityPistonArm) {
            BlockEntityPistonArm arm = (BlockEntityPistonArm)blockEntity;
            boolean powered = this.isPowered();
            if (arm.state % 2 == 0 && arm.powered != powered && this.checkState(powered)) {
                arm.powered = powered;
                if (arm.chunk != null) {
                    arm.chunk.setChanged();
                }
            }
        }
        return type;
    }

    private boolean checkState(Boolean isPowered) {
        if (!this.level.getServer().isRedstoneEnabled()) {
            return false;
        }
        if (isPowered == null) {
            isPowered = this.isPowered();
        }
        if (isPowered.booleanValue() && !this.isExtended()) {
            if (!this.doMove(true)) {
                return false;
            }
            this.getLevel().addLevelSoundEvent(this, 84);
            return true;
        }
        if (!isPowered.booleanValue() && this.isExtended()) {
            if (!this.doMove(false)) {
                return false;
            }
            this.getLevel().addLevelSoundEvent(this, 83);
            return true;
        }
        return false;
    }

    private boolean isPowered() {
        BlockFace face = this.getBlockFace();
        for (BlockFace side : BlockFace.values()) {
            if (side == face) continue;
            Block b = this.getSide(side);
            if (b.getId() == 55 && b.getDamage() > 0) {
                return true;
            }
            if (!this.level.isSidePowered(b, side)) continue;
            return true;
        }
        return false;
    }

    private boolean doMove(boolean extending) {
        BlockFace direction = this.getBlockFace();
        BlocksCalculator calculator = new BlocksCalculator(extending);
        boolean canMove = calculator.canMove();
        if (!canMove && extending) {
            return false;
        }
        List<BlockVector3> attached = Collections.emptyList();
        BlockPistonEvent event = new BlockPistonEvent(this, direction, calculator.getBlocksToMove(), calculator.getBlocksToDestroy(), extending);
        this.level.getServer().getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            return false;
        }
        if (canMove && (this.sticky || extending)) {
            List<Block> destroyBlocks = calculator.getBlocksToDestroy();
            for (int i = destroyBlocks.size() - 1; i >= 0; --i) {
                Block block = destroyBlocks.get(i);
                this.level.useBreakOn(block, null, null, false);
            }
            List<Block> newBlocks = calculator.getBlocksToMove();
            attached = newBlocks.stream().map(Vector3::asBlockVector3).collect(Collectors.toList());
            BlockFace side = extending ? direction : direction.getOpposite();
            ArrayList<CompoundTag> tags = new ArrayList<CompoundTag>();
            for (Block oldBlock : newBlocks) {
                CompoundTag tag = new CompoundTag();
                BlockEntity be = this.level.getBlockEntity(oldBlock);
                if (be != null && !(be instanceof BlockEntityMovingBlock)) {
                    be.saveNBT();
                    tag = new CompoundTag(be.namedTag.getTags());
                    be.close();
                }
                tags.add(tag);
            }
            int i = 0;
            for (Block newBlock : newBlocks) {
                Position oldPos = newBlock.add(0.0);
                newBlock.position(newBlock.add(0.0).getSide(side));
                this.level.setBlock((Vector3)newBlock, Block.get(250), true);
                CompoundTag nbt = BlockEntity.getDefaultCompound(newBlock, "MovingBlock").putInt("pistonPosX", this.getFloorX()).putInt("pistonPosY", this.getFloorY()).putInt("pistonPosZ", this.getFloorZ()).putCompound("movingBlock", new CompoundTag().putInt("id", newBlock.getId()).putInt("meta", newBlock.getDamage()).putShort("val", newBlock.getDamage()).putString("name", GlobalBlockPalette.getName(newBlock.getId())));
                if (!((CompoundTag)tags.get(i)).isEmpty()) {
                    nbt.putCompound("movingEntity", (CompoundTag)tags.get(i));
                }
                BlockEntity.createBlockEntity("MovingBlock", (Position)newBlock, nbt, new Object[0]);
                if (this.level.getBlockIdAt(oldPos.getFloorX(), oldPos.getFloorY(), oldPos.getFloorZ()) != 250) {
                    this.level.setBlock(oldPos, Block.get(0));
                }
                ++i;
            }
        }
        if (extending) {
            this.level.setBlock(this.getSide(direction), this.createHead(this.getDamage()));
        }
        BlockEntityPistonArm blockEntity = (BlockEntityPistonArm)this.level.getBlockEntity(this);
        blockEntity.move(extending, attached);
        return true;
    }

    protected BlockPistonHead createHead(int damage) {
        return (BlockPistonHead)Block.get(this.getPistonHeadBlockId(), damage);
    }

    public abstract int getPistonHeadBlockId();

    public static boolean canPush(Block block, BlockFace face, boolean destroyBlocks, boolean extending) {
        if (block.getY() >= 0.0 && (face != BlockFace.DOWN || block.getY() != 0.0) && block.getY() <= 255.0 && (face != BlockFace.UP || block.getY() != 255.0)) {
            if (extending && !block.canBePushed() || !extending && !block.canBePulled()) {
                return false;
            }
            if (block.breaksWhenMoved()) {
                return destroyBlocks || block.sticksToPiston();
            }
            BlockEntity be = block.level.getBlockEntity(block);
            return be == null || be.isMovable();
        }
        return false;
    }

    @Override
    public Item toItem() {
        return new ItemBlock(this, (Integer)0);
    }

    @Override
    public BlockFace getBlockFace() {
        BlockFace face = BlockFace.fromIndex(this.getDamage());
        return face.getHorizontalIndex() >= 0 ? face.getOpposite() : face;
    }

    public class BlocksCalculator {
        private final Vector3 pistonPos;
        private Vector3 armPos;
        private final Block blockToMove;
        private final BlockFace moveDirection;
        private final boolean extending;
        private final List<Block> toMove = new ArrayList<Block>();
        private final List<Block> toDestroy = new ArrayList<Block>();

        public BlocksCalculator(boolean extending) {
            this.pistonPos = BlockPistonBase.this.getLocation();
            this.extending = extending;
            BlockFace face = BlockPistonBase.this.getBlockFace();
            if (!extending) {
                this.armPos = this.pistonPos.getSide(face);
            }
            if (extending) {
                this.moveDirection = face;
                this.blockToMove = BlockPistonBase.this.getSide(face);
            } else {
                this.moveDirection = face.getOpposite();
                this.blockToMove = BlockPistonBase.this.sticky ? BlockPistonBase.this.getSide(face, 2) : null;
            }
        }

        public boolean canMove() {
            if (!BlockPistonBase.this.sticky && !this.extending) {
                return true;
            }
            this.toMove.clear();
            this.toDestroy.clear();
            Block block = this.blockToMove;
            if (!BlockPistonBase.canPush(block, this.moveDirection, true, this.extending)) {
                return false;
            }
            if (block.breaksWhenMoved()) {
                if (this.extending || block.sticksToPiston()) {
                    this.toDestroy.add(this.blockToMove);
                }
                return true;
            }
            if (!this.addBlockLine(this.blockToMove, this.blockToMove.getSide(this.moveDirection.getOpposite()))) {
                return false;
            }
            for (int i = 0; i < this.toMove.size(); ++i) {
                Block b = this.toMove.get(i);
                int blockId = b.getId();
                if (blockId != 165 && blockId != 475 || this.addBranchingBlocks(b)) continue;
                return false;
            }
            return true;
        }

        private boolean addBlockLine(Block origin, Block from) {
            int stickedCount;
            Block block = origin.clone();
            if (block.getId() == 0) {
                return true;
            }
            if (block.getId() == 165 && from.getId() == 475 || block.getId() == 475 && from.getId() == 165) {
                return true;
            }
            if (!BlockPistonBase.canPush(origin, this.moveDirection, false, this.extending)) {
                return true;
            }
            if (origin.equals(this.pistonPos)) {
                return true;
            }
            if (this.toMove.contains(origin)) {
                return true;
            }
            if (this.toMove.size() >= 12) {
                return false;
            }
            this.toMove.add(block);
            int count = 1;
            ArrayList<Block> sticked = new ArrayList<Block>();
            while (block.getId() == 165 && (block = origin.getSide(this.moveDirection.getOpposite(), count)).getId() != 0 && BlockPistonBase.canPush(block, this.moveDirection, false, this.extending) && !block.equals(this.pistonPos)) {
                if (block.breaksWhenMoved() && block.sticksToPiston()) {
                    this.toDestroy.add(block);
                    break;
                }
                if (++count + this.toMove.size() > 12) {
                    return false;
                }
                sticked.add(block);
            }
            if ((stickedCount = sticked.size()) > 0) {
                this.toMove.addAll(Lists.reverse(sticked));
            }
            int step = 1;
            while (true) {
                Block nextBlock;
                int index;
                if ((index = this.toMove.indexOf(nextBlock = origin.getSide(this.moveDirection, step))) > -1) {
                    this.reorderListAtCollision(stickedCount, index);
                    for (int i = 0; i <= index + stickedCount; ++i) {
                        Block b = this.toMove.get(i);
                        if (b.getId() != 165 || this.addBranchingBlocks(b)) continue;
                        return false;
                    }
                    return true;
                }
                if (nextBlock.getId() == 0 || nextBlock.equals(this.armPos)) {
                    return true;
                }
                if (!BlockPistonBase.canPush(nextBlock, this.moveDirection, true, this.extending) || nextBlock.equals(this.pistonPos)) {
                    return false;
                }
                if (nextBlock.breaksWhenMoved()) {
                    this.toDestroy.add(nextBlock);
                    return true;
                }
                if (this.toMove.size() >= 12) {
                    return false;
                }
                this.toMove.add(nextBlock);
                ++stickedCount;
                ++step;
            }
        }

        private void reorderListAtCollision(int count, int index) {
            ArrayList<Block> list = new ArrayList<Block>(this.toMove.subList(0, index));
            ArrayList<Block> list1 = new ArrayList<Block>(this.toMove.subList(this.toMove.size() - count, this.toMove.size()));
            ArrayList<Block> list2 = new ArrayList<Block>(this.toMove.subList(index, this.toMove.size() - count));
            this.toMove.clear();
            this.toMove.addAll(list);
            this.toMove.addAll(list1);
            this.toMove.addAll(list2);
        }

        private boolean addBranchingBlocks(Block block) {
            for (BlockFace face : BlockFace.values()) {
                if (face.getAxis() == this.moveDirection.getAxis() || this.addBlockLine(block.getSide(face), block)) continue;
                return false;
            }
            return true;
        }

        public List<Block> getBlocksToMove() {
            return this.toMove;
        }

        public List<Block> getBlocksToDestroy() {
            return this.toDestroy;
        }
    }
}

