/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockFallable;
import cn.nukkit.event.block.BlockFadeEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemSnowball;
import cn.nukkit.level.GameRule;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;

public class BlockSnowLayer
extends BlockFallable {
    private int meta;

    public BlockSnowLayer() {
        this(0);
    }

    public BlockSnowLayer(int meta) {
        this.meta = meta;
    }

    @Override
    public final int getFullId() {
        return (this.getId() << 4) + this.getDamage();
    }

    @Override
    public final int getDamage() {
        return this.meta;
    }

    @Override
    public final void setDamage(int meta) {
        this.meta = meta;
    }

    @Override
    public String getName() {
        return "Top Snow";
    }

    @Override
    public int getId() {
        return 78;
    }

    @Override
    public double getHardness() {
        return 0.1;
    }

    @Override
    public double getResistance() {
        return 0.5;
    }

    @Override
    public int getToolType() {
        return 2;
    }

    @Override
    public boolean canBeReplaced() {
        return (this.getDamage() & 7) != 7;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        if (this.canSurvive()) {
            this.getLevel().setBlock((Vector3)block, this, true);
            return true;
        }
        return false;
    }

    private boolean canSurvive() {
        Block below = this.down();
        return below.getId() != 79 && below.getId() != 174 && below.getId() != 207 && (below.isSolid() || (this.getDamage() & 7) == 7);
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1) {
            if ((this.getDamage() & 7) != 7 || this.up().getId() != 78) {
                super.onUpdate(type);
            }
            if (this.level.getBlockIdAt(this.getFloorX(), this.getFloorY(), this.getFloorZ()) == 78 && !this.canSurvive()) {
                this.level.useBreakOn(this, null, null, true);
                if (this.level.getGameRules().getBoolean(GameRule.DO_TILE_DROPS)) {
                    this.level.dropItem(this, this.toItem());
                }
            }
        } else if (type == 2 && this.getLevel().getBlockLightAt((int)this.x, (int)this.y, (int)this.z) >= 10) {
            BlockFadeEvent event = new BlockFadeEvent(this, (this.getDamage() & 7) > 0 ? BlockSnowLayer.get(78, this.getDamage() - 1) : BlockSnowLayer.get(0));
            this.level.getServer().getPluginManager().callEvent(event);
            if (!event.isCancelled()) {
                this.level.setBlock((Vector3)this, event.getNewState(), true);
            }
            return 1;
        }
        return 0;
    }

    @Override
    public Item toItem() {
        return new ItemSnowball();
    }

    @Override
    public Item[] getDrops(Item item) {
        if (item.isShovel() && item.getTier() >= 1) {
            Item drop = this.toItem();
            int height = this.getDamage() & 7;
            drop.setCount(height < 3 ? 1 : (height < 5 ? 2 : (height == 7 ? 4 : 3)));
            return new Item[]{drop};
        }
        return new Item[0];
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.SNOW_BLOCK_COLOR;
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }

    @Override
    public boolean isTransparent() {
        return (this.getDamage() & 7) != 7;
    }

    @Override
    public boolean canBeFlowedInto() {
        return true;
    }

    @Override
    public boolean isSolid() {
        return (this.getDamage() & 7) == 7;
    }

    @Override
    public double getMaxY() {
        int height = this.getDamage() & 7;
        return height < 3 ? this.y : (height == 7 ? this.y + 1.0 : this.y + 0.5);
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        if (item.isShovel()) {
            item.useOn(this);
            this.level.useBreakOn(this, item.clone().clearNamedTag(), null, true);
            return true;
        }
        if (item.getId() == 78) {
            if ((this.getDamage() & 7) != 7) {
                this.setDamage(this.getDamage() + 1);
                this.level.setBlock((Vector3)this, this, true);
                if (player != null && (player.gamemode & 1) == 0) {
                    --item.count;
                }
                return true;
            }
            this.level.setBlock((Vector3)this, this, true);
        }
        return false;
    }
}

