/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.entity.Entity;
import cn.nukkit.event.block.BlockGrowEvent;
import cn.nukkit.event.block.BlockHarvestEvent;
import cn.nukkit.event.entity.EntityDamageByBlockEvent;
import cn.nukkit.event.entity.EntityDamageEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemSweetBerries;
import cn.nukkit.level.Position;
import cn.nukkit.level.Sound;
import cn.nukkit.level.particle.BoneMealParticle;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.MathHelper;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;
import java.util.concurrent.ThreadLocalRandom;

public class BlockSweetBerryBush
extends BlockFlowable {
    public BlockSweetBerryBush() {
        this(0);
    }

    public BlockSweetBerryBush(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 462;
    }

    @Override
    public String getName() {
        return "Sweet Berry Bush";
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.FOLIAGE_BLOCK_COLOR;
    }

    @Override
    public int getBurnChance() {
        return 30;
    }

    @Override
    public int getBurnAbility() {
        return 60;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public double getHardness() {
        return this.getDamage() == 0 ? 0.0 : 0.25;
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        int age = MathHelper.clamp(this.getDamage(), 0, 3);
        if (age < 3 && item.isFertilizer()) {
            BlockSweetBerryBush block = (BlockSweetBerryBush)this.clone();
            block.setDamage(block.getDamage() + 1);
            if (block.getDamage() > 3) {
                block.setDamage(3);
            }
            BlockGrowEvent ev = new BlockGrowEvent(this, block);
            Server.getInstance().getPluginManager().callEvent(ev);
            if (ev.isCancelled()) {
                return false;
            }
            this.getLevel().setBlock((Vector3)this, ev.getNewState(), false, true);
            this.level.addParticle(new BoneMealParticle(this));
            if (player != null && (player.gamemode & 1) == 0) {
                --item.count;
            }
            return true;
        }
        if (age < 2) {
            return true;
        }
        int amount = 1 + ThreadLocalRandom.current().nextInt(2);
        if (age == 3) {
            ++amount;
        }
        BlockHarvestEvent event = new BlockHarvestEvent(this, new BlockSweetBerryBush(1), new Item[]{new ItemSweetBerries((Integer)0, amount)});
        this.getLevel().getServer().getPluginManager().callEvent(event);
        if (!event.isCancelled()) {
            this.getLevel().setBlock((Vector3)this, event.getNewState(), true, true);
            Item[] drops = event.getDrops();
            if (drops != null) {
                Position dropPos = this.add(0.5, 0.5, 0.5);
                for (Item drop : drops) {
                    if (drop == null) continue;
                    this.getLevel().dropItem(dropPos, drop);
                }
            }
        }
        return true;
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1) {
            if (this.down().isTransparent()) {
                this.getLevel().useBreakOn(this);
                return 1;
            }
        } else if (type == 2) {
            BlockGrowEvent event;
            if (this.getDamage() < 3 && ThreadLocalRandom.current().nextInt(5) == 0 && this.getLevel().getFullLight(this.add(0.0, 1.0, 0.0)) >= 9 && !(event = new BlockGrowEvent(this, Block.get(this.getId(), this.getDamage() + 1))).isCancelled()) {
                this.getLevel().setBlock((Vector3)this, event.getNewState(), true, true);
            }
            return type;
        }
        return 0;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        if (target.getId() == 462 || block.getId() != 0) {
            return false;
        }
        Block down = this.down();
        if (down.getId() == 2 || down.getId() == 3 || down.getId() == 243) {
            this.getLevel().setBlock((Vector3)block, this, true);
            return true;
        }
        return false;
    }

    @Override
    public boolean hasEntityCollision() {
        return this.getDamage() > 0;
    }

    @Override
    public void onEntityCollide(Entity entity) {
        if (this.getDamage() > 0 && entity.positionChanged && !entity.isSneaking() && ThreadLocalRandom.current().nextInt(20) == 0 && entity.attack(new EntityDamageByBlockEvent(this, entity, EntityDamageEvent.DamageCause.CONTACT, 1.0f))) {
            this.getLevel().addSound(entity, Sound.BLOCK_SWEET_BERRY_BUSH_HURT);
        }
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBox() {
        return this.getDamage() > 0 ? this : null;
    }

    @Override
    public Item[] getDrops(Item item) {
        int age = MathHelper.clamp(this.getDamage(), 0, 3);
        int amount = 1 + ThreadLocalRandom.current().nextInt(2);
        if (age == 3) {
            ++amount;
        }
        return new Item[]{new ItemSweetBerries((Integer)0, amount)};
    }

    @Override
    public Item toItem() {
        return new ItemSweetBerries();
    }
}

