/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemSeedsWheat;
import cn.nukkit.level.particle.BoneMealParticle;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;
import java.util.concurrent.ThreadLocalRandom;

public class BlockTallGrass
extends BlockFlowable {
    public BlockTallGrass() {
        this(1);
    }

    public BlockTallGrass(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 31;
    }

    @Override
    public String getName() {
        String[] names = new String[]{"Grass", "Grass", "Fern", "Fern"};
        return names[this.getDamage() & 3];
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean canBeReplaced() {
        return true;
    }

    @Override
    public int getBurnChance() {
        return 60;
    }

    @Override
    public int getBurnAbility() {
        return 100;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        Block down = this.down();
        if (down.getId() == 2 || down.getId() == 3 || down.getId() == 243) {
            this.getLevel().setBlock((Vector3)block, this, true);
            return true;
        }
        return false;
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1 && this.down().isTransparent()) {
            this.getLevel().useBreakOn(this);
            return 1;
        }
        return 0;
    }

    @Override
    public boolean onActivate(Item item, Player player) {
        if (item.isFertilizer()) {
            Block up = this.up();
            if (up.getId() == 0) {
                int meta;
                switch (this.getDamage()) {
                    case 0: 
                    case 1: {
                        meta = 2;
                        break;
                    }
                    case 2: 
                    case 3: {
                        meta = 3;
                        break;
                    }
                    default: {
                        meta = -1;
                    }
                }
                if (meta != -1) {
                    if (player != null && (player.gamemode & 1) == 0) {
                        --item.count;
                    }
                    this.level.addParticle(new BoneMealParticle(this));
                    this.level.setBlock((Vector3)this, BlockTallGrass.get(175, meta), true, false);
                    this.level.setBlock((Vector3)up, BlockTallGrass.get(175, meta ^ 8), true);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public Item[] getDrops(Item item) {
        boolean dropSeeds;
        boolean bl = dropSeeds = ThreadLocalRandom.current().nextInt(10) == 0;
        if (item.isShears()) {
            if (dropSeeds) {
                return new Item[]{new ItemSeedsWheat(), Item.get(31, this.getDamage(), 1)};
            }
            return new Item[]{Item.get(31, this.getDamage(), 1)};
        }
        if (dropSeeds) {
            return new Item[]{new ItemSeedsWheat()};
        }
        return new Item[0];
    }

    @Override
    public int getToolType() {
        return 5;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.FOLIAGE_BLOCK_COLOR;
    }
}

