/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockFence;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.Faceable;

public class BlockTorch
extends BlockFlowable
implements Faceable {
    private static final int[] faces = new int[]{0, 5, 4, 3, 2, 1};
    private static final int[] faces2 = new int[]{0, 4, 5, 2, 3, 0, 0};

    public BlockTorch() {
        this(0);
    }

    public BlockTorch(int meta) {
        super(meta);
    }

    @Override
    public String getName() {
        return "Torch";
    }

    @Override
    public int getId() {
        return 50;
    }

    @Override
    public int getLightLevel() {
        return 14;
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1) {
            Block below = this.down();
            int side = this.getDamage();
            Block block = this.getSide(BlockFace.fromIndex(faces2[side]));
            int id = block.getId();
            if (block.isTransparent() && (side != 0 || !(below instanceof BlockFence) && below.getId() != 139) && id != 20 && id != 241) {
                this.getLevel().useBreakOn(this);
                return 1;
            }
        }
        return 0;
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        int side = faces[face.getIndex()];
        int bid = this.getSide(BlockFace.fromIndex(faces2[side])).getId();
        if (!(target.isTransparent() && bid != 20 && bid != 241 || face == BlockFace.DOWN)) {
            this.setDamage(side);
            this.getLevel().setBlock((Vector3)block, this, true, true);
            return true;
        }
        Block below = this.down();
        if (!below.isTransparent() || below instanceof BlockFence || below.getId() == 139 || below.getId() == 20 || below.getId() == 241) {
            this.setDamage(0);
            this.getLevel().setBlock((Vector3)block, this, true, true);
            return true;
        }
        return false;
    }

    @Override
    public Item toItem() {
        return new ItemBlock(this, (Integer)0);
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.AIR_BLOCK_COLOR;
    }

    @Override
    public BlockFace getBlockFace() {
        return this.getBlockFace(this.getDamage() & 7);
    }

    public BlockFace getBlockFace(int meta) {
        switch (meta) {
            case 1: {
                return BlockFace.EAST;
            }
            case 2: {
                return BlockFace.WEST;
            }
            case 3: {
                return BlockFace.SOUTH;
            }
            case 4: {
                return BlockFace.NORTH;
            }
        }
        return BlockFace.UP;
    }
}

