/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.entity.Entity;
import cn.nukkit.event.block.BlockGrowEvent;
import cn.nukkit.event.block.BlockSpreadEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.SimpleAxisAlignedBB;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

public class BlockVine
extends BlockTransparentMeta {
    public BlockVine(int meta) {
        super(meta);
    }

    public BlockVine() {
        this(0);
    }

    @Override
    public String getName() {
        return "Vines";
    }

    @Override
    public int getId() {
        return 106;
    }

    @Override
    public double getHardness() {
        return 0.2;
    }

    @Override
    public double getResistance() {
        return 1.0;
    }

    @Override
    public boolean canPassThrough() {
        return true;
    }

    @Override
    public boolean hasEntityCollision() {
        return true;
    }

    @Override
    public boolean canBeReplaced() {
        return true;
    }

    @Override
    public boolean canBeClimbed() {
        return true;
    }

    @Override
    public int getWaterloggingLevel() {
        return 1;
    }

    @Override
    public boolean canBeFlowedInto() {
        return true;
    }

    @Override
    public void onEntityCollide(Entity entity) {
        entity.resetFallDistance();
        entity.onGround = true;
    }

    @Override
    public boolean isSolid() {
        return false;
    }

    @Override
    protected AxisAlignedBB recalculateBoundingBox() {
        boolean flag;
        double f1 = 1.0;
        double f2 = 1.0;
        double f3 = 1.0;
        double f4 = 0.0;
        double f5 = 0.0;
        double f6 = 0.0;
        boolean bl = flag = this.getDamage() > 0;
        if ((this.getDamage() & 2) > 0) {
            f4 = Math.max(f4, 0.0625);
            f1 = 0.0;
            f2 = 0.0;
            f5 = 1.0;
            f3 = 0.0;
            f6 = 1.0;
            flag = true;
        }
        if ((this.getDamage() & 8) > 0) {
            f1 = Math.min(f1, 0.9375);
            f4 = 1.0;
            f2 = 0.0;
            f5 = 1.0;
            f3 = 0.0;
            f6 = 1.0;
            flag = true;
        }
        if ((this.getDamage() & 1) > 0) {
            f3 = Math.min(f3, 0.9375);
            f6 = 1.0;
            f1 = 0.0;
            f4 = 1.0;
            f2 = 0.0;
            f5 = 1.0;
            flag = true;
        }
        if (!flag && this.up().isSolid()) {
            f2 = Math.min(f2, 0.9375);
            f5 = 1.0;
            f1 = 0.0;
            f4 = 1.0;
            f3 = 0.0;
            f6 = 1.0;
        }
        return new SimpleAxisAlignedBB(this.x + f1, this.y + f2, this.z + f3, this.x + f4, this.y + f5, this.z + f6);
    }

    @Override
    public boolean place(Item item, Block block, Block target, BlockFace face, double fx, double fy, double fz, Player player) {
        if (block.getId() != 106 && target.isSolid() && face.getHorizontalIndex() != -1) {
            this.setDamage(BlockVine.getMetaFromFace(face.getOpposite()));
            this.getLevel().setBlock((Vector3)block, this, true, true);
            return true;
        }
        return false;
    }

    @Override
    public Item[] getDrops(Item item) {
        if (item.isShears()) {
            return new Item[]{this.toItem()};
        }
        return new Item[0];
    }

    @Override
    public Item toItem() {
        return new ItemBlock(this, (Integer)0);
    }

    @Override
    public int onUpdate(int type) {
        ThreadLocalRandom random;
        if (type == 1) {
            Block up;
            if (!(this.getSide(this.getFace()).isSolid() || (up = this.up()).getId() == this.getId() && up.getDamage() == this.getDamage())) {
                this.getLevel().useBreakOn(this, null, null, true);
                return 1;
            }
        } else if (type == 2 && ((Random)(random = ThreadLocalRandom.current())).nextInt(4) == 0) {
            Block below;
            int id;
            BlockFace face = BlockFace.random(random);
            Block block = this.getSide(face);
            int faceMeta = BlockVine.getMetaFromFace(face);
            int meta = this.getDamage();
            if (this.y < 255.0 && face == BlockFace.UP && block.getId() == 0) {
                if (this.canSpread()) {
                    for (BlockFace horizontalFace : BlockFace.Plane.HORIZONTAL) {
                        if (!((Random)random).nextBoolean() && this.getSide(horizontalFace).getSide(face).isSolid()) continue;
                        meta &= ~BlockVine.getMetaFromFace(horizontalFace);
                    }
                    this.putVineOnHorizontalFace(block, meta, this);
                }
            } else if (face.getHorizontalIndex() != -1 && (meta & faceMeta) != faceMeta) {
                if (this.canSpread()) {
                    if (block.getId() == 0) {
                        boolean onCcw;
                        BlockFace cwFace = face.rotateY();
                        BlockFace ccwFace = face.rotateYCCW();
                        Block cwBlock = block.getSide(cwFace);
                        Block ccwBlock = block.getSide(ccwFace);
                        int cwMeta = BlockVine.getMetaFromFace(cwFace);
                        int ccwMeta = BlockVine.getMetaFromFace(ccwFace);
                        boolean onCw = (meta & cwMeta) == cwMeta;
                        boolean bl = onCcw = (meta & ccwMeta) == ccwMeta;
                        if (onCw && cwBlock.isSolid()) {
                            this.putVine(block, BlockVine.getMetaFromFace(cwFace), this);
                        } else if (onCcw && ccwBlock.isSolid()) {
                            this.putVine(block, BlockVine.getMetaFromFace(ccwFace), this);
                        } else if (onCw && cwBlock.getId() == 0 && this.getSide(cwFace).isSolid()) {
                            this.putVine(cwBlock, BlockVine.getMetaFromFace(face.getOpposite()), this);
                        } else if (onCcw && ccwBlock.getId() == 0 && this.getSide(ccwFace).isSolid()) {
                            this.putVine(ccwBlock, BlockVine.getMetaFromFace(face.getOpposite()), this);
                        } else if (block.up().isSolid()) {
                            this.putVine(block, 0, this);
                        }
                    } else if (!block.isTransparent()) {
                        this.putVine(this, meta |= BlockVine.getMetaFromFace(face), null);
                    }
                }
            } else if (this.y > 0.0 && ((id = (below = this.down()).getId()) == 0 || id == 106)) {
                for (BlockFace horizontalFace : BlockFace.Plane.HORIZONTAL) {
                    if (!((Random)random).nextBoolean()) continue;
                    meta &= ~BlockVine.getMetaFromFace(horizontalFace);
                }
                this.putVineOnHorizontalFace(below, below.getDamage() | meta, id == 0 ? this : null);
            }
            return 2;
        }
        return 0;
    }

    private boolean canSpread() {
        int blockX = this.getFloorX();
        int blockY = this.getFloorY();
        int blockZ = this.getFloorZ();
        int count = 0;
        for (int x = blockX - 4; x <= blockX + 4; ++x) {
            for (int z = blockZ - 4; z <= blockZ + 4; ++z) {
                for (int y = blockY - 1; y <= blockY + 1; ++y) {
                    if (this.level.getBlock(x, y, z).getId() != 106 || ++count < 5) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private void putVine(Block block, int meta, Block source) {
        if (block.getId() == 106 && block.getDamage() == meta) {
            return;
        }
        Block vine = BlockVine.get(106, meta);
        BlockGrowEvent event = source != null ? new BlockSpreadEvent(block, source, vine) : new BlockGrowEvent(block, vine);
        this.level.getServer().getPluginManager().callEvent(event);
        if (!event.isCancelled()) {
            this.level.setBlock((Vector3)block, vine, true);
        }
    }

    private void putVineOnHorizontalFace(Block block, int meta, Block source) {
        if (block.getId() == 106 && block.getDamage() == meta) {
            return;
        }
        boolean isOnHorizontalFace = false;
        for (BlockFace face : BlockFace.Plane.HORIZONTAL) {
            int faceMeta = BlockVine.getMetaFromFace(face);
            if ((meta & faceMeta) != faceMeta) continue;
            isOnHorizontalFace = true;
            break;
        }
        if (isOnHorizontalFace) {
            this.putVine(block, meta, source);
        }
    }

    private BlockFace getFace() {
        int meta = this.getDamage();
        if ((meta & 1) > 0) {
            return BlockFace.SOUTH;
        }
        if ((meta & 2) > 0) {
            return BlockFace.WEST;
        }
        if ((meta & 4) > 0) {
            return BlockFace.NORTH;
        }
        if ((meta & 8) > 0) {
            return BlockFace.EAST;
        }
        return BlockFace.UP;
    }

    private static int getMetaFromFace(BlockFace face) {
        switch (face) {
            default: {
                return 1;
            }
            case WEST: {
                return 2;
            }
            case NORTH: {
                return 4;
            }
            case EAST: 
        }
        return 8;
    }

    @Override
    public int getToolType() {
        return 4;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.FOLIAGE_BLOCK_COLOR;
    }

    @Override
    public boolean breaksWhenMoved() {
        return true;
    }

    @Override
    public boolean sticksToPiston() {
        return false;
    }

    @Override
    public boolean canSilkTouch() {
        return true;
    }
}

