/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.blockentity;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.blockentity.BlockEntitySpawnable;
import cn.nukkit.inventory.BeaconInventory;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.potion.Effect;
import java.util.Map;

public class BlockEntityBeacon
extends BlockEntitySpawnable {
    private long currentTick = 0L;
    private static final int POWER_LEVEL_MAX = 4;

    public BlockEntityBeacon(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
    }

    @Override
    protected void initBlockEntity() {
        if (!this.namedTag.contains("Lock")) {
            this.namedTag.putString("Lock", "");
        }
        if (!this.namedTag.contains("Levels")) {
            this.namedTag.putInt("Levels", 0);
        }
        if (!this.namedTag.contains("Primary")) {
            this.namedTag.putInt("Primary", 0);
        }
        if (!this.namedTag.contains("Secondary")) {
            this.namedTag.putInt("Secondary", 0);
        }
        this.scheduleUpdate();
        super.initBlockEntity();
    }

    @Override
    public boolean isBlockEntityValid() {
        int blockID = this.getBlock().getId();
        return blockID == 138;
    }

    @Override
    public CompoundTag getSpawnCompound() {
        return new CompoundTag().putString("id", "Beacon").putInt("x", (int)this.x).putInt("y", (int)this.y).putInt("z", (int)this.z).putString("Lock", this.namedTag.getString("Lock")).putInt("Levels", this.namedTag.getInt("Levels")).putInt("Primary", this.namedTag.getInt("Primary")).putInt("Secondary", this.namedTag.getInt("Secondary"));
    }

    @Override
    public boolean onUpdate() {
        if (this.currentTick++ % 80L != 0L) {
            return true;
        }
        int oldPowerLevel = this.getPowerLevel();
        this.setPowerLevel(this.calculatePowerLevel());
        int newPowerLevel = this.getPowerLevel();
        if (newPowerLevel < 1 || !this.hasSkyAccess()) {
            if (oldPowerLevel > 0) {
                this.getLevel().addLevelSoundEvent(this, 231);
            }
            return true;
        }
        if (oldPowerLevel < 1) {
            this.getLevel().addLevelSoundEvent(this, 229);
        } else {
            this.getLevel().addLevelSoundEvent(this, 230);
        }
        Map<Long, Player> players = this.level.getPlayers();
        int range = 10 + this.getPowerLevel() * 10;
        int duration = 9 + this.getPowerLevel() * 2;
        for (Map.Entry<Long, Player> entry : players.entrySet()) {
            Effect e;
            Player p = entry.getValue();
            if (!(p.distance(this) < (double)range)) continue;
            if (this.getPrimaryPower() != 0) {
                e = Effect.getEffect(this.getPrimaryPower());
                e.setDuration(duration * 20);
                if (this.getSecondaryPower() == this.getPrimaryPower()) {
                    e.setAmplifier(1);
                } else {
                    e.setAmplifier(0);
                }
                e.setVisible(false);
                p.addEffect(e);
            }
            if (this.getSecondaryPower() != 10) continue;
            e = Effect.getEffect(10);
            e.setDuration(duration * 20);
            e.setAmplifier(1);
            e.setVisible(false);
            p.addEffect(e);
        }
        return true;
    }

    private boolean hasSkyAccess() {
        int tileX = this.getFloorX();
        int tileY = this.getFloorY();
        int tileZ = this.getFloorZ();
        for (int y = tileY + 1; y <= 255; ++y) {
            int testBlockId = this.level.getBlockIdAt(tileX, y, tileZ);
            if (Block.transparent[testBlockId]) continue;
            return false;
        }
        return true;
    }

    private int calculatePowerLevel() {
        int tileX = this.getFloorX();
        int tileY = this.getFloorY();
        int tileZ = this.getFloorZ();
        for (int powerLevel = 1; powerLevel <= 4; ++powerLevel) {
            int queryY = tileY - powerLevel;
            for (int queryX = tileX - powerLevel; queryX <= tileX + powerLevel; ++queryX) {
                for (int queryZ = tileZ - powerLevel; queryZ <= tileZ + powerLevel; ++queryZ) {
                    int testBlockId = this.level.getBlockIdAt(queryX, queryY, queryZ);
                    if (testBlockId == 42 || testBlockId == 41 || testBlockId == 133 || testBlockId == 57) continue;
                    return powerLevel - 1;
                }
            }
        }
        return 4;
    }

    public int getPowerLevel() {
        return this.namedTag.getInt("Level");
    }

    public void setPowerLevel(int level) {
        int currentLevel = this.getPowerLevel();
        if (level != currentLevel) {
            this.namedTag.putInt("Level", level);
            this.setDirty();
            this.spawnToAll();
        }
    }

    public int getPrimaryPower() {
        return this.namedTag.getInt("Primary");
    }

    public void setPrimaryPower(int power) {
        int currentPower = this.getPrimaryPower();
        if (power != currentPower) {
            this.namedTag.putInt("Primary", power);
            this.setDirty();
            this.spawnToAll();
        }
    }

    public int getSecondaryPower() {
        return this.namedTag.getInt("Secondary");
    }

    public void setSecondaryPower(int power) {
        int currentPower = this.getSecondaryPower();
        if (power != currentPower) {
            this.namedTag.putInt("Secondary", power);
            this.setDirty();
            this.spawnToAll();
        }
    }

    @Override
    public boolean updateCompoundTag(CompoundTag nbt, Player player) {
        if (!nbt.getString("id").equals("Beacon")) {
            return false;
        }
        this.setPrimaryPower(nbt.getInt("primary"));
        this.setSecondaryPower(nbt.getInt("secondary"));
        this.getLevel().addLevelSoundEvent(this, 232);
        BeaconInventory inv = (BeaconInventory)player.getWindowById(4);
        inv.setItem(0, new ItemBlock(Block.get(0), (Integer)0, 0));
        return true;
    }
}

