/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.blockentity;

import cn.nukkit.Player;
import cn.nukkit.api.DeprecationDetails;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockBrewingStand;
import cn.nukkit.blockentity.BlockEntityContainer;
import cn.nukkit.blockentity.BlockEntityNameable;
import cn.nukkit.blockentity.BlockEntitySpawnable;
import cn.nukkit.event.inventory.BrewEvent;
import cn.nukkit.event.inventory.InventoryEvent;
import cn.nukkit.event.inventory.StartBrewEvent;
import cn.nukkit.inventory.BrewingInventory;
import cn.nukkit.inventory.ContainerRecipe;
import cn.nukkit.inventory.CraftingManager;
import cn.nukkit.inventory.InventoryHolder;
import cn.nukkit.inventory.MixRecipe;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.NBTIO;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.network.protocol.ContainerSetDataPacket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class BlockEntityBrewingStand
extends BlockEntitySpawnable
implements InventoryHolder,
BlockEntityContainer,
BlockEntityNameable {
    protected BrewingInventory inventory;
    public static final int MAX_BREW_TIME = 400;
    public int brewTime;
    public int fuelTotal;
    public int fuelAmount;
    @Deprecated
    @DeprecationDetails(since="1.3.1.2-PN", reason="Makes no sense and is unused", replaceWith="Use CraftingManager")
    public static final List<Integer> ingredients = new ArrayList<Integer>(Arrays.asList(372, 370, 348, 331, 289, 378, 377, 396, 375, 376, 382, 353, 414, 462, 469, 470, 437));

    public BlockEntityBrewingStand(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
    }

    @Override
    protected void initBlockEntity() {
        this.inventory = new BrewingInventory(this);
        if (!this.namedTag.contains("Items") || !(this.namedTag.get("Items") instanceof ListTag)) {
            this.namedTag.putList(new ListTag("Items"));
        }
        for (int i = 0; i < this.getSize(); ++i) {
            this.inventory.setItem(i, this.getItem(i));
        }
        this.brewTime = !this.namedTag.contains("CookTime") || this.namedTag.getShort("CookTime") > 400 ? 400 : this.namedTag.getShort("CookTime");
        this.fuelAmount = this.namedTag.getShort("FuelAmount");
        this.fuelTotal = this.namedTag.getShort("FuelTotal");
        if (this.brewTime < 400) {
            this.scheduleUpdate();
        }
        super.initBlockEntity();
    }

    @Override
    public String getName() {
        return this.hasName() ? this.namedTag.getString("CustomName") : "Brewing Stand";
    }

    @Override
    public boolean hasName() {
        return this.namedTag.contains("CustomName");
    }

    @Override
    public void setName(String name) {
        if (name == null || name.equals("")) {
            this.namedTag.remove("CustomName");
            return;
        }
        this.namedTag.putString("CustomName", name);
    }

    @Override
    public void close() {
        if (!this.closed) {
            for (Player player : new HashSet<Player>(this.getInventory().getViewers())) {
                player.removeWindow(this.getInventory());
            }
            super.close();
        }
    }

    @Override
    public void onBreak() {
        for (Item content : this.inventory.getContents().values()) {
            this.level.dropItem(this, content);
        }
        this.inventory.clearAll();
    }

    @Override
    public void saveNBT() {
        this.namedTag.putList(new ListTag("Items"));
        for (int index = 0; index < this.getSize(); ++index) {
            this.setItem(index, this.inventory.getItem(index));
        }
        this.namedTag.putShort("CookTime", this.brewTime);
        this.namedTag.putShort("FuelAmount", this.fuelAmount);
        this.namedTag.putShort("FuelTotal", this.fuelTotal);
    }

    @Override
    public boolean isBlockEntityValid() {
        return this.getBlock().getId() == 117;
    }

    @Override
    public int getSize() {
        return 5;
    }

    protected int getSlotIndex(int index) {
        ListTag<CompoundTag> list = this.namedTag.getList("Items", CompoundTag.class);
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i).getByte("Slot") != index) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Item getItem(int index) {
        int i = this.getSlotIndex(index);
        if (i < 0) {
            return new ItemBlock(Block.get(0), (Integer)0, 0);
        }
        CompoundTag data = (CompoundTag)this.namedTag.getList("Items").get(i);
        return NBTIO.getItemHelper(data);
    }

    @Override
    public void setItem(int index, Item item) {
        int i = this.getSlotIndex(index);
        CompoundTag d = NBTIO.putItemHelper(item, index);
        if (item.getId() == 0 || item.getCount() <= 0) {
            if (i >= 0) {
                this.namedTag.getList("Items").getAll().remove(i);
            }
        } else if (i < 0) {
            this.namedTag.getList("Items", CompoundTag.class).add(d);
        } else {
            this.namedTag.getList("Items", CompoundTag.class).add(i, d);
        }
    }

    @Override
    public BrewingInventory getInventory() {
        return this.inventory;
    }

    @Deprecated
    @DeprecationDetails(since="1.3.1.2-PN", reason="Checks the wrong location")
    protected boolean checkIngredient(Item ingredient) {
        return ingredients.contains(ingredient.getId());
    }

    @Override
    @PowerNukkitDifference(info="Fixed a lot of issues involving the brewing processes", since="1.3.1.2-PN")
    public boolean onUpdate() {
        InventoryEvent e;
        if (this.closed) {
            return false;
        }
        this.restockFuel();
        if (this.fuelAmount <= 0 || this.matchRecipes(true)[0] == null) {
            this.stopBrewing();
            return false;
        }
        if (this.brewTime == 400) {
            e = new StartBrewEvent(this);
            this.server.getPluginManager().callEvent(e);
            if (e.isCancelled()) {
                return false;
            }
            this.sendBrewTime();
        }
        if (--this.brewTime > 0) {
            if (this.brewTime % 40 == 0) {
                this.sendBrewTime();
            }
            return true;
        }
        e = new BrewEvent(this);
        this.server.getPluginManager().callEvent(e);
        if (e.isCancelled()) {
            this.stopBrewing();
            return true;
        }
        boolean mixed = false;
        MixRecipe[] recipes = this.matchRecipes(false);
        for (int i = 0; i < 3; ++i) {
            Item previous;
            MixRecipe recipe = recipes[i];
            if (recipe == null || (previous = this.inventory.getItem(i + 1)).isNull()) continue;
            Item result = recipe.getResult();
            result.setCount(previous.getCount());
            if (recipe instanceof ContainerRecipe) {
                result.setDamage(previous.getDamage());
            }
            this.inventory.setItem(i + 1, result);
            mixed = true;
        }
        if (mixed) {
            Item ingredient = this.inventory.getIngredient();
            --ingredient.count;
            this.inventory.setIngredient(ingredient);
            --this.fuelAmount;
            this.sendFuel();
            this.getLevel().addLevelSoundEvent(this, 128);
        }
        this.stopBrewing();
        return true;
    }

    private void restockFuel() {
        Item fuel = this.getInventory().getFuel();
        if (this.fuelAmount > 0 || fuel.getId() != 377 || fuel.getCount() <= 0) {
            return;
        }
        --fuel.count;
        this.fuelAmount = 20;
        this.fuelTotal = 20;
        this.inventory.setFuel(fuel);
        this.sendFuel();
    }

    private void stopBrewing() {
        this.brewTime = 0;
        this.sendBrewTime();
        this.brewTime = 400;
    }

    private MixRecipe[] matchRecipes(boolean quickTest) {
        MixRecipe[] recipes = new MixRecipe[quickTest ? 1 : 3];
        Item ingredient = this.inventory.getIngredient();
        CraftingManager craftingManager = this.getLevel().getServer().getCraftingManager();
        for (int i = 0; i < 3; ++i) {
            Item potion = this.inventory.getItem(i + 1);
            if (potion.isNull()) continue;
            MixRecipe recipe = craftingManager.matchBrewingRecipe(ingredient, potion);
            if (recipe == null) {
                recipe = craftingManager.matchContainerRecipe(ingredient, potion);
            }
            if (recipe == null) continue;
            if (quickTest) {
                recipes[0] = recipe;
                return recipes;
            }
            recipes[i] = recipe;
        }
        return recipes;
    }

    protected void sendFuel() {
        ContainerSetDataPacket pk = new ContainerSetDataPacket();
        for (Player p : this.inventory.getViewers()) {
            int windowId = p.getWindowId(this.inventory);
            if (windowId <= 0) continue;
            pk.windowId = windowId;
            pk.property = 1;
            pk.value = this.fuelAmount;
            p.dataPacket(pk);
            pk.property = 2;
            pk.value = this.fuelTotal;
            p.dataPacket(pk);
        }
    }

    protected void sendBrewTime() {
        ContainerSetDataPacket pk = new ContainerSetDataPacket();
        pk.property = 0;
        pk.value = this.brewTime;
        for (Player p : this.inventory.getViewers()) {
            int windowId = p.getWindowId(this.inventory);
            if (windowId <= 0) continue;
            pk.windowId = windowId;
            p.dataPacket(pk);
        }
    }

    @PowerNukkitDifference(info="Will stop the processing if there are no other matching recipe", since="1.3.1.2-PN")
    public void updateBlock() {
        Block block = this.getLevelBlock();
        if (!(block instanceof BlockBrewingStand)) {
            return;
        }
        int meta = 0;
        for (int i = 1; i <= 3; ++i) {
            Item potion = this.inventory.getItem(i);
            int id = potion.getId();
            if (id != 373 && id != 438 && id != 441 || potion.getCount() <= 0) continue;
            meta |= 1 << i - 1;
        }
        block.setDamage(meta);
        this.level.setBlock((Vector3)block, block, false, false);
        if (this.brewTime != 400 && this.matchRecipes(true)[0] == null) {
            this.stopBrewing();
        }
    }

    public int getFuel() {
        return this.fuelAmount;
    }

    public void setFuel(int fuel) {
        this.fuelAmount = fuel;
    }

    @Override
    public CompoundTag getSpawnCompound() {
        CompoundTag nbt = new CompoundTag().putString("id", "BrewingStand").putInt("x", (int)this.x).putInt("y", (int)this.y).putInt("z", (int)this.z).putShort("FuelTotal", this.fuelTotal).putShort("FuelAmount", this.fuelAmount);
        if (this.brewTime < 400) {
            nbt.putShort("CookTime", this.brewTime);
        }
        if (this.hasName()) {
            nbt.put("CustomName", this.namedTag.get("CustomName"));
        }
        return nbt;
    }
}

