/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.blockentity;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.blockentity.BlockEntityContainer;
import cn.nukkit.blockentity.BlockEntityFurnace;
import cn.nukkit.blockentity.BlockEntityNameable;
import cn.nukkit.blockentity.BlockEntitySpawnable;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.item.EntityItem;
import cn.nukkit.event.inventory.InventoryMoveItemEvent;
import cn.nukkit.inventory.Fuel;
import cn.nukkit.inventory.FurnaceInventory;
import cn.nukkit.inventory.HopperInventory;
import cn.nukkit.inventory.Inventory;
import cn.nukkit.inventory.InventoryHolder;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.SimpleAxisAlignedBB;
import cn.nukkit.nbt.NBTIO;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.ListTag;
import java.util.HashSet;

public class BlockEntityHopper
extends BlockEntitySpawnable
implements InventoryHolder,
BlockEntityContainer,
BlockEntityNameable {
    protected HopperInventory inventory;
    public int transferCooldown;
    private AxisAlignedBB pickupArea;

    public BlockEntityHopper(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
    }

    @Override
    protected void initBlockEntity() {
        this.transferCooldown = this.namedTag.contains("TransferCooldown") ? this.namedTag.getInt("TransferCooldown") : 8;
        this.inventory = new HopperInventory(this);
        if (!this.namedTag.contains("Items") || !(this.namedTag.get("Items") instanceof ListTag)) {
            this.namedTag.putList(new ListTag("Items"));
        }
        for (int i = 0; i < this.getSize(); ++i) {
            this.inventory.setItem(i, this.getItem(i));
        }
        this.pickupArea = new SimpleAxisAlignedBB(this.x, this.y, this.z, this.x + 1.0, this.y + 2.0, this.z + 1.0);
        this.scheduleUpdate();
        super.initBlockEntity();
    }

    @Override
    public boolean isBlockEntityValid() {
        return this.level.getBlockIdAt(this.getFloorX(), this.getFloorY(), this.getFloorZ()) == 154;
    }

    @Override
    public String getName() {
        return this.hasName() ? this.namedTag.getString("CustomName") : "Hopper";
    }

    @Override
    public boolean hasName() {
        return this.namedTag.contains("CustomName");
    }

    @Override
    public void setName(String name) {
        if (name == null || name.equals("")) {
            this.namedTag.remove("CustomName");
            return;
        }
        this.namedTag.putString("CustomName", name);
    }

    public boolean isOnTransferCooldown() {
        return this.transferCooldown > 0;
    }

    public void setTransferCooldown(int transferCooldown) {
        this.transferCooldown = transferCooldown;
    }

    @Override
    public int getSize() {
        return 5;
    }

    protected int getSlotIndex(int index) {
        ListTag<CompoundTag> list = this.namedTag.getList("Items", CompoundTag.class);
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i).getByte("Slot") != index) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Item getItem(int index) {
        int i = this.getSlotIndex(index);
        if (i < 0) {
            return new ItemBlock(Block.get(0), (Integer)0, 0);
        }
        CompoundTag data = (CompoundTag)this.namedTag.getList("Items").get(i);
        return NBTIO.getItemHelper(data);
    }

    @Override
    public void setItem(int index, Item item) {
        int i = this.getSlotIndex(index);
        CompoundTag d = NBTIO.putItemHelper(item, index);
        if (item.getId() == 0 || item.getCount() <= 0) {
            if (i >= 0) {
                this.namedTag.getList("Items").getAll().remove(i);
            }
        } else if (i < 0) {
            this.namedTag.getList("Items", CompoundTag.class).add(d);
        } else {
            this.namedTag.getList("Items", CompoundTag.class).add(i, d);
        }
    }

    @Override
    public void saveNBT() {
        this.namedTag.putList(new ListTag("Items"));
        for (int index = 0; index < this.getSize(); ++index) {
            this.setItem(index, this.inventory.getItem(index));
        }
        this.namedTag.putInt("TransferCooldown", this.transferCooldown);
    }

    @Override
    public HopperInventory getInventory() {
        return this.inventory;
    }

    @Override
    public boolean onUpdate() {
        if (this.closed) {
            return false;
        }
        --this.transferCooldown;
        if (this.level.isBlockPowered(this.getBlock())) {
            return true;
        }
        if (!this.isOnTransferCooldown()) {
            if ((this.level.getBlockDataAt(this.getFloorX(), this.getFloorY(), this.getFloorZ()) & 8) == 8) {
                return false;
            }
            BlockEntity blockEntity = this.level.getBlockEntity(this.up());
            boolean changed = this.pushItems();
            if (blockEntity instanceof InventoryHolder) {
                changed = this.pullItems() || changed;
            } else {
                boolean bl = changed = this.pickupItems() || changed;
            }
            if (changed) {
                this.setTransferCooldown(8);
                this.setDirty();
            }
        }
        return true;
    }

    public boolean pullItems() {
        if (this.inventory.isFull()) {
            return false;
        }
        BlockEntity blockEntity = this.level.getBlockEntity(this.up());
        if (blockEntity instanceof BlockEntityFurnace) {
            FurnaceInventory inv = ((BlockEntityFurnace)blockEntity).getInventory();
            Item item = inv.getResult();
            if (!item.isNull()) {
                Item itemToAdd = item.clone();
                itemToAdd.count = 1;
                if (!this.inventory.canAddItem(itemToAdd)) {
                    return false;
                }
                InventoryMoveItemEvent ev = new InventoryMoveItemEvent(inv, this.inventory, this, itemToAdd, InventoryMoveItemEvent.Action.SLOT_CHANGE);
                this.server.getPluginManager().callEvent(ev);
                if (ev.isCancelled()) {
                    return false;
                }
                Item[] items = this.inventory.addItem(itemToAdd);
                if (items.length <= 0) {
                    --item.count;
                    inv.setResult(item);
                    return true;
                }
            }
        } else if (blockEntity instanceof InventoryHolder) {
            Inventory inv = ((InventoryHolder)((Object)blockEntity)).getInventory();
            for (int i = 0; i < inv.getSize(); ++i) {
                Item item = inv.getItem(i);
                if (item.isNull()) continue;
                Item itemToAdd = item.clone();
                itemToAdd.count = 1;
                if (!this.inventory.canAddItem(itemToAdd)) continue;
                InventoryMoveItemEvent ev = new InventoryMoveItemEvent(inv, this.inventory, this, itemToAdd, InventoryMoveItemEvent.Action.SLOT_CHANGE);
                this.server.getPluginManager().callEvent(ev);
                if (ev.isCancelled()) continue;
                Item[] items = this.inventory.addItem(itemToAdd);
                if (items.length >= 1) continue;
                --item.count;
                inv.setItem(i, item);
                return true;
            }
        }
        return false;
    }

    public boolean pickupItems() {
        if (this.inventory.isFull()) {
            return false;
        }
        boolean pickedUpItem = false;
        for (Entity entity : this.level.getCollidingEntities(this.pickupArea)) {
            EntityItem itemEntity;
            Item item;
            if (entity.isClosed() || !(entity instanceof EntityItem) || (item = (itemEntity = (EntityItem)entity).getItem()).isNull()) continue;
            int originalCount = item.getCount();
            if (!this.inventory.canAddItem(item)) continue;
            InventoryMoveItemEvent ev = new InventoryMoveItemEvent(null, this.inventory, this, item, InventoryMoveItemEvent.Action.PICKUP);
            this.server.getPluginManager().callEvent(ev);
            if (ev.isCancelled()) continue;
            Item[] items = this.inventory.addItem(item);
            if (items.length == 0) {
                entity.close();
                pickedUpItem = true;
                continue;
            }
            if (items[0].getCount() == originalCount) continue;
            pickedUpItem = true;
            item.setCount(items[0].getCount());
        }
        return pickedUpItem;
    }

    @Override
    public void close() {
        if (!this.closed) {
            for (Player player : new HashSet<Player>(this.getInventory().getViewers())) {
                player.removeWindow(this.getInventory());
            }
            super.close();
        }
    }

    @Override
    public void onBreak() {
        for (Item content : this.inventory.getContents().values()) {
            this.level.dropItem(this, content);
        }
        this.inventory.clearAll();
    }

    public boolean pushItems() {
        if (this.inventory.isEmpty()) {
            return false;
        }
        BlockEntity be = this.level.getBlockEntity(this.getSide(BlockFace.fromIndex(this.level.getBlockDataAt(this.getFloorX(), this.getFloorY(), this.getFloorZ()))));
        if (be instanceof BlockEntityHopper && this.getBlock().getDamage() == 0 || !(be instanceof InventoryHolder)) {
            return false;
        }
        if (be instanceof BlockEntityFurnace) {
            BlockEntityFurnace furnace = (BlockEntityFurnace)be;
            FurnaceInventory inventory = furnace.getInventory();
            if (inventory.isFull()) {
                return false;
            }
            boolean pushedItem = false;
            for (int i = 0; i < this.inventory.getSize(); ++i) {
                InventoryMoveItemEvent event;
                Item item = this.inventory.getItem(i);
                if (item.isNull()) continue;
                Item itemToAdd = item.clone();
                itemToAdd.setCount(1);
                if (this.getBlock().getDamage() == 0) {
                    Item smelting = inventory.getSmelting();
                    if (smelting.isNull()) {
                        event = new InventoryMoveItemEvent(this.inventory, inventory, this, itemToAdd, InventoryMoveItemEvent.Action.SLOT_CHANGE);
                        this.server.getPluginManager().callEvent(event);
                        if (!event.isCancelled()) {
                            inventory.setSmelting(itemToAdd);
                            --item.count;
                            pushedItem = true;
                        }
                    } else if (inventory.getSmelting().getId() == itemToAdd.getId() && inventory.getSmelting().getDamage() == itemToAdd.getDamage() && smelting.count < smelting.getMaxStackSize()) {
                        event = new InventoryMoveItemEvent(this.inventory, inventory, this, itemToAdd, InventoryMoveItemEvent.Action.SLOT_CHANGE);
                        this.server.getPluginManager().callEvent(event);
                        if (!event.isCancelled()) {
                            ++smelting.count;
                            inventory.setSmelting(smelting);
                            --item.count;
                            pushedItem = true;
                        }
                    }
                } else if (Fuel.duration.containsKey(itemToAdd.getId())) {
                    Item fuel = inventory.getFuel();
                    if (fuel.isNull()) {
                        event = new InventoryMoveItemEvent(this.inventory, inventory, this, itemToAdd, InventoryMoveItemEvent.Action.SLOT_CHANGE);
                        this.server.getPluginManager().callEvent(event);
                        if (!event.isCancelled()) {
                            inventory.setFuel(itemToAdd);
                            --item.count;
                            pushedItem = true;
                        }
                    } else if (fuel.getId() == itemToAdd.getId() && fuel.getDamage() == itemToAdd.getDamage() && fuel.count < fuel.getMaxStackSize()) {
                        event = new InventoryMoveItemEvent(this.inventory, inventory, this, itemToAdd, InventoryMoveItemEvent.Action.SLOT_CHANGE);
                        this.server.getPluginManager().callEvent(event);
                        if (!event.isCancelled()) {
                            ++fuel.count;
                            inventory.setFuel(fuel);
                            --item.count;
                            pushedItem = true;
                        }
                    }
                }
                if (!pushedItem) continue;
                this.inventory.setItem(i, item);
            }
            return pushedItem;
        }
        Inventory inventory = ((InventoryHolder)((Object)be)).getInventory();
        if (inventory.isFull()) {
            return false;
        }
        for (int i = 0; i < this.inventory.getSize(); ++i) {
            Item[] items;
            Item item = this.inventory.getItem(i);
            if (item.isNull()) continue;
            Item itemToAdd = item.clone();
            itemToAdd.setCount(1);
            if (!inventory.canAddItem(itemToAdd)) continue;
            InventoryMoveItemEvent ev = new InventoryMoveItemEvent(this.inventory, inventory, this, itemToAdd, InventoryMoveItemEvent.Action.SLOT_CHANGE);
            this.server.getPluginManager().callEvent(ev);
            if (ev.isCancelled() || (items = inventory.addItem(itemToAdd)).length > 0) continue;
            --item.count;
            this.inventory.setItem(i, item);
            return true;
        }
        return false;
    }

    @Override
    public CompoundTag getSpawnCompound() {
        CompoundTag c = new CompoundTag().putString("id", "Hopper").putInt("x", (int)this.x).putInt("y", (int)this.y).putInt("z", (int)this.z);
        if (this.hasName()) {
            c.put("CustomName", this.namedTag.get("CustomName"));
        }
        return c;
    }
}

