/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.blockentity;

import cn.nukkit.blockentity.BlockEntitySpawnable;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemRecord;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.nbt.NBTIO;
import cn.nukkit.nbt.tag.CompoundTag;
import java.util.Objects;

public class BlockEntityJukebox
extends BlockEntitySpawnable {
    private Item recordItem;

    public BlockEntityJukebox(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
    }

    @Override
    protected void initBlockEntity() {
        this.recordItem = this.namedTag.contains("RecordItem") ? NBTIO.getItemHelper(this.namedTag.getCompound("RecordItem")) : Item.get(0);
        super.initBlockEntity();
    }

    @Override
    public boolean isBlockEntityValid() {
        return this.getLevel().getBlockIdAt(this.getFloorX(), this.getFloorY(), this.getFloorZ()) == 84;
    }

    public void setRecordItem(Item recordItem) {
        Objects.requireNonNull(recordItem, "Record item cannot be null");
        this.recordItem = recordItem;
    }

    public Item getRecordItem() {
        return this.recordItem;
    }

    public void play() {
        if (this.recordItem instanceof ItemRecord) {
            switch (this.recordItem.getId()) {
                case 500: {
                    this.getLevel().addLevelSoundEvent(this, 101);
                    break;
                }
                case 501: {
                    this.getLevel().addLevelSoundEvent(this, 102);
                    break;
                }
                case 502: {
                    this.getLevel().addLevelSoundEvent(this, 103);
                    break;
                }
                case 503: {
                    this.getLevel().addLevelSoundEvent(this, 104);
                    break;
                }
                case 504: {
                    this.getLevel().addLevelSoundEvent(this, 105);
                    break;
                }
                case 505: {
                    this.getLevel().addLevelSoundEvent(this, 106);
                    break;
                }
                case 506: {
                    this.getLevel().addLevelSoundEvent(this, 107);
                    break;
                }
                case 507: {
                    this.getLevel().addLevelSoundEvent(this, 108);
                    break;
                }
                case 508: {
                    this.getLevel().addLevelSoundEvent(this, 109);
                    break;
                }
                case 509: {
                    this.getLevel().addLevelSoundEvent(this, 110);
                    break;
                }
                case 510: {
                    this.getLevel().addLevelSoundEvent(this, 111);
                    break;
                }
                case 511: {
                    this.getLevel().addLevelSoundEvent(this, 112);
                    break;
                }
                case 759: {
                    this.getLevel().addLevelSoundEvent(this, 314);
                }
            }
        }
    }

    public void stop() {
        this.getLevel().addLevelSoundEvent(this, 113);
    }

    public void dropItem() {
        if (this.recordItem.getId() != 0) {
            this.stop();
            this.level.dropItem(this.up(), this.recordItem);
            this.recordItem = Item.get(0);
        }
    }

    @Override
    public void saveNBT() {
        super.saveNBT();
        this.namedTag.putCompound("RecordItem", NBTIO.putItemHelper(this.recordItem));
    }

    @Override
    public CompoundTag getSpawnCompound() {
        return BlockEntityJukebox.getDefaultCompound(this, "Jukebox").putCompound("RecordItem", NBTIO.putItemHelper(this.recordItem));
    }

    @Override
    public void onBreak() {
        this.dropItem();
    }
}

