/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.blockentity;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockAir;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.blockentity.BlockEntityMovingBlock;
import cn.nukkit.blockentity.BlockEntitySpawnable;
import cn.nukkit.entity.Entity;
import cn.nukkit.event.entity.EntityMoveByPistonEvent;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.BlockVector3;
import cn.nukkit.math.SimpleAxisAlignedBB;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.IntTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.utils.Faceable;
import java.util.ArrayList;
import java.util.List;

@PowerNukkitDifference(info="The piston will work as close as possible to vanilla")
public class BlockEntityPistonArm
extends BlockEntitySpawnable {
    public static final float MOVE_STEP = Float.valueOf(0.5f).floatValue();
    public float progress;
    public float lastProgress = 1.0f;
    public BlockFace facing;
    public boolean extending;
    public boolean sticky;
    public int state;
    public int newState = 1;
    public List<BlockVector3> attachedBlocks;
    public boolean powered;

    public BlockEntityPistonArm(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
    }

    @Override
    protected void initBlockEntity() {
        Block b;
        if (this.namedTag.contains("Progress")) {
            this.progress = this.namedTag.getFloat("Progress");
        }
        if (this.namedTag.contains("LastProgress")) {
            this.lastProgress = this.namedTag.getInt("LastProgress");
        }
        this.sticky = this.namedTag.getBoolean("Sticky");
        this.extending = this.namedTag.getBoolean("Extending");
        this.powered = this.namedTag.getBoolean("powered");
        this.facing = this.namedTag.contains("facing") ? BlockFace.fromIndex(this.namedTag.getInt("facing")) : ((b = this.getLevelBlock()) instanceof Faceable ? ((Faceable)((Object)b)).getBlockFace() : BlockFace.NORTH);
        this.attachedBlocks = new ArrayList<BlockVector3>();
        if (this.namedTag.contains("AttachedBlocks")) {
            ListTag<IntTag> blocks = this.namedTag.getList("AttachedBlocks", IntTag.class);
            if (blocks != null && blocks.size() > 0) {
                for (int i = 0; i < blocks.size(); i += 3) {
                    this.attachedBlocks.add(new BlockVector3(blocks.get((int)i).data, blocks.get((int)(i + 1)).data, blocks.get((int)(i + 1)).data));
                }
            }
        } else {
            this.namedTag.putList(new ListTag("AttachedBlocks"));
        }
        super.initBlockEntity();
    }

    private void moveCollidedEntities() {
        Entity[] entities;
        BlockFace pushDir = this.extending ? this.facing : this.facing.getOpposite();
        for (BlockVector3 pos : this.attachedBlocks) {
            BlockEntity blockEntity = this.level.getBlockEntity(pos.getSide(pushDir));
            if (!(blockEntity instanceof BlockEntityMovingBlock)) continue;
            ((BlockEntityMovingBlock)blockEntity).moveCollidedEntities(this, pushDir);
        }
        AxisAlignedBB bb = new SimpleAxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).getOffsetBoundingBox(this.x + (double)((float)pushDir.getXOffset() * this.progress), this.y + (double)((float)pushDir.getYOffset() * this.progress), this.z + (double)((float)pushDir.getZOffset() * this.progress));
        for (Entity entity : entities = this.level.getCollidingEntities(bb)) {
            this.moveEntity(entity, pushDir);
        }
    }

    void moveEntity(Entity entity, BlockFace moveDirection) {
        if (!entity.canBePushed()) {
            return;
        }
        EntityMoveByPistonEvent event = new EntityMoveByPistonEvent(entity, entity.getPosition());
        this.level.getServer().getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            return;
        }
        if (entity instanceof Player) {
            return;
        }
        entity.onPushByPiston(this);
        if (!entity.closed) {
            float diff = Math.abs(this.progress - this.lastProgress);
            entity.move(diff * (float)moveDirection.getXOffset(), diff * (float)moveDirection.getYOffset(), diff * (float)moveDirection.getZOffset());
        }
    }

    public void move(boolean extending, List<BlockVector3> attachedBlocks) {
        this.extending = extending;
        this.progress = extending ? 0.0f : 1.0f;
        this.lastProgress = this.progress;
        this.newState = extending ? 1 : 3;
        this.state = this.newState;
        this.attachedBlocks = attachedBlocks;
        this.movable = false;
        this.level.addChunkPacket(this.getChunkX(), this.getChunkZ(), this.getSpawnPacket());
        this.lastProgress = extending ? -MOVE_STEP : 1.0f + MOVE_STEP;
        this.moveCollidedEntities();
        this.scheduleUpdate();
    }

    @Override
    public boolean onUpdate() {
        boolean hasUpdate = true;
        if (this.extending) {
            this.progress = Math.min(1.0f, this.progress + MOVE_STEP);
            this.lastProgress = Math.min(1.0f, this.lastProgress + MOVE_STEP);
        } else {
            this.progress = Math.max(0.0f, this.progress - MOVE_STEP);
            this.lastProgress = Math.max(0.0f, this.lastProgress - MOVE_STEP);
        }
        this.moveCollidedEntities();
        if (this.progress == this.lastProgress) {
            this.newState = this.extending ? 2 : 0;
            this.state = this.newState;
            BlockFace pushDir = this.extending ? this.facing : this.facing.getOpposite();
            for (BlockVector3 pos : this.attachedBlocks) {
                BlockEntity movingBlock = this.level.getBlockEntity(pos.getSide(pushDir));
                if (!(movingBlock instanceof BlockEntityMovingBlock)) continue;
                movingBlock.close();
                Block moved = ((BlockEntityMovingBlock)movingBlock).getMovingBlock();
                CompoundTag blockEntity = ((BlockEntityMovingBlock)movingBlock).getBlockEntity();
                if (blockEntity != null) {
                    blockEntity.putInt("x", movingBlock.getFloorX());
                    blockEntity.putInt("y", movingBlock.getFloorY());
                    blockEntity.putInt("z", movingBlock.getFloorZ());
                    BlockEntity.createBlockEntity(blockEntity.getString("id"), this.level.getChunk(movingBlock.getChunkX(), movingBlock.getChunkZ()), blockEntity, new Object[0]);
                }
                this.level.setBlock(movingBlock, moved);
            }
            if (!this.extending) {
                if (this.level.getBlock(this.getSide(this.facing)).getId() == (this.sticky ? 472 : 34)) {
                    this.level.setBlock(this.getSide(this.facing), new BlockAir());
                }
                this.movable = true;
            }
            this.level.scheduleUpdate(this.getLevelBlock(), 1);
            this.attachedBlocks.clear();
            hasUpdate = false;
        }
        this.level.addChunkPacket(this.getChunkX(), this.getChunkZ(), this.getSpawnPacket());
        return super.onUpdate() || hasUpdate;
    }

    private float getExtendedProgress(float progress) {
        return this.extending ? progress - 1.0f : 1.0f - progress;
    }

    @Override
    public boolean isBlockEntityValid() {
        return true;
    }

    @Override
    public void saveNBT() {
        super.saveNBT();
        this.namedTag.putByte("State", this.state);
        this.namedTag.putByte("NewState", this.newState);
        this.namedTag.putFloat("Progress", this.progress);
        this.namedTag.putFloat("LastProgress", this.lastProgress);
        this.namedTag.putBoolean("powered", this.powered);
        this.namedTag.putList(this.getAttachedBlocks());
        this.namedTag.putInt("facing", this.facing.getIndex());
    }

    @Override
    public CompoundTag getSpawnCompound() {
        return new CompoundTag().putString("id", "PistonArm").putInt("x", (int)this.x).putInt("y", (int)this.y).putInt("z", (int)this.z).putFloat("Progress", this.progress).putFloat("LastProgress", this.lastProgress).putBoolean("isMovable", this.movable).putList(this.getAttachedBlocks()).putList(new ListTag("BreakBlocks")).putBoolean("Sticky", this.sticky).putByte("State", this.state).putByte("NewState", this.newState);
    }

    private ListTag<IntTag> getAttachedBlocks() {
        ListTag<IntTag> attachedBlocks = new ListTag<IntTag>("AttachedBlocks");
        for (BlockVector3 block : this.attachedBlocks) {
            attachedBlocks.add(new IntTag("", block.x));
            attachedBlocks.add(new IntTag("", block.y));
            attachedBlocks.add(new IntTag("", block.z));
        }
        return attachedBlocks;
    }
}

