/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.command.defaults;

import cn.nukkit.Player;
import cn.nukkit.command.Command;
import cn.nukkit.command.CommandSender;
import cn.nukkit.command.data.CommandParamType;
import cn.nukkit.command.data.CommandParameter;
import cn.nukkit.command.defaults.VanillaCommand;
import cn.nukkit.event.player.PlayerTeleportEvent;
import cn.nukkit.lang.TranslationContainer;
import cn.nukkit.level.Location;
import cn.nukkit.math.NukkitMath;
import cn.nukkit.utils.TextFormat;

public class TeleportCommand
extends VanillaCommand {
    public TeleportCommand(String name) {
        super(name, "%nukkit.command.tp.description", "%commands.tp.usage");
        this.setPermission("nukkit.command.teleport");
        this.commandParameters.clear();
        this.commandParameters.put("->Player", new CommandParameter[]{CommandParameter.newType("destination", CommandParamType.TARGET)});
        this.commandParameters.put("Player->Player", new CommandParameter[]{CommandParameter.newType("victim", CommandParamType.TARGET), CommandParameter.newType("destination", CommandParamType.TARGET)});
        this.commandParameters.put("Player->Pos", new CommandParameter[]{CommandParameter.newType("victim", CommandParamType.TARGET), CommandParameter.newType("destination", CommandParamType.POSITION), CommandParameter.newType("yRot", true, CommandParamType.VALUE), CommandParameter.newType("xRot", true, CommandParamType.VALUE)});
        this.commandParameters.put("->Pos", new CommandParameter[]{CommandParameter.newType("destination", CommandParamType.POSITION), CommandParameter.newType("yRot", true, CommandParamType.VALUE), CommandParameter.newType("xRot", true, CommandParamType.VALUE)});
    }

    @Override
    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        CommandSender target;
        if (!this.testPermission(sender)) {
            return true;
        }
        if (args.length < 1 || args.length > 6) {
            sender.sendMessage(new TranslationContainer("commands.generic.usage", this.usageMessage));
            return true;
        }
        CommandSender origin = sender;
        if (args.length == 1 || args.length == 3 || args.length == 5) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(new TranslationContainer("commands.generic.ingame"));
                return true;
            }
            target = sender;
            if (args.length == 1 && (target = sender.getServer().getPlayer(args[0].replace("@s", sender.getName()))) == null) {
                sender.sendMessage((Object)((Object)TextFormat.RED) + "Can't find player " + args[0]);
                return true;
            }
        } else {
            target = sender.getServer().getPlayer(args[0].replace("@s", sender.getName()));
            if (target == null) {
                sender.sendMessage((Object)((Object)TextFormat.RED) + "Can't find player " + args[0]);
                return true;
            }
            if (args.length == 2) {
                origin = target;
                target = sender.getServer().getPlayer(args[1].replace("@s", sender.getName()));
                if (target == null) {
                    sender.sendMessage((Object)((Object)TextFormat.RED) + "Can't find player " + args[1]);
                    return true;
                }
            }
        }
        if (args.length < 3) {
            ((Player)origin).teleport((Player)target, PlayerTeleportEvent.TeleportCause.COMMAND);
            Command.broadcastCommandMessage(sender, new TranslationContainer("commands.tp.success", origin.getName(), target.getName()));
            return true;
        }
        if (((Player)target).getLevel() != null) {
            double pitch;
            double yaw;
            double z;
            double y;
            double x;
            int pos = args.length == 4 || args.length == 6 ? 1 : 0;
            try {
                x = this.parseTilde(args[pos++], ((Player)target).x);
                y = this.parseTilde(args[pos++], ((Player)target).y);
                z = this.parseTilde(args[pos++], ((Player)target).z);
                if (args.length > pos) {
                    yaw = Integer.parseInt(args[pos++]);
                    pitch = Integer.parseInt(args[pos]);
                } else {
                    yaw = ((Player)target).getYaw();
                    pitch = ((Player)target).getPitch();
                }
            }
            catch (NumberFormatException e1) {
                sender.sendMessage(new TranslationContainer("commands.generic.usage", this.usageMessage));
                return true;
            }
            ((Player)target).teleport(new Location(x, y, z, yaw, pitch, ((Player)target).getLevel()), PlayerTeleportEvent.TeleportCause.COMMAND);
            Command.broadcastCommandMessage(sender, new TranslationContainer("commands.tp.success.coordinates", target.getName(), String.valueOf(NukkitMath.round(x, 2)), String.valueOf(NukkitMath.round(y, 2)), String.valueOf(NukkitMath.round(z, 2))));
            return true;
        }
        sender.sendMessage(new TranslationContainer("commands.generic.usage", this.usageMessage));
        return true;
    }
}

