/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.console;

import cn.nukkit.Server;
import java.util.List;
import java.util.TreeSet;
import java.util.function.Consumer;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;

public class NukkitConsoleCompleter
implements Completer {
    private final Server server;

    public void complete(LineReader lineReader, ParsedLine parsedLine, List<Candidate> candidates) {
        block4: {
            block3: {
                if (parsedLine.wordIndex() != 0) break block3;
                if (parsedLine.word().isEmpty()) {
                    this.addCandidates(s -> candidates.add(new Candidate(s)));
                    return;
                }
                TreeSet names = new TreeSet();
                this.addCandidates(names::add);
                for (String match : names) {
                    if (!match.toLowerCase().startsWith(parsedLine.word())) continue;
                    candidates.add(new Candidate(match));
                }
                break block4;
            }
            if (parsedLine.wordIndex() <= 0 || parsedLine.word().isEmpty()) break block4;
            String word = parsedLine.word();
            TreeSet names = new TreeSet();
            this.server.getOnlinePlayers().values().forEach(p -> names.add(p.getName()));
            for (String match : names) {
                if (!match.toLowerCase().startsWith(word.toLowerCase())) continue;
                candidates.add(new Candidate(match));
            }
        }
    }

    private void addCandidates(Consumer<String> commandConsumer) {
        for (String command : this.server.getCommandMap().getCommands().keySet()) {
            if (command.contains(":")) continue;
            commandConsumer.accept(command);
        }
    }

    public NukkitConsoleCompleter(Server server) {
        this.server = server;
    }
}

