/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.dispenser;

import cn.nukkit.block.BlockDispenser;
import cn.nukkit.dispenser.DispenseBehavior;
import cn.nukkit.item.Item;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

public class DefaultDispenseBehavior
implements DispenseBehavior {
    public boolean success = true;

    @Override
    public Item dispense(BlockDispenser block, BlockFace face, Item item) {
        Vector3 dispensePos = block.getDispensePosition();
        dispensePos.y = face.getAxis() == BlockFace.Axis.Y ? (dispensePos.y -= 0.125) : (dispensePos.y -= 0.15625);
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        Vector3 motion = new Vector3();
        double offset = ((Random)rand).nextDouble() * 0.1 + 0.2;
        motion.x = (double)face.getXOffset() * offset;
        motion.y = 0.2f;
        motion.z = (double)face.getZOffset() * offset;
        motion.x += rand.nextGaussian() * (double)0.0075f * 6.0;
        motion.y += rand.nextGaussian() * (double)0.0075f * 6.0;
        motion.z += rand.nextGaussian() * (double)0.0075f * 6.0;
        Item clone = item.clone();
        clone.count = 1;
        block.level.dropItem(dispensePos, clone, motion);
        return null;
    }

    private int getParticleMetadataForFace(BlockFace face) {
        return face.getXOffset() + 1 + (face.getZOffset() + 1) * 3;
    }
}

